#include "snd.h"

enum {GRAY_COLORMAP, HSV_COLORMAP, HOT_COLORMAP, COOL_COLORMAP, BONE_COLORMAP, COPPER_COLORMAP, PINK_COLORMAP, JET_COLORMAP, PRISM_COLORMAP,
      AUTUMN_COLORMAP, WINTER_COLORMAP, SPRING_COLORMAP, SUMMER_COLORMAP, COLORCUBE_COLORMAP, FLAG_COLORMAP, LINES_COLORMAP};

static char *colormaps[] = {"gray","hsv","hot","cool","bone","copper","pink","jet","prism",
			    "autumn","winter","spring","summer","colorcube","flag","lines"};

char **colormap_names(void) {return(colormaps);}

#ifndef WITH_BIG_COLORMAP
static unsigned short hsv_colormap[] = {65535, 0, 0, 65535, 6147, 0, 65535, 12287, 0, 65535, 18428, 0, 65535, 24575, 0, 65535, 30722, 0, 65535, 36863, 0, 65535, 43004, 0, 65535, 49151, 0, 65535, 55298, 0, 65535, 61439, 0, 63490, 65535, 0, 57343, 65535, 0, 51195, 65535, 0, 45055, 65535, 0, 38914, 65535, 0, 32767, 65535, 0, 26620, 65535, 0, 20479, 65535, 0, 14339, 65535, 0, 8191, 65535, 0, 2044, 65535, 0, 0, 65535, 4095, 0, 65535, 10236, 0, 65535, 16383, 0, 65535, 22530, 0, 65535, 28671, 0, 65535, 34812, 0, 65535, 40959, 0, 65535, 47106, 0, 65535, 53247, 0, 65535, 59387, 0, 65535, 65535, 0, 59387, 65535, 0, 53247, 65535, 0, 47106, 65535, 0, 40959, 65535, 0, 34812, 65535, 0, 28671, 65535, 0, 22530, 65535, 0, 16383, 65535, 0, 10236, 65535, 0, 4095, 65535, 2044, 0, 65535, 8191, 0, 65535, 14339, 0, 65535, 20479, 0, 65535, 26620, 0, 65535, 32767, 0, 65535, 38914, 0, 65535, 45055, 0, 65535, 51195, 0, 65535, 57343, 0, 65535, 63490, 0, 65535, 65535, 0, 61439, 65535, 0, 55298, 65535, 0, 49151, 65535, 0, 43004, 65535, 0, 36863, 65535, 0, 30722, 65535, 0, 24575, 65535, 0, 18428, 65535, 0, 12287, 65535, 0, 6147};

static unsigned short gray_colormap[] = {0, 0, 0, 1042, 1042, 1042, 2077, 2077, 2077, 3119, 3119, 3119, 4161, 4161, 4161, 5203, 5203, 5203, 6238, 6238, 6238, 7280, 7280, 7280, 8322, 8322, 8322, 9364, 9364, 9364, 10400, 10400, 10400, 11442, 11442, 11442, 12484, 12484, 12484, 13519, 13519, 13519, 14561, 14561, 14561, 15603, 15603, 15603, 16645, 16645, 16645, 17681, 17681, 17681, 18723, 18723, 18723, 19765, 19765, 19765, 20807, 20807, 20807, 21842, 21842, 21842, 22884, 22884, 22884, 23926, 23926, 23926, 24968, 24968, 24968, 26004, 26004, 26004, 27046, 27046, 27046, 28088, 28088, 28088, 29123, 29123, 29123, 30165, 30165, 30165, 31207, 31207, 31207, 32249, 32249, 32249, 33285, 33285, 33285, 34327, 34327, 34327, 35369, 35369, 35369, 36411, 36411, 36411, 37446, 37446, 37446, 38488, 38488, 38488, 39530, 39530, 39530, 40566, 40566, 40566, 41608, 41608, 41608, 42650, 42650, 42650, 43692, 43692, 43692, 44727, 44727, 44727, 45769, 45769, 45769, 46811, 46811, 46811, 47853, 47853, 47853, 48889, 48889, 48889, 49931, 49931, 49931, 50973, 50973, 50973, 52015, 52015, 52015, 53050, 53050, 53050, 54092, 54092, 54092, 55134, 55134, 55134, 56170, 56170, 56170, 57212, 57212, 57212, 58254, 58254, 58254, 59296, 59296, 59296, 60331, 60331, 60331, 61373, 61373, 61373, 62415, 62415, 62415, 63457, 63457, 63457, 64492, 64492, 64492, 65535, 65535, 65535};

static unsigned short hot_colormap[] = {2732, 0, 0, 5459, 0, 0, 8191, 0, 0, 10924, 0, 0, 13650, 0, 0, 16383, 0, 0, 19116, 0, 0, 21842, 0, 0, 24575, 0, 0, 27308, 0, 0, 30034, 0, 0, 32767, 0, 0, 35500, 0, 0, 38226, 0, 0, 40959, 0, 0, 43692, 0, 0, 46418, 0, 0, 49151, 0, 0, 51884, 0, 0, 54610, 0, 0, 57343, 0, 0, 60075, 0, 0, 62802, 0, 0, 65535, 0, 0, 65535, 2732, 0, 65535, 5459, 0, 65535, 8191, 0, 65535, 10924, 0, 65535, 13650, 0, 65535, 16383, 0, 65535, 19116, 0, 65535, 21842, 0, 65535, 24575, 0, 65535, 27308, 0, 65535, 30034, 0, 65535, 32767, 0, 65535, 35500, 0, 65535, 38226, 0, 65535, 40959, 0, 65535, 43692, 0, 65535, 46418, 0, 65535, 49151, 0, 65535, 51884, 0, 65535, 54610, 0, 65535, 57343, 0, 65535, 60075, 0, 65535, 62802, 0, 65535, 65535, 0, 65535, 65535, 4095, 65535, 65535, 8191, 65535, 65535, 12287, 65535, 65535, 16383, 65535, 65535, 20479, 65535, 65535, 24575, 65535, 65535, 28671, 65535, 65535, 32767, 65535, 65535, 36863, 65535, 65535, 40959, 65535, 65535, 45055, 65535, 65535, 49151, 65535, 65535, 53247, 65535, 65535, 57343, 65535, 65535, 61439, 65535, 65535, 65535};

static unsigned short cool_colormap[] = {0, 65535, 65535, 1042, 64492, 65535, 2077, 63457, 65535, 3119, 62415, 65535, 4161, 61373, 65535, 5203, 60331, 65535, 6238, 59296, 65535, 7280, 58254, 65535, 8322, 57212, 65535, 9364, 56170, 65535, 10400, 55134, 65535, 11442, 54092, 65535, 12484, 53050, 65535, 13519, 52015, 65535, 14561, 50973, 65535, 15603, 49931, 65535, 16645, 48889, 65535, 17681, 47853, 65535, 18723, 46811, 65535, 19765, 45769, 65535, 20807, 44727, 65535, 21842, 43692, 65535, 22884, 42650, 65535, 23926, 41608, 65535, 24968, 40566, 65535, 26004, 39530, 65535, 27046, 38488, 65535, 28088, 37446, 65535, 29123, 36411, 65535, 30165, 35369, 65535, 31207, 34327, 65535, 32249, 33285, 65535, 33285, 32249, 65535, 34327, 31207, 65535, 35369, 30165, 65535, 36411, 29123, 65535, 37446, 28088, 65535, 38488, 27046, 65535, 39530, 26004, 65535, 40566, 24968, 65535, 41608, 23926, 65535, 42650, 22884, 65535, 43692, 21842, 65535, 44727, 20807, 65535, 45769, 19765, 65535, 46811, 18723, 65535, 47853, 17681, 65535, 48889, 16645, 65535, 49931, 15603, 65535, 50973, 14561, 65535, 52015, 13519, 65535, 53050, 12484, 65535, 54092, 11442, 65535, 55134, 10400, 65535, 56170, 9364, 65535, 57212, 8322, 65535, 58254, 7280, 65535, 59296, 6238, 65535, 60331, 5203, 65535, 61373, 4161, 65535, 62415, 3119, 65535, 63457, 2077, 65535, 64492, 1042, 65535, 65535, 0, 65535};

static unsigned short bone_colormap[] = {0, 0, 340, 910, 910, 1592, 1821, 1821, 2844, 2732, 2732, 4095, 3643, 3643, 5347, 4548, 4548, 6599, 5459, 5459, 7851, 6370, 6370, 9102, 7280, 7280, 10354, 8191, 8191, 11606, 9102, 9102, 12857, 10013, 10013, 14109, 10924, 10924, 15361, 11835, 11835, 16613, 12740, 12740, 17864, 13650, 13650, 19116, 14561, 14561, 20368, 15472, 15472, 21619, 16383, 16383, 22871, 17294, 17294, 24123, 18205, 18205, 25375, 19116, 19116, 26620, 20027, 20027, 27872, 20931, 20931, 29123, 21842, 22183, 30034, 22753, 23435, 30945, 23664, 24687, 31856, 24575, 25938, 32767, 25486, 27190, 33678, 26397, 28442, 34589, 27308, 29693, 35500, 28219, 30945, 36411, 29123, 32197, 37315, 30034, 33449, 38226, 30945, 34700, 39137, 31856, 35952, 40048, 32767, 37204, 40959, 33678, 38455, 41870, 34589, 39707, 42781, 35500, 40959, 43692, 36411, 42211, 44603, 37315, 43462, 45507, 38226, 44714, 46418, 39137, 45966, 47329, 40048, 47217, 48240, 40959, 48469, 49151, 41870, 49721, 50062, 42781, 50973, 50973, 44203, 51884, 51884, 45625, 52794, 52794, 47047, 53699, 53699, 48469, 54610, 54610, 49891, 55521, 55521, 51313, 56432, 56432, 52736, 57343, 57343, 54158, 58254, 58254, 55580, 59165, 59165, 57002, 60075, 60075, 58424, 60986, 60986, 59846, 61891, 61891, 61268, 62802, 62802, 62690, 63713, 63713, 64112, 64624, 64624, 65535, 65535, 65535};

static unsigned short copper_colormap[] = {0, 0, 0, 1297, 812, 517, 2601, 1625, 1035, 3899, 2437, 1553, 5203, 3250, 2070, 6501, 4063, 2588, 7798, 4875, 3106, 9102, 5688, 3624, 10400, 6501, 4141, 11704, 7313, 4659, 13002, 8126, 5177, 14306, 8938, 5694, 15603, 9751, 6212, 16901, 10564, 6730, 18205, 11376, 7248, 19503, 12189, 7765, 20807, 13002, 8277, 22104, 13814, 8794, 23402, 14627, 9312, 24706, 15440, 9830, 26004, 16252, 10347, 27308, 17065, 10865, 28606, 17877, 11383, 29903, 18690, 11901, 31207, 19503, 12418, 32505, 20315, 12936, 33809, 21128, 13454, 35107, 21941, 13972, 36411, 22753, 14489, 37708, 23566, 15007, 39006, 24379, 15525, 40310, 25191, 16042, 41608, 26004, 16560, 42912, 26816, 17078, 44209, 27629, 17596, 45507, 28442, 18113, 46811, 29254, 18631, 48109, 30067, 19149, 49413, 30880, 19667, 50710, 31692, 20184, 52015, 32505, 20702, 53312, 33317, 21220, 54610, 34130, 21737, 55914, 34943, 22255, 57212, 35755, 22773, 58516, 36568, 23291, 59813, 37381, 23808, 61111, 38193, 24326, 62415, 39006, 24837, 63713, 39819, 25355, 65017, 40631, 25873, 65535, 41444, 26390, 65535, 42256, 26908, 65535, 43069, 27426, 65535, 43882, 27944, 65535, 44694, 28461, 65535, 45507, 28979, 65535, 46320, 29497, 65535, 47132, 30015, 65535, 47945, 30532, 65535, 48758, 31050, 65535, 49570, 31568, 65535, 50383, 32085, 65535, 51195, 32603};

static unsigned short pink_colormap[] = {7726, 0, 0, 12838, 6743, 6743, 16429, 9535, 9535, 19365, 11678, 11678, 21908, 13480, 13480, 24188, 15073, 15073, 26272, 16514, 16514, 28199, 17838, 17838, 30008, 19070, 19070, 31712, 20224, 20224, 33324, 21318, 21318, 34864, 22360, 22360, 36345, 23350, 23350, 37761, 24306, 24306, 39130, 25224, 25224, 40448, 26109, 26109, 41726, 26967, 26967, 42971, 27793, 27793, 44177, 28599, 28599, 45350, 29385, 29385, 46490, 30146, 30146, 47611, 30893, 30893, 48699, 31620, 31620, 49767, 32328, 32328, 50226, 33914, 33029, 50671, 35434, 33704, 51117, 36883, 34373, 51562, 38285, 35028, 52002, 39635, 35670, 52434, 40939, 36306, 52867, 42204, 36922, 53299, 43430, 37531, 53719, 44622, 38134, 54145, 45782, 38724, 54557, 46916, 39307, 54977, 48024, 39884, 55390, 49105, 40448, 55796, 50167, 41005, 56202, 51202, 41555, 56602, 52218, 42099, 57002, 53214, 42637, 57402, 54197, 43167, 57795, 55154, 43692, 58188, 56097, 44209, 58575, 57028, 44721, 58961, 57946, 45225, 59348, 58843, 45723, 59728, 59728, 46215, 60108, 60108, 47657, 60488, 60488, 49052, 60862, 60862, 50409, 61235, 61235, 51726, 61602, 61602, 53017, 61969, 61969, 54276, 62336, 62336, 55501, 62697, 62697, 56707, 63064, 63064, 57880, 63418, 63418, 59033, 63778, 63778, 60167, 64132, 64132, 61281, 64486, 64486, 62369, 64840, 64840, 63444, 65187, 65187, 64499, 65535, 65535, 65535};

static unsigned short jet_colormap[] = {0, 0, 36863, 0, 0, 40959, 0, 0, 45055, 0, 0, 49151, 0, 0, 53247, 0, 0, 57343, 0, 0, 61439, 0, 0, 65535, 0, 4095, 65535, 0, 8191, 65535, 0, 12287, 65535, 0, 16383, 65535, 0, 20479, 65535, 0, 24575, 65535, 0, 28671, 65535, 0, 32767, 65535, 0, 36863, 65535, 0, 40959, 65535, 0, 45055, 65535, 0, 49151, 65535, 0, 53247, 65535, 0, 57343, 65535, 0, 61439, 65535, 0, 65535, 65535, 4095, 65535, 65535, 8191, 65535, 61439, 12287, 65535, 57343, 16383, 65535, 53247, 20479, 65535, 49151, 24575, 65535, 45055, 28671, 65535, 40959, 32767, 65535, 36863, 36863, 65535, 32767, 40959, 65535, 28671, 45055, 65535, 24575, 49151, 65535, 20479, 53247, 65535, 16383, 57343, 65535, 12287, 61439, 65535, 8191, 65535, 65535, 4095, 65535, 65535, 0, 65535, 61439, 0, 65535, 57343, 0, 65535, 53247, 0, 65535, 49151, 0, 65535, 45055, 0, 65535, 40959, 0, 65535, 36863, 0, 65535, 32767, 0, 65535, 28671, 0, 65535, 24575, 0, 65535, 20479, 0, 65535, 16383, 0, 65535, 12287, 0, 65535, 8191, 0, 65535, 4095, 0, 65535, 0, 0, 61439, 0, 0, 57343, 0, 0, 53247, 0, 0, 49151, 0, 0, 45055, 0, 0, 40959, 0, 0, 36863, 0, 0};

static unsigned short prism_colormap[] = {65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43692, 0, 65535, 65535, 0, 0, 65535, 32767, 0, 65535, 65535, 0, 0, 65535, 0};

static unsigned short autumn_colormap[] = {65535, 0, 0, 65535, 1042, 0, 65535, 2077, 0, 65535, 3120, 0, 65535, 4162, 0, 65535, 5204, 0, 65535, 6239, 0, 65535, 7281, 0, 65535, 8323, 0, 65535, 9365, 0, 65535, 10401, 0, 65535, 11443, 0, 65535, 12485, 0, 65535, 13520, 0, 65535, 14562, 0, 65535, 15604, 0, 65535, 16646, 0, 65535, 17682, 0, 65535, 18724, 0, 65535, 19766, 0, 65535, 20808, 0, 65535, 21843, 0, 65535, 22885, 0, 65535, 23927, 0, 65535, 24969, 0, 65535, 26005, 0, 65535, 27047, 0, 65535, 28089, 0, 65535, 29124, 0, 65535, 30166, 0, 65535, 31208, 0, 65535, 32250, 0, 65535, 33286, 0, 65535, 34328, 0, 65535, 35370, 0, 65535, 36412, 0, 65535, 37447, 0, 65535, 38489, 0, 65535, 39531, 0, 65535, 40567, 0, 65535, 41609, 0, 65535, 42651, 0, 65535, 43693, 0, 65535, 44728, 0, 65535, 45770, 0, 65535, 46812, 0, 65535, 47854, 0, 65535, 48890, 0, 65535, 49932, 0, 65535, 50974, 0, 65535, 52016, 0, 65535, 53051, 0, 65535, 54093, 0, 65535, 55135, 0, 65535, 56171, 0, 65535, 57213, 0, 65535, 58255, 0, 65535, 59297, 0, 65535, 60332, 0, 65535, 61374, 0, 65535, 62416, 0, 65535, 63459, 0, 65535, 64494, 0, 65535, 65535, 0};

static unsigned short winter_colormap[] = {0, 0, 65535, 0, 1042, 65018, 0, 2077, 64494, 0, 3120, 63976, 0, 4162, 63459, 0, 5204, 62934, 0, 6239, 62416, 0, 7281, 61892, 0, 8323, 61374, 0, 9365, 60857, 0, 10401, 60332, 0, 11443, 59815, 0, 12485, 59297, 0, 13520, 58773, 0, 14562, 58255, 0, 15604, 57737, 0, 16646, 57213, 0, 17682, 56695, 0, 18724, 56171, 0, 19766, 55653, 0, 20808, 55135, 0, 21843, 54611, 0, 22885, 54093, 0, 23927, 53576, 0, 24969, 53051, 0, 26005, 52534, 0, 27047, 52016, 0, 28089, 51492, 0, 29124, 50974, 0, 30166, 50450, 0, 31208, 49932, 0, 32250, 49414, 0, 33286, 48890, 0, 34328, 48372, 0, 35370, 47854, 0, 36412, 47330, 0, 37447, 46812, 0, 38489, 46288, 0, 39531, 45770, 0, 40567, 45253, 0, 41609, 44728, 0, 42651, 44211, 0, 43693, 43693, 0, 44728, 43169, 0, 45770, 42651, 0, 46812, 42133, 0, 47854, 41609, 0, 48890, 41091, 0, 49932, 40567, 0, 50974, 40049, 0, 52016, 39531, 0, 53051, 39007, 0, 54093, 38489, 0, 55135, 37972, 0, 56171, 37447, 0, 57213, 36930, 0, 58255, 36412, 0, 59297, 35888, 0, 60332, 35370, 0, 61374, 34845, 0, 62416, 34328, 0, 63459, 33810, 0, 64494, 33286, 0, 65535, 32768};

static unsigned short spring_colormap[] = {65535, 0, 65535, 65535, 1042, 64494, 65535, 2077, 63459, 65535, 3120, 62416, 65535, 4162, 61374, 65535, 5204, 60332, 65535, 6239, 59297, 65535, 7281, 58255, 65535, 8323, 57213, 65535, 9365, 56171, 65535, 10401, 55135, 65535, 11443, 54093, 65535, 12485, 53051, 65535, 13520, 52016, 65535, 14562, 50974, 65535, 15604, 49932, 65535, 16646, 48890, 65535, 17682, 47854, 65535, 18724, 46812, 65535, 19766, 45770, 65535, 20808, 44728, 65535, 21843, 43693, 65535, 22885, 42651, 65535, 23927, 41609, 65535, 24969, 40567, 65535, 26005, 39531, 65535, 27047, 38489, 65535, 28089, 37447, 65535, 29124, 36412, 65535, 30166, 35370, 65535, 31208, 34328, 65535, 32250, 33286, 65535, 33286, 32250, 65535, 34328, 31208, 65535, 35370, 30166, 65535, 36412, 29124, 65535, 37447, 28089, 65535, 38489, 27047, 65535, 39531, 26005, 65535, 40567, 24969, 65535, 41609, 23927, 65535, 42651, 22885, 65535, 43693, 21843, 65535, 44728, 20808, 65535, 45770, 19766, 65535, 46812, 18724, 65535, 47854, 17682, 65535, 48890, 16646, 65535, 49932, 15604, 65535, 50974, 14562, 65535, 52016, 13520, 65535, 53051, 12485, 65535, 54093, 11443, 65535, 55135, 10401, 65535, 56171, 9365, 65535, 57213, 8323, 65535, 58255, 7281, 65535, 59297, 6239, 65535, 60332, 5204, 65535, 61374, 4162, 65535, 62416, 3120, 65535, 63459, 2077, 65535, 64494, 1042, 65535, 65535, 0};

static unsigned short summer_colormap[] = {0, 32768, 26214, 1042, 33286, 26214, 2077, 33810, 26214, 3120, 34328, 26214, 4162, 34845, 26214, 5204, 35370, 26214, 6239, 35888, 26214, 7281, 36412, 26214, 8323, 36930, 26214, 9365, 37447, 26214, 10401, 37972, 26214, 11443, 38489, 26214, 12485, 39007, 26214, 13520, 39531, 26214, 14562, 40049, 26214, 15604, 40567, 26214, 16646, 41091, 26214, 17682, 41609, 26214, 18724, 42133, 26214, 19766, 42651, 26214, 20808, 43169, 26214, 21843, 43693, 26214, 22885, 44211, 26214, 23927, 44728, 26214, 24969, 45253, 26214, 26005, 45770, 26214, 27047, 46288, 26214, 28089, 46812, 26214, 29124, 47330, 26214, 30166, 47854, 26214, 31208, 48372, 26214, 32250, 48890, 26214, 33286, 49414, 26214, 34328, 49932, 26214, 35370, 50450, 26214, 36412, 50974, 26214, 37447, 51492, 26214, 38489, 52016, 26214, 39531, 52534, 26214, 40567, 53051, 26214, 41609, 53576, 26214, 42651, 54093, 26214, 43693, 54611, 26214, 44728, 55135, 26214, 45770, 55653, 26214, 46812, 56171, 26214, 47854, 56695, 26214, 48890, 57213, 26214, 49932, 57737, 26214, 50974, 58255, 26214, 52016, 58773, 26214, 53051, 59297, 26214, 54093, 59815, 26214, 55135, 60332, 26214, 56171, 60857, 26214, 57213, 61374, 26214, 58255, 61892, 26214, 59297, 62416, 26214, 60332, 62934, 26214, 61374, 63459, 26214, 62416, 63976, 26214, 63459, 64494, 26214, 64494, 65018, 26214, 65535, 65535, 26214};

static unsigned short colorcube_colormap[] = {21843, 21843, 0, 21843, 43693, 0, 21843, 65535, 0, 43693, 21843, 0, 43693, 43693, 0, 43693, 65535, 0, 65535, 21843, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 21843, 32768, 0, 43693, 32768, 0, 65535, 32768, 21843, 0, 32768, 21843, 21843, 32768, 21843, 43693, 32768, 21843, 65535, 32768, 43693, 0, 32768, 43693, 21843, 32768, 43693, 43693, 32768, 43693, 65535, 32768, 65535, 0, 32768, 65535, 21843, 32768, 65535, 43693, 32768, 65535, 65535, 32768, 0, 21843, 65535, 0, 43693, 65535, 0, 65535, 65535, 21843, 0, 65535, 21843, 21843, 65535, 21843, 43693, 65535, 21843, 65535, 65535, 43693, 0, 65535, 43693, 21843, 65535, 43693, 43693, 65535, 43693, 65535, 65535, 65535, 0, 65535, 65535, 21843, 65535, 65535, 43693, 65535, 10925, 0, 0, 21843, 0, 0, 32768, 0, 0, 43693, 0, 0, 54611, 0, 0, 65535, 0, 0, 0, 10925, 0, 0, 21843, 0, 0, 32768, 0, 0, 43693, 0, 0, 54611, 0, 0, 65535, 0, 0, 0, 10925, 0, 0, 21843, 0, 0, 32768, 0, 0, 43693, 0, 0, 54611, 0, 0, 65535, 0, 0, 0, 9365, 9365, 9365, 18724, 18724, 18724, 28089, 28089, 28089, 37447, 37447, 37447, 46812, 46812, 46812, 56171, 56171, 56171, 65535, 65535, 65535};

static unsigned short flag_colormap[] = {65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0};

static unsigned short lines_colormap[] = {0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535};

#else

static unsigned short gray_colormap[] = {0, 0, 0, 131, 131, 131, 256, 256, 256, 387, 387, 387, 511, 511, 511, 642, 642, 642, 767, 767, 767, 898, 898, 898, 1029, 1029, 1029, 1153, 1153, 1153, 1285, 1285, 1285, 1409, 1409, 1409, 1540, 1540, 1540, 1665, 1665, 1665, 1796, 1796, 1796, 1927, 1927, 1927, 2051, 2051, 2051, 2182, 2182, 2182, 2307, 2307, 2307, 2438, 2438, 2438, 2562, 2562, 2562, 2694, 2694, 2694, 2825, 2825, 2825, 2949, 2949, 2949, 3080, 3080, 3080, 3205, 3205, 3205, 3336, 3336, 3336, 3460, 3460, 3460, 3591, 3591, 3591, 3722, 3722, 3722, 3847, 3847, 3847, 3978, 3978, 3978, 4103, 4103, 4103, 4234, 4234, 4234, 4358, 4358, 4358, 4489, 4489, 4489, 4620, 4620, 4620, 4745, 4745, 4745, 4876, 4876, 4876, 5000, 5000, 5000, 5131, 5131, 5131, 5256, 5256, 5256, 5387, 5387, 5387, 5512, 5512, 5512, 5643, 5643, 5643, 5774, 5774, 5774, 5898, 5898, 5898, 6029, 6029, 6029, 6154, 6154, 6154, 6285, 6285, 6285, 6409, 6409, 6409, 6540, 6540, 6540, 6672, 6672, 6672, 6796, 6796, 6796, 6927, 6927, 6927, 7052, 7052, 7052, 7183, 7183, 7183, 7307, 7307, 7307, 7438, 7438, 7438, 7569, 7569, 7569, 7694, 7694, 7694, 7825, 7825, 7825, 7950, 7950, 7950, 8081, 8081, 8081, 8205, 8205, 8205, 8336, 8336, 8336, 8467, 8467, 8467, 8592, 8592, 8592, 8723, 8723, 8723, 8847, 8847, 8847, 8978, 8978, 8978, 9103, 9103, 9103, 9234, 9234, 9234, 9365, 9365, 9365, 9490, 9490, 9490, 9621, 9621, 9621, 9745, 9745, 9745, 9876, 9876, 9876, 10001, 10001, 10001, 10132, 10132, 10132, 10263, 10263, 10263, 10387, 10387, 10387, 10519, 10519, 10519, 10643, 10643, 10643, 10774, 10774, 10774, 10899, 10899, 10899, 11030, 11030, 11030, 11161, 11161, 11161, 11285, 11285, 11285, 11416, 11416, 11416, 11541, 11541, 11541, 11672, 11672, 11672, 11796, 11796, 11796, 11928, 11928, 11928, 12059, 12059, 12059, 12183, 12183, 12183, 12314, 12314, 12314, 12439, 12439, 12439, 12570, 12570, 12570, 12694, 12694, 12694, 12825, 12825, 12825, 12956, 12956, 12956, 13081, 13081, 13081, 13212, 13212, 13212, 13337, 13337, 13337, 13468, 13468, 13468, 13592, 13592, 13592, 13723, 13723, 13723, 13854, 13854, 13854, 13979, 13979, 13979, 14110, 14110, 14110, 14234, 14234, 14234, 14365, 14365, 14365, 14490, 14490, 14490, 14621, 14621, 14621, 14746, 14746, 14746, 14877, 14877, 14877, 15008, 15008, 15008, 15132, 15132, 15132, 15263, 15263, 15263, 15388, 15388, 15388, 15519, 15519, 15519, 15643, 15643, 15643, 15775, 15775, 15775, 15906, 15906, 15906, 16030, 16030, 16030, 16161, 16161, 16161, 16286, 16286, 16286, 16417, 16417, 16417, 16541, 16541, 16541, 16672, 16672, 16672, 16803, 16803, 16803, 16928, 16928, 16928, 17059, 17059, 17059, 17184, 17184, 17184, 17315, 17315, 17315, 17439, 17439, 17439, 17570, 17570, 17570, 17701, 17701, 17701, 17826, 17826, 17826, 17957, 17957, 17957, 18081, 18081, 18081, 18212, 18212, 18212, 18337, 18337, 18337, 18468, 18468, 18468, 18599, 18599, 18599, 18724, 18724, 18724, 18855, 18855, 18855, 18979, 18979, 18979, 19110, 19110, 19110, 19235, 19235, 19235, 19366, 19366, 19366, 19497, 19497, 19497, 19621, 19621, 19621, 19753, 19753, 19753, 19877, 19877, 19877, 20008, 20008, 20008, 20133, 20133, 20133, 20264, 20264, 20264, 20395, 20395, 20395, 20519, 20519, 20519, 20650, 20650, 20650, 20775, 20775, 20775, 20906, 20906, 20906, 21031, 21031, 21031, 21162, 21162, 21162, 21293, 21293, 21293, 21417, 21417, 21417, 21548, 21548, 21548, 21673, 21673, 21673, 21804, 21804, 21804, 21928, 21928, 21928, 22059, 22059, 22059, 22190, 22190, 22190, 22315, 22315, 22315, 22446, 22446, 22446, 22571, 22571, 22571, 22702, 22702, 22702, 22826, 22826, 22826, 22957, 22957, 22957, 23088, 23088, 23088, 23213, 23213, 23213, 23344, 23344, 23344, 23468, 23468, 23468, 23600, 23600, 23600, 23724, 23724, 23724, 23855, 23855, 23855, 23980, 23980, 23980, 24111, 24111, 24111, 24242, 24242, 24242, 24366, 24366, 24366, 24497, 24497, 24497, 24622, 24622, 24622, 24753, 24753, 24753, 24877, 24877, 24877, 25009, 25009, 25009, 25140, 25140, 25140, 25264, 25264, 25264, 25395, 25395, 25395, 25520, 25520, 25520, 25651, 25651, 25651, 25775, 25775, 25775, 25906, 25906, 25906, 26037, 26037, 26037, 26162, 26162, 26162, 26293, 26293, 26293, 26418, 26418, 26418, 26549, 26549, 26549, 26673, 26673, 26673, 26804, 26804, 26804, 26935, 26935, 26935, 27060, 27060, 27060, 27191, 27191, 27191, 27315, 27315, 27315, 27446, 27446, 27446, 27571, 27571, 27571, 27702, 27702, 27702, 27833, 27833, 27833, 27958, 27958, 27958, 28089, 28089, 28089, 28213, 28213, 28213, 28344, 28344, 28344, 28469, 28469, 28469, 28600, 28600, 28600, 28731, 28731, 28731, 28856, 28856, 28856, 28987, 28987, 28987, 29111, 29111, 29111, 29242, 29242, 29242, 29367, 29367, 29367, 29498, 29498, 29498, 29629, 29629, 29629, 29753, 29753, 29753, 29884, 29884, 29884, 30009, 30009, 30009, 30140, 30140, 30140, 30265, 30265, 30265, 30396, 30396, 30396, 30527, 30527, 30527, 30651, 30651, 30651, 30782, 30782, 30782, 30907, 30907, 30907, 31038, 31038, 31038, 31162, 31162, 31162, 31293, 31293, 31293, 31425, 31425, 31425, 31549, 31549, 31549, 31680, 31680, 31680, 31805, 31805, 31805, 31936, 31936, 31936, 32060, 32060, 32060, 32191, 32191, 32191, 32322, 32322, 32322, 32447, 32447, 32447, 32578, 32578, 32578, 32702, 32702, 32702, 32834, 32834, 32834, 32958, 32958, 32958, 33089, 33089, 33089, 33214, 33214, 33214, 33345, 33345, 33345, 33476, 33476, 33476, 33600, 33600, 33600, 33731, 33731, 33731, 33856, 33856, 33856, 33987, 33987, 33987, 34111, 34111, 34111, 34243, 34243, 34243, 34374, 34374, 34374, 34498, 34498, 34498, 34629, 34629, 34629, 34754, 34754, 34754, 34885, 34885, 34885, 35009, 35009, 35009, 35140, 35140, 35140, 35271, 35271, 35271, 35396, 35396, 35396, 35527, 35527, 35527, 35652, 35652, 35652, 35783, 35783, 35783, 35907, 35907, 35907, 36038, 36038, 36038, 36169, 36169, 36169, 36294, 36294, 36294, 36425, 36425, 36425, 36549, 36549, 36549, 36680, 36680, 36680, 36805, 36805, 36805, 36936, 36936, 36936, 37067, 37067, 37067, 37192, 37192, 37192, 37323, 37323, 37323, 37447, 37447, 37447, 37578, 37578, 37578, 37703, 37703, 37703, 37834, 37834, 37834, 37965, 37965, 37965, 38090, 38090, 38090, 38221, 38221, 38221, 38345, 38345, 38345, 38476, 38476, 38476, 38601, 38601, 38601, 38732, 38732, 38732, 38863, 38863, 38863, 38987, 38987, 38987, 39118, 39118, 39118, 39243, 39243, 39243, 39374, 39374, 39374, 39499, 39499, 39499, 39630, 39630, 39630, 39761, 39761, 39761, 39885, 39885, 39885, 40016, 40016, 40016, 40141, 40141, 40141, 40272, 40272, 40272, 40396, 40396, 40396, 40527, 40527, 40527, 40659, 40659, 40659, 40783, 40783, 40783, 40914, 40914, 40914, 41039, 41039, 41039, 41170, 41170, 41170, 41294, 41294, 41294, 41425, 41425, 41425, 41556, 41556, 41556, 41681, 41681, 41681, 41812, 41812, 41812, 41936, 41936, 41936, 42068, 42068, 42068, 42192, 42192, 42192, 42323, 42323, 42323, 42448, 42448, 42448, 42579, 42579, 42579, 42710, 42710, 42710, 42834, 42834, 42834, 42965, 42965, 42965, 43090, 43090, 43090, 43221, 43221, 43221, 43346, 43346, 43346, 43477, 43477, 43477, 43608, 43608, 43608, 43732, 43732, 43732, 43863, 43863, 43863, 43988, 43988, 43988, 44119, 44119, 44119, 44243, 44243, 44243, 44374, 44374, 44374, 44505, 44505, 44505, 44630, 44630, 44630, 44761, 44761, 44761, 44886, 44886, 44886, 45017, 45017, 45017, 45141, 45141, 45141, 45272, 45272, 45272, 45403, 45403, 45403, 45528, 45528, 45528, 45659, 45659, 45659, 45783, 45783, 45783, 45915, 45915, 45915, 46039, 46039, 46039, 46170, 46170, 46170, 46301, 46301, 46301, 46426, 46426, 46426, 46557, 46557, 46557, 46681, 46681, 46681, 46812, 46812, 46812, 46937, 46937, 46937, 47068, 47068, 47068, 47199, 47199, 47199, 47324, 47324, 47324, 47455, 47455, 47455, 47579, 47579, 47579, 47710, 47710, 47710, 47835, 47835, 47835, 47966, 47966, 47966, 48097, 48097, 48097, 48221, 48221, 48221, 48352, 48352, 48352, 48477, 48477, 48477, 48608, 48608, 48608, 48733, 48733, 48733, 48864, 48864, 48864, 48995, 48995, 48995, 49119, 49119, 49119, 49250, 49250, 49250, 49375, 49375, 49375, 49506, 49506, 49506, 49630, 49630, 49630, 49761, 49761, 49761, 49893, 49893, 49893, 50017, 50017, 50017, 50148, 50148, 50148, 50273, 50273, 50273, 50404, 50404, 50404, 50528, 50528, 50528, 50659, 50659, 50659, 50790, 50790, 50790, 50915, 50915, 50915, 51046, 51046, 51046, 51171, 51171, 51171, 51302, 51302, 51302, 51426, 51426, 51426, 51557, 51557, 51557, 51682, 51682, 51682, 51813, 51813, 51813, 51944, 51944, 51944, 52068, 52068, 52068, 52199, 52199, 52199, 52324, 52324, 52324, 52455, 52455, 52455, 52580, 52580, 52580, 52711, 52711, 52711, 52842, 52842, 52842, 52966, 52966, 52966, 53097, 53097, 53097, 53222, 53222, 53222, 53353, 53353, 53353, 53477, 53477, 53477, 53608, 53608, 53608, 53740, 53740, 53740, 53864, 53864, 53864, 53995, 53995, 53995, 54120, 54120, 54120, 54251, 54251, 54251, 54375, 54375, 54375, 54506, 54506, 54506, 54637, 54637, 54637, 54762, 54762, 54762, 54893, 54893, 54893, 55017, 55017, 55017, 55149, 55149, 55149, 55273, 55273, 55273, 55404, 55404, 55404, 55535, 55535, 55535, 55660, 55660, 55660, 55791, 55791, 55791, 55915, 55915, 55915, 56046, 56046, 56046, 56171, 56171, 56171, 56302, 56302, 56302, 56433, 56433, 56433, 56558, 56558, 56558, 56689, 56689, 56689, 56813, 56813, 56813, 56944, 56944, 56944, 57069, 57069, 57069, 57200, 57200, 57200, 57331, 57331, 57331, 57455, 57455, 57455, 57586, 57586, 57586, 57711, 57711, 57711, 57842, 57842, 57842, 57967, 57967, 57967, 58098, 58098, 58098, 58229, 58229, 58229, 58353, 58353, 58353, 58484, 58484, 58484, 58609, 58609, 58609, 58740, 58740, 58740, 58864, 58864, 58864, 58996, 58996, 58996, 59127, 59127, 59127, 59251, 59251, 59251, 59382, 59382, 59382, 59507, 59507, 59507, 59638, 59638, 59638, 59762, 59762, 59762, 59893, 59893, 59893, 60024, 60024, 60024, 60149, 60149, 60149, 60280, 60280, 60280, 60405, 60405, 60405, 60536, 60536, 60536, 60660, 60660, 60660, 60791, 60791, 60791, 60916, 60916, 60916, 61047, 61047, 61047, 61178, 61178, 61178, 61302, 61302, 61302, 61433, 61433, 61433, 61558, 61558, 61558, 61689, 61689, 61689, 61814, 61814, 61814, 61945, 61945, 61945, 62076, 62076, 62076, 62200, 62200, 62200, 62331, 62331, 62331, 62456, 62456, 62456, 62587, 62587, 62587, 62711, 62711, 62711, 62842, 62842, 62842, 62974, 62974, 62974, 63098, 63098, 63098, 63229, 63229, 63229, 63354, 63354, 63354, 63485, 63485, 63485, 63609, 63609, 63609, 63740, 63740, 63740, 63871, 63871, 63871, 63996, 63996, 63996, 64127, 64127, 64127, 64251, 64251, 64251, 64383, 64383, 64383, 64507, 64507, 64507, 64638, 64638, 64638, 64769, 64769, 64769, 64894, 64894, 64894, 65025, 65025, 65025, 65149, 65149, 65149, 65280, 65280, 65280, 65405, 65405, 65405, 65535, 65535, 65535};

static unsigned short hsv_colormap[] = {65535, 0, 0, 65535, 767, 0, 65535, 1534, 0, 65535, 2307, 0, 65535, 3074, 0, 65535, 3840, 0, 65535, 4607, 0, 65535, 5374, 0, 65535, 6147, 0, 65535, 6914, 0, 65535, 7681, 0, 65535, 8448, 0, 65535, 9214, 0, 65535, 9981, 0, 65535, 10754, 0, 65535, 11521, 0, 65535, 12288, 0, 65535, 13055, 0, 65535, 13822, 0, 65535, 14595, 0, 65535, 15362, 0, 65535, 16128, 0, 65535, 16895, 0, 65535, 17662, 0, 65535, 18429, 0, 65535, 19202, 0, 65535, 19969, 0, 65535, 20736, 0, 65535, 21502, 0, 65535, 22269, 0, 65535, 23042, 0, 65535, 23809, 0, 65535, 24576, 0, 65535, 25343, 0, 65535, 26110, 0, 65535, 26883, 0, 65535, 27650, 0, 65535, 28416, 0, 65535, 29183, 0, 65535, 29950, 0, 65535, 30723, 0, 65535, 31490, 0, 65535, 32257, 0, 65535, 33024, 0, 65535, 33790, 0, 65535, 34557, 0, 65535, 35330, 0, 65535, 36097, 0, 65535, 36864, 0, 65535, 37631, 0, 65535, 38398, 0, 65535, 39171, 0, 65535, 39938, 0, 65535, 40704, 0, 65535, 41471, 0, 65535, 42238, 0, 65535, 43005, 0, 65535, 43778, 0, 65535, 44545, 0, 65535, 45312, 0, 65535, 46078, 0, 65535, 46845, 0, 65535, 47618, 0, 65535, 48385, 0, 65535, 49152, 0, 65535, 49919, 0, 65535, 50686, 0, 65535, 51459, 0, 65535, 52226, 0, 65535, 52992, 0, 65535, 53759, 0, 65535, 54526, 0, 65535, 55299, 0, 65535, 56066, 0, 65535, 56833, 0, 65535, 57600, 0, 65535, 58366, 0, 65535, 59133, 0, 65535, 59906, 0, 65535, 60673, 0, 65535, 61440, 0, 65535, 62207, 0, 65535, 62974, 0, 65535, 63747, 0, 65535, 64514, 0, 65535, 65280, 0, 65025, 65535, 0, 64258, 65535, 0, 63491, 65535, 0, 62718, 65535, 0, 61951, 65535, 0, 61184, 65535, 0, 60418, 65535, 0, 59651, 65535, 0, 58878, 65535, 0, 58111, 65535, 0, 57344, 65535, 0, 56577, 65535, 0, 55810, 65535, 0, 55037, 65535, 0, 54270, 65535, 0, 53504, 65535, 0, 52737, 65535, 0, 51970, 65535, 0, 51197, 65535, 0, 50430, 65535, 0, 49663, 65535, 0, 48896, 65535, 0, 48130, 65535, 0, 47363, 65535, 0, 46590, 65535, 0, 45823, 65535, 0, 45056, 65535, 0, 44289, 65535, 0, 43522, 65535, 0, 42749, 65535, 0, 41982, 65535, 0, 41216, 65535, 0, 40449, 65535, 0, 39682, 65535, 0, 38915, 65535, 0, 38142, 65535, 0, 37375, 65535, 0, 36608, 65535, 0, 35842, 65535, 0, 35075, 65535, 0, 34302, 65535, 0, 33535, 65535, 0, 32768, 65535, 0, 32001, 65535, 0, 31234, 65535, 0, 30461, 65535, 0, 29694, 65535, 0, 28928, 65535, 0, 28161, 65535, 0, 27394, 65535, 0, 26621, 65535, 0, 25854, 65535, 0, 25087, 65535, 0, 24320, 65535, 0, 23554, 65535, 0, 22787, 65535, 0, 22014, 65535, 0, 21247, 65535, 0, 20480, 65535, 0, 19713, 65535, 0, 18946, 65535, 0, 18173, 65535, 0, 17406, 65535, 0, 16640, 65535, 0, 15873, 65535, 0, 15106, 65535, 0, 14339, 65535, 0, 13566, 65535, 0, 12799, 65535, 0, 12032, 65535, 0, 11266, 65535, 0, 10499, 65535, 0, 9726, 65535, 0, 8959, 65535, 0, 8192, 65535, 0, 7425, 65535, 0, 6658, 65535, 0, 5885, 65535, 0, 5118, 65535, 0, 4352, 65535, 0, 3585, 65535, 0, 2818, 65535, 0, 2045, 65535, 0, 1278, 65535, 0, 511, 65535, 0, 0, 65535, 256, 0, 65535, 1022, 0, 65535, 1789, 0, 65535, 2562, 0, 65535, 3329, 0, 65535, 4096, 0, 65535, 4863, 0, 65535, 5630, 0, 65535, 6403, 0, 65535, 7170, 0, 65535, 7936, 0, 65535, 8703, 0, 65535, 9470, 0, 65535, 10237, 0, 65535, 11010, 0, 65535, 11777, 0, 65535, 12544, 0, 65535, 13310, 0, 65535, 14077, 0, 65535, 14850, 0, 65535, 15617, 0, 65535, 16384, 0, 65535, 17151, 0, 65535, 17918, 0, 65535, 18691, 0, 65535, 19458, 0, 65535, 20224, 0, 65535, 20991, 0, 65535, 21758, 0, 65535, 22531, 0, 65535, 23298, 0, 65535, 24065, 0, 65535, 24832, 0, 65535, 25598, 0, 65535, 26365, 0, 65535, 27138, 0, 65535, 27905, 0, 65535, 28672, 0, 65535, 29439, 0, 65535, 30206, 0, 65535, 30979, 0, 65535, 31746, 0, 65535, 32512, 0, 65535, 33279, 0, 65535, 34046, 0, 65535, 34813, 0, 65535, 35586, 0, 65535, 36353, 0, 65535, 37120, 0, 65535, 37886, 0, 65535, 38653, 0, 65535, 39426, 0, 65535, 40193, 0, 65535, 40960, 0, 65535, 41727, 0, 65535, 42494, 0, 65535, 43267, 0, 65535, 44034, 0, 65535, 44800, 0, 65535, 45567, 0, 65535, 46334, 0, 65535, 47107, 0, 65535, 47874, 0, 65535, 48641, 0, 65535, 49408, 0, 65535, 50174, 0, 65535, 50941, 0, 65535, 51714, 0, 65535, 52481, 0, 65535, 53248, 0, 65535, 54015, 0, 65535, 54782, 0, 65535, 55555, 0, 65535, 56322, 0, 65535, 57088, 0, 65535, 57855, 0, 65535, 58622, 0, 65535, 59389, 0, 65535, 60162, 0, 65535, 60929, 0, 65535, 61696, 0, 65535, 62462, 0, 65535, 63229, 0, 65535, 64002, 0, 65535, 64769, 0, 65535, 65535, 0, 64769, 65535, 0, 64002, 65535, 0, 63229, 65535, 0, 62462, 65535, 0, 61696, 65535, 0, 60929, 65535, 0, 60162, 65535, 0, 59389, 65535, 0, 58622, 65535, 0, 57855, 65535, 0, 57088, 65535, 0, 56322, 65535, 0, 55555, 65535, 0, 54782, 65535, 0, 54015, 65535, 0, 53248, 65535, 0, 52481, 65535, 0, 51714, 65535, 0, 50941, 65535, 0, 50174, 65535, 0, 49408, 65535, 0, 48641, 65535, 0, 47874, 65535, 0, 47107, 65535, 0, 46334, 65535, 0, 45567, 65535, 0, 44800, 65535, 0, 44034, 65535, 0, 43267, 65535, 0, 42494, 65535, 0, 41727, 65535, 0, 40960, 65535, 0, 40193, 65535, 0, 39426, 65535, 0, 38653, 65535, 0, 37886, 65535, 0, 37120, 65535, 0, 36353, 65535, 0, 35586, 65535, 0, 34813, 65535, 0, 34046, 65535, 0, 33279, 65535, 0, 32512, 65535, 0, 31746, 65535, 0, 30979, 65535, 0, 30206, 65535, 0, 29439, 65535, 0, 28672, 65535, 0, 27905, 65535, 0, 27138, 65535, 0, 26365, 65535, 0, 25598, 65535, 0, 24832, 65535, 0, 24065, 65535, 0, 23298, 65535, 0, 22531, 65535, 0, 21758, 65535, 0, 20991, 65535, 0, 20224, 65535, 0, 19458, 65535, 0, 18691, 65535, 0, 17918, 65535, 0, 17151, 65535, 0, 16384, 65535, 0, 15617, 65535, 0, 14850, 65535, 0, 14077, 65535, 0, 13310, 65535, 0, 12544, 65535, 0, 11777, 65535, 0, 11010, 65535, 0, 10237, 65535, 0, 9470, 65535, 0, 8703, 65535, 0, 7936, 65535, 0, 7170, 65535, 0, 6403, 65535, 0, 5630, 65535, 0, 4863, 65535, 0, 4096, 65535, 0, 3329, 65535, 0, 2562, 65535, 0, 1789, 65535, 0, 1022, 65535, 0, 256, 65535, 511, 0, 65535, 1278, 0, 65535, 2045, 0, 65535, 2818, 0, 65535, 3585, 0, 65535, 4352, 0, 65535, 5118, 0, 65535, 5885, 0, 65535, 6658, 0, 65535, 7425, 0, 65535, 8192, 0, 65535, 8959, 0, 65535, 9726, 0, 65535, 10499, 0, 65535, 11266, 0, 65535, 12032, 0, 65535, 12799, 0, 65535, 13566, 0, 65535, 14339, 0, 65535, 15106, 0, 65535, 15873, 0, 65535, 16640, 0, 65535, 17406, 0, 65535, 18173, 0, 65535, 18946, 0, 65535, 19713, 0, 65535, 20480, 0, 65535, 21247, 0, 65535, 22014, 0, 65535, 22787, 0, 65535, 23554, 0, 65535, 24320, 0, 65535, 25087, 0, 65535, 25854, 0, 65535, 26621, 0, 65535, 27394, 0, 65535, 28161, 0, 65535, 28928, 0, 65535, 29694, 0, 65535, 30461, 0, 65535, 31234, 0, 65535, 32001, 0, 65535, 32768, 0, 65535, 33535, 0, 65535, 34302, 0, 65535, 35075, 0, 65535, 35842, 0, 65535, 36608, 0, 65535, 37375, 0, 65535, 38142, 0, 65535, 38915, 0, 65535, 39682, 0, 65535, 40449, 0, 65535, 41216, 0, 65535, 41982, 0, 65535, 42749, 0, 65535, 43522, 0, 65535, 44289, 0, 65535, 45056, 0, 65535, 45823, 0, 65535, 46590, 0, 65535, 47363, 0, 65535, 48130, 0, 65535, 48896, 0, 65535, 49663, 0, 65535, 50430, 0, 65535, 51197, 0, 65535, 51970, 0, 65535, 52737, 0, 65535, 53504, 0, 65535, 54270, 0, 65535, 55037, 0, 65535, 55810, 0, 65535, 56577, 0, 65535, 57344, 0, 65535, 58111, 0, 65535, 58878, 0, 65535, 59651, 0, 65535, 60418, 0, 65535, 61184, 0, 65535, 61951, 0, 65535, 62718, 0, 65535, 63491, 0, 65535, 64258, 0, 65535, 65025, 0, 65535, 65535, 0, 65280, 65535, 0, 64514, 65535, 0, 63747, 65535, 0, 62974, 65535, 0, 62207, 65535, 0, 61440, 65535, 0, 60673, 65535, 0, 59906, 65535, 0, 59133, 65535, 0, 58366, 65535, 0, 57600, 65535, 0, 56833, 65535, 0, 56066, 65535, 0, 55299, 65535, 0, 54526, 65535, 0, 53759, 65535, 0, 52992, 65535, 0, 52226, 65535, 0, 51459, 65535, 0, 50686, 65535, 0, 49919, 65535, 0, 49152, 65535, 0, 48385, 65535, 0, 47618, 65535, 0, 46845, 65535, 0, 46078, 65535, 0, 45312, 65535, 0, 44545, 65535, 0, 43778, 65535, 0, 43005, 65535, 0, 42238, 65535, 0, 41471, 65535, 0, 40704, 65535, 0, 39938, 65535, 0, 39171, 65535, 0, 38398, 65535, 0, 37631, 65535, 0, 36864, 65535, 0, 36097, 65535, 0, 35330, 65535, 0, 34557, 65535, 0, 33790, 65535, 0, 33024, 65535, 0, 32257, 65535, 0, 31490, 65535, 0, 30723, 65535, 0, 29950, 65535, 0, 29183, 65535, 0, 28416, 65535, 0, 27650, 65535, 0, 26883, 65535, 0, 26110, 65535, 0, 25343, 65535, 0, 24576, 65535, 0, 23809, 65535, 0, 23042, 65535, 0, 22269, 65535, 0, 21502, 65535, 0, 20736, 65535, 0, 19969, 65535, 0, 19202, 65535, 0, 18429, 65535, 0, 17662, 65535, 0, 16895, 65535, 0, 16128, 65535, 0, 15362, 65535, 0, 14595, 65535, 0, 13822, 65535, 0, 13055, 65535, 0, 12288, 65535, 0, 11521, 65535, 0, 10754, 65535, 0, 9981, 65535, 0, 9214, 65535, 0, 8448, 65535, 0, 7681, 65535, 0, 6914, 65535, 0, 6147, 65535, 0, 5374, 65535, 0, 4607, 65535, 0, 3840, 65535, 0, 3074, 65535, 0, 2307, 65535, 0, 1534, 65535, 0, 767};

static unsigned short hot_colormap[] = {341, 0, 0, 682, 0, 0, 1022, 0, 0, 1363, 0, 0, 1704, 0, 0, 2045, 0, 0, 2392, 0, 0, 2733, 0, 0, 3074, 0, 0, 3414, 0, 0, 3755, 0, 0, 4096, 0, 0, 4437, 0, 0, 4778, 0, 0, 5118, 0, 0, 5459, 0, 0, 5800, 0, 0, 6147, 0, 0, 6488, 0, 0, 6829, 0, 0, 7170, 0, 0, 7510, 0, 0, 7851, 0, 0, 8192, 0, 0, 8533, 0, 0, 8874, 0, 0, 9214, 0, 0, 9555, 0, 0, 9896, 0, 0, 10237, 0, 0, 10584, 0, 0, 10925, 0, 0, 11266, 0, 0, 11606, 0, 0, 11947, 0, 0, 12288, 0, 0, 12629, 0, 0, 12970, 0, 0, 13310, 0, 0, 13651, 0, 0, 13992, 0, 0, 14339, 0, 0, 14680, 0, 0, 15021, 0, 0, 15362, 0, 0, 15702, 0, 0, 16043, 0, 0, 16384, 0, 0, 16725, 0, 0, 17066, 0, 0, 17406, 0, 0, 17747, 0, 0, 18088, 0, 0, 18429, 0, 0, 18776, 0, 0, 19117, 0, 0, 19458, 0, 0, 19798, 0, 0, 20139, 0, 0, 20480, 0, 0, 20821, 0, 0, 21162, 0, 0, 21502, 0, 0, 21843, 0, 0, 22184, 0, 0, 22531, 0, 0, 22872, 0, 0, 23213, 0, 0, 23554, 0, 0, 23894, 0, 0, 24235, 0, 0, 24576, 0, 0, 24917, 0, 0, 25258, 0, 0, 25598, 0, 0, 25939, 0, 0, 26280, 0, 0, 26621, 0, 0, 26968, 0, 0, 27309, 0, 0, 27650, 0, 0, 27990, 0, 0, 28331, 0, 0, 28672, 0, 0, 29013, 0, 0, 29354, 0, 0, 29694, 0, 0, 30035, 0, 0, 30376, 0, 0, 30723, 0, 0, 31064, 0, 0, 31405, 0, 0, 31746, 0, 0, 32086, 0, 0, 32427, 0, 0, 32768, 0, 0, 33109, 0, 0, 33450, 0, 0, 33790, 0, 0, 34131, 0, 0, 34472, 0, 0, 34813, 0, 0, 35160, 0, 0, 35501, 0, 0, 35842, 0, 0, 36182, 0, 0, 36523, 0, 0, 36864, 0, 0, 37205, 0, 0, 37546, 0, 0, 37886, 0, 0, 38227, 0, 0, 38568, 0, 0, 38915, 0, 0, 39256, 0, 0, 39597, 0, 0, 39938, 0, 0, 40278, 0, 0, 40619, 0, 0, 40960, 0, 0, 41301, 0, 0, 41642, 0, 0, 41982, 0, 0, 42323, 0, 0, 42664, 0, 0, 43005, 0, 0, 43352, 0, 0, 43693, 0, 0, 44034, 0, 0, 44374, 0, 0, 44715, 0, 0, 45056, 0, 0, 45397, 0, 0, 45738, 0, 0, 46078, 0, 0, 46419, 0, 0, 46760, 0, 0, 47107, 0, 0, 47448, 0, 0, 47789, 0, 0, 48130, 0, 0, 48470, 0, 0, 48811, 0, 0, 49152, 0, 0, 49493, 0, 0, 49834, 0, 0, 50174, 0, 0, 50515, 0, 0, 50856, 0, 0, 51197, 0, 0, 51544, 0, 0, 51885, 0, 0, 52226, 0, 0, 52566, 0, 0, 52907, 0, 0, 53248, 0, 0, 53589, 0, 0, 53930, 0, 0, 54270, 0, 0, 54611, 0, 0, 54952, 0, 0, 55299, 0, 0, 55640, 0, 0, 55981, 0, 0, 56322, 0, 0, 56662, 0, 0, 57003, 0, 0, 57344, 0, 0, 57685, 0, 0, 58026, 0, 0, 58366, 0, 0, 58707, 0, 0, 59048, 0, 0, 59389, 0, 0, 59736, 0, 0, 60077, 0, 0, 60418, 0, 0, 60758, 0, 0, 61099, 0, 0, 61440, 0, 0, 61781, 0, 0, 62122, 0, 0, 62462, 0, 0, 62803, 0, 0, 63144, 0, 0, 63491, 0, 0, 63832, 0, 0, 64173, 0, 0, 64514, 0, 0, 64854, 0, 0, 65195, 0, 0, 65535, 0, 0, 65535, 341, 0, 65535, 682, 0, 65535, 1022, 0, 65535, 1363, 0, 65535, 1704, 0, 65535, 2045, 0, 65535, 2392, 0, 65535, 2733, 0, 65535, 3074, 0, 65535, 3414, 0, 65535, 3755, 0, 65535, 4096, 0, 65535, 4437, 0, 65535, 4778, 0, 65535, 5118, 0, 65535, 5459, 0, 65535, 5800, 0, 65535, 6147, 0, 65535, 6488, 0, 65535, 6829, 0, 65535, 7170, 0, 65535, 7510, 0, 65535, 7851, 0, 65535, 8192, 0, 65535, 8533, 0, 65535, 8874, 0, 65535, 9214, 0, 65535, 9555, 0, 65535, 9896, 0, 65535, 10237, 0, 65535, 10584, 0, 65535, 10925, 0, 65535, 11266, 0, 65535, 11606, 0, 65535, 11947, 0, 65535, 12288, 0, 65535, 12629, 0, 65535, 12970, 0, 65535, 13310, 0, 65535, 13651, 0, 65535, 13992, 0, 65535, 14339, 0, 65535, 14680, 0, 65535, 15021, 0, 65535, 15362, 0, 65535, 15702, 0, 65535, 16043, 0, 65535, 16384, 0, 65535, 16725, 0, 65535, 17066, 0, 65535, 17406, 0, 65535, 17747, 0, 65535, 18088, 0, 65535, 18429, 0, 65535, 18776, 0, 65535, 19117, 0, 65535, 19458, 0, 65535, 19798, 0, 65535, 20139, 0, 65535, 20480, 0, 65535, 20821, 0, 65535, 21162, 0, 65535, 21502, 0, 65535, 21843, 0, 65535, 22184, 0, 65535, 22531, 0, 65535, 22872, 0, 65535, 23213, 0, 65535, 23554, 0, 65535, 23894, 0, 65535, 24235, 0, 65535, 24576, 0, 65535, 24917, 0, 65535, 25258, 0, 65535, 25598, 0, 65535, 25939, 0, 65535, 26280, 0, 65535, 26621, 0, 65535, 26968, 0, 65535, 27309, 0, 65535, 27650, 0, 65535, 27990, 0, 65535, 28331, 0, 65535, 28672, 0, 65535, 29013, 0, 65535, 29354, 0, 65535, 29694, 0, 65535, 30035, 0, 65535, 30376, 0, 65535, 30723, 0, 65535, 31064, 0, 65535, 31405, 0, 65535, 31746, 0, 65535, 32086, 0, 65535, 32427, 0, 65535, 32768, 0, 65535, 33109, 0, 65535, 33450, 0, 65535, 33790, 0, 65535, 34131, 0, 65535, 34472, 0, 65535, 34813, 0, 65535, 35160, 0, 65535, 35501, 0, 65535, 35842, 0, 65535, 36182, 0, 65535, 36523, 0, 65535, 36864, 0, 65535, 37205, 0, 65535, 37546, 0, 65535, 37886, 0, 65535, 38227, 0, 65535, 38568, 0, 65535, 38915, 0, 65535, 39256, 0, 65535, 39597, 0, 65535, 39938, 0, 65535, 40278, 0, 65535, 40619, 0, 65535, 40960, 0, 65535, 41301, 0, 65535, 41642, 0, 65535, 41982, 0, 65535, 42323, 0, 65535, 42664, 0, 65535, 43005, 0, 65535, 43352, 0, 65535, 43693, 0, 65535, 44034, 0, 65535, 44374, 0, 65535, 44715, 0, 65535, 45056, 0, 65535, 45397, 0, 65535, 45738, 0, 65535, 46078, 0, 65535, 46419, 0, 65535, 46760, 0, 65535, 47107, 0, 65535, 47448, 0, 65535, 47789, 0, 65535, 48130, 0, 65535, 48470, 0, 65535, 48811, 0, 65535, 49152, 0, 65535, 49493, 0, 65535, 49834, 0, 65535, 50174, 0, 65535, 50515, 0, 65535, 50856, 0, 65535, 51197, 0, 65535, 51544, 0, 65535, 51885, 0, 65535, 52226, 0, 65535, 52566, 0, 65535, 52907, 0, 65535, 53248, 0, 65535, 53589, 0, 65535, 53930, 0, 65535, 54270, 0, 65535, 54611, 0, 65535, 54952, 0, 65535, 55299, 0, 65535, 55640, 0, 65535, 55981, 0, 65535, 56322, 0, 65535, 56662, 0, 65535, 57003, 0, 65535, 57344, 0, 65535, 57685, 0, 65535, 58026, 0, 65535, 58366, 0, 65535, 58707, 0, 65535, 59048, 0, 65535, 59389, 0, 65535, 59736, 0, 65535, 60077, 0, 65535, 60418, 0, 65535, 60758, 0, 65535, 61099, 0, 65535, 61440, 0, 65535, 61781, 0, 65535, 62122, 0, 65535, 62462, 0, 65535, 62803, 0, 65535, 63144, 0, 65535, 63491, 0, 65535, 63832, 0, 65535, 64173, 0, 65535, 64514, 0, 65535, 64854, 0, 65535, 65195, 0, 65535, 65535, 0, 65535, 65535, 511, 65535, 65535, 1022, 65535, 65535, 1534, 65535, 65535, 2045, 65535, 65535, 2562, 65535, 65535, 3074, 65535, 65535, 3585, 65535, 65535, 4096, 65535, 65535, 4607, 65535, 65535, 5118, 65535, 65535, 5630, 65535, 65535, 6147, 65535, 65535, 6658, 65535, 65535, 7170, 65535, 65535, 7681, 65535, 65535, 8192, 65535, 65535, 8703, 65535, 65535, 9214, 65535, 65535, 9726, 65535, 65535, 10237, 65535, 65535, 10754, 65535, 65535, 11266, 65535, 65535, 11777, 65535, 65535, 12288, 65535, 65535, 12799, 65535, 65535, 13310, 65535, 65535, 13822, 65535, 65535, 14339, 65535, 65535, 14850, 65535, 65535, 15362, 65535, 65535, 15873, 65535, 65535, 16384, 65535, 65535, 16895, 65535, 65535, 17406, 65535, 65535, 17918, 65535, 65535, 18429, 65535, 65535, 18946, 65535, 65535, 19458, 65535, 65535, 19969, 65535, 65535, 20480, 65535, 65535, 20991, 65535, 65535, 21502, 65535, 65535, 22014, 65535, 65535, 22531, 65535, 65535, 23042, 65535, 65535, 23554, 65535, 65535, 24065, 65535, 65535, 24576, 65535, 65535, 25087, 65535, 65535, 25598, 65535, 65535, 26110, 65535, 65535, 26621, 65535, 65535, 27138, 65535, 65535, 27650, 65535, 65535, 28161, 65535, 65535, 28672, 65535, 65535, 29183, 65535, 65535, 29694, 65535, 65535, 30206, 65535, 65535, 30723, 65535, 65535, 31234, 65535, 65535, 31746, 65535, 65535, 32257, 65535, 65535, 32768, 65535, 65535, 33279, 65535, 65535, 33790, 65535, 65535, 34302, 65535, 65535, 34813, 65535, 65535, 35330, 65535, 65535, 35842, 65535, 65535, 36353, 65535, 65535, 36864, 65535, 65535, 37375, 65535, 65535, 37886, 65535, 65535, 38398, 65535, 65535, 38915, 65535, 65535, 39426, 65535, 65535, 39938, 65535, 65535, 40449, 65535, 65535, 40960, 65535, 65535, 41471, 65535, 65535, 41982, 65535, 65535, 42494, 65535, 65535, 43005, 65535, 65535, 43522, 65535, 65535, 44034, 65535, 65535, 44545, 65535, 65535, 45056, 65535, 65535, 45567, 65535, 65535, 46078, 65535, 65535, 46590, 65535, 65535, 47107, 65535, 65535, 47618, 65535, 65535, 48130, 65535, 65535, 48641, 65535, 65535, 49152, 65535, 65535, 49663, 65535, 65535, 50174, 65535, 65535, 50686, 65535, 65535, 51197, 65535, 65535, 51714, 65535, 65535, 52226, 65535, 65535, 52737, 65535, 65535, 53248, 65535, 65535, 53759, 65535, 65535, 54270, 65535, 65535, 54782, 65535, 65535, 55299, 65535, 65535, 55810, 65535, 65535, 56322, 65535, 65535, 56833, 65535, 65535, 57344, 65535, 65535, 57855, 65535, 65535, 58366, 65535, 65535, 58878, 65535, 65535, 59389, 65535, 65535, 59906, 65535, 65535, 60418, 65535, 65535, 60929, 65535, 65535, 61440, 65535, 65535, 61951, 65535, 65535, 62462, 65535, 65535, 62974, 65535, 65535, 63491, 65535, 65535, 64002, 65535, 65535, 64514, 65535, 65535, 65025, 65535, 65535, 65535};

static unsigned short cool_colormap[] = {0, 65535, 65535, 131, 65405, 65535, 256, 65280, 65535, 387, 65149, 65535, 511, 65025, 65535, 642, 64894, 65535, 767, 64769, 65535, 898, 64638, 65535, 1029, 64507, 65535, 1153, 64383, 65535, 1285, 64251, 65535, 1409, 64127, 65535, 1540, 63996, 65535, 1665, 63871, 65535, 1796, 63740, 65535, 1927, 63609, 65535, 2051, 63485, 65535, 2182, 63354, 65535, 2307, 63229, 65535, 2438, 63098, 65535, 2562, 62974, 65535, 2694, 62842, 65535, 2825, 62711, 65535, 2949, 62587, 65535, 3080, 62456, 65535, 3205, 62331, 65535, 3336, 62200, 65535, 3460, 62076, 65535, 3591, 61945, 65535, 3722, 61814, 65535, 3847, 61689, 65535, 3978, 61558, 65535, 4103, 61433, 65535, 4234, 61302, 65535, 4358, 61178, 65535, 4489, 61047, 65535, 4620, 60916, 65535, 4745, 60791, 65535, 4876, 60660, 65535, 5000, 60536, 65535, 5131, 60405, 65535, 5256, 60280, 65535, 5387, 60149, 65535, 5512, 60024, 65535, 5643, 59893, 65535, 5774, 59762, 65535, 5898, 59638, 65535, 6029, 59507, 65535, 6154, 59382, 65535, 6285, 59251, 65535, 6409, 59127, 65535, 6540, 58996, 65535, 6672, 58864, 65535, 6796, 58740, 65535, 6927, 58609, 65535, 7052, 58484, 65535, 7183, 58353, 65535, 7307, 58229, 65535, 7438, 58098, 65535, 7569, 57967, 65535, 7694, 57842, 65535, 7825, 57711, 65535, 7950, 57586, 65535, 8081, 57455, 65535, 8205, 57331, 65535, 8336, 57200, 65535, 8467, 57069, 65535, 8592, 56944, 65535, 8723, 56813, 65535, 8847, 56689, 65535, 8978, 56558, 65535, 9103, 56433, 65535, 9234, 56302, 65535, 9365, 56171, 65535, 9490, 56046, 65535, 9621, 55915, 65535, 9745, 55791, 65535, 9876, 55660, 65535, 10001, 55535, 65535, 10132, 55404, 65535, 10263, 55273, 65535, 10387, 55149, 65535, 10519, 55017, 65535, 10643, 54893, 65535, 10774, 54762, 65535, 10899, 54637, 65535, 11030, 54506, 65535, 11161, 54375, 65535, 11285, 54251, 65535, 11416, 54120, 65535, 11541, 53995, 65535, 11672, 53864, 65535, 11796, 53740, 65535, 11928, 53608, 65535, 12059, 53477, 65535, 12183, 53353, 65535, 12314, 53222, 65535, 12439, 53097, 65535, 12570, 52966, 65535, 12694, 52842, 65535, 12825, 52711, 65535, 12956, 52580, 65535, 13081, 52455, 65535, 13212, 52324, 65535, 13337, 52199, 65535, 13468, 52068, 65535, 13592, 51944, 65535, 13723, 51813, 65535, 13854, 51682, 65535, 13979, 51557, 65535, 14110, 51426, 65535, 14234, 51302, 65535, 14365, 51171, 65535, 14490, 51046, 65535, 14621, 50915, 65535, 14746, 50790, 65535, 14877, 50659, 65535, 15008, 50528, 65535, 15132, 50404, 65535, 15263, 50273, 65535, 15388, 50148, 65535, 15519, 50017, 65535, 15643, 49893, 65535, 15775, 49761, 65535, 15906, 49630, 65535, 16030, 49506, 65535, 16161, 49375, 65535, 16286, 49250, 65535, 16417, 49119, 65535, 16541, 48995, 65535, 16672, 48864, 65535, 16803, 48733, 65535, 16928, 48608, 65535, 17059, 48477, 65535, 17184, 48352, 65535, 17315, 48221, 65535, 17439, 48097, 65535, 17570, 47966, 65535, 17701, 47835, 65535, 17826, 47710, 65535, 17957, 47579, 65535, 18081, 47455, 65535, 18212, 47324, 65535, 18337, 47199, 65535, 18468, 47068, 65535, 18599, 46937, 65535, 18724, 46812, 65535, 18855, 46681, 65535, 18979, 46557, 65535, 19110, 46426, 65535, 19235, 46301, 65535, 19366, 46170, 65535, 19497, 46039, 65535, 19621, 45915, 65535, 19753, 45783, 65535, 19877, 45659, 65535, 20008, 45528, 65535, 20133, 45403, 65535, 20264, 45272, 65535, 20395, 45141, 65535, 20519, 45017, 65535, 20650, 44886, 65535, 20775, 44761, 65535, 20906, 44630, 65535, 21031, 44505, 65535, 21162, 44374, 65535, 21293, 44243, 65535, 21417, 44119, 65535, 21548, 43988, 65535, 21673, 43863, 65535, 21804, 43732, 65535, 21928, 43608, 65535, 22059, 43477, 65535, 22190, 43346, 65535, 22315, 43221, 65535, 22446, 43090, 65535, 22571, 42965, 65535, 22702, 42834, 65535, 22826, 42710, 65535, 22957, 42579, 65535, 23088, 42448, 65535, 23213, 42323, 65535, 23344, 42192, 65535, 23468, 42068, 65535, 23600, 41936, 65535, 23724, 41812, 65535, 23855, 41681, 65535, 23980, 41556, 65535, 24111, 41425, 65535, 24242, 41294, 65535, 24366, 41170, 65535, 24497, 41039, 65535, 24622, 40914, 65535, 24753, 40783, 65535, 24877, 40659, 65535, 25009, 40527, 65535, 25140, 40396, 65535, 25264, 40272, 65535, 25395, 40141, 65535, 25520, 40016, 65535, 25651, 39885, 65535, 25775, 39761, 65535, 25906, 39630, 65535, 26037, 39499, 65535, 26162, 39374, 65535, 26293, 39243, 65535, 26418, 39118, 65535, 26549, 38987, 65535, 26673, 38863, 65535, 26804, 38732, 65535, 26935, 38601, 65535, 27060, 38476, 65535, 27191, 38345, 65535, 27315, 38221, 65535, 27446, 38090, 65535, 27571, 37965, 65535, 27702, 37834, 65535, 27833, 37703, 65535, 27958, 37578, 65535, 28089, 37447, 65535, 28213, 37323, 65535, 28344, 37192, 65535, 28469, 37067, 65535, 28600, 36936, 65535, 28731, 36805, 65535, 28856, 36680, 65535, 28987, 36549, 65535, 29111, 36425, 65535, 29242, 36294, 65535, 29367, 36169, 65535, 29498, 36038, 65535, 29629, 35907, 65535, 29753, 35783, 65535, 29884, 35652, 65535, 30009, 35527, 65535, 30140, 35396, 65535, 30265, 35271, 65535, 30396, 35140, 65535, 30527, 35009, 65535, 30651, 34885, 65535, 30782, 34754, 65535, 30907, 34629, 65535, 31038, 34498, 65535, 31162, 34374, 65535, 31293, 34243, 65535, 31425, 34111, 65535, 31549, 33987, 65535, 31680, 33856, 65535, 31805, 33731, 65535, 31936, 33600, 65535, 32060, 33476, 65535, 32191, 33345, 65535, 32322, 33214, 65535, 32447, 33089, 65535, 32578, 32958, 65535, 32702, 32834, 65535, 32834, 32702, 65535, 32958, 32578, 65535, 33089, 32447, 65535, 33214, 32322, 65535, 33345, 32191, 65535, 33476, 32060, 65535, 33600, 31936, 65535, 33731, 31805, 65535, 33856, 31680, 65535, 33987, 31549, 65535, 34111, 31425, 65535, 34243, 31293, 65535, 34374, 31162, 65535, 34498, 31038, 65535, 34629, 30907, 65535, 34754, 30782, 65535, 34885, 30651, 65535, 35009, 30527, 65535, 35140, 30396, 65535, 35271, 30265, 65535, 35396, 30140, 65535, 35527, 30009, 65535, 35652, 29884, 65535, 35783, 29753, 65535, 35907, 29629, 65535, 36038, 29498, 65535, 36169, 29367, 65535, 36294, 29242, 65535, 36425, 29111, 65535, 36549, 28987, 65535, 36680, 28856, 65535, 36805, 28731, 65535, 36936, 28600, 65535, 37067, 28469, 65535, 37192, 28344, 65535, 37323, 28213, 65535, 37447, 28089, 65535, 37578, 27958, 65535, 37703, 27833, 65535, 37834, 27702, 65535, 37965, 27571, 65535, 38090, 27446, 65535, 38221, 27315, 65535, 38345, 27191, 65535, 38476, 27060, 65535, 38601, 26935, 65535, 38732, 26804, 65535, 38863, 26673, 65535, 38987, 26549, 65535, 39118, 26418, 65535, 39243, 26293, 65535, 39374, 26162, 65535, 39499, 26037, 65535, 39630, 25906, 65535, 39761, 25775, 65535, 39885, 25651, 65535, 40016, 25520, 65535, 40141, 25395, 65535, 40272, 25264, 65535, 40396, 25140, 65535, 40527, 25009, 65535, 40659, 24877, 65535, 40783, 24753, 65535, 40914, 24622, 65535, 41039, 24497, 65535, 41170, 24366, 65535, 41294, 24242, 65535, 41425, 24111, 65535, 41556, 23980, 65535, 41681, 23855, 65535, 41812, 23724, 65535, 41936, 23600, 65535, 42068, 23468, 65535, 42192, 23344, 65535, 42323, 23213, 65535, 42448, 23088, 65535, 42579, 22957, 65535, 42710, 22826, 65535, 42834, 22702, 65535, 42965, 22571, 65535, 43090, 22446, 65535, 43221, 22315, 65535, 43346, 22190, 65535, 43477, 22059, 65535, 43608, 21928, 65535, 43732, 21804, 65535, 43863, 21673, 65535, 43988, 21548, 65535, 44119, 21417, 65535, 44243, 21293, 65535, 44374, 21162, 65535, 44505, 21031, 65535, 44630, 20906, 65535, 44761, 20775, 65535, 44886, 20650, 65535, 45017, 20519, 65535, 45141, 20395, 65535, 45272, 20264, 65535, 45403, 20133, 65535, 45528, 20008, 65535, 45659, 19877, 65535, 45783, 19753, 65535, 45915, 19621, 65535, 46039, 19497, 65535, 46170, 19366, 65535, 46301, 19235, 65535, 46426, 19110, 65535, 46557, 18979, 65535, 46681, 18855, 65535, 46812, 18724, 65535, 46937, 18599, 65535, 47068, 18468, 65535, 47199, 18337, 65535, 47324, 18212, 65535, 47455, 18081, 65535, 47579, 17957, 65535, 47710, 17826, 65535, 47835, 17701, 65535, 47966, 17570, 65535, 48097, 17439, 65535, 48221, 17315, 65535, 48352, 17184, 65535, 48477, 17059, 65535, 48608, 16928, 65535, 48733, 16803, 65535, 48864, 16672, 65535, 48995, 16541, 65535, 49119, 16417, 65535, 49250, 16286, 65535, 49375, 16161, 65535, 49506, 16030, 65535, 49630, 15906, 65535, 49761, 15775, 65535, 49893, 15643, 65535, 50017, 15519, 65535, 50148, 15388, 65535, 50273, 15263, 65535, 50404, 15132, 65535, 50528, 15008, 65535, 50659, 14877, 65535, 50790, 14746, 65535, 50915, 14621, 65535, 51046, 14490, 65535, 51171, 14365, 65535, 51302, 14234, 65535, 51426, 14110, 65535, 51557, 13979, 65535, 51682, 13854, 65535, 51813, 13723, 65535, 51944, 13592, 65535, 52068, 13468, 65535, 52199, 13337, 65535, 52324, 13212, 65535, 52455, 13081, 65535, 52580, 12956, 65535, 52711, 12825, 65535, 52842, 12694, 65535, 52966, 12570, 65535, 53097, 12439, 65535, 53222, 12314, 65535, 53353, 12183, 65535, 53477, 12059, 65535, 53608, 11928, 65535, 53740, 11796, 65535, 53864, 11672, 65535, 53995, 11541, 65535, 54120, 11416, 65535, 54251, 11285, 65535, 54375, 11161, 65535, 54506, 11030, 65535, 54637, 10899, 65535, 54762, 10774, 65535, 54893, 10643, 65535, 55017, 10519, 65535, 55149, 10387, 65535, 55273, 10263, 65535, 55404, 10132, 65535, 55535, 10001, 65535, 55660, 9876, 65535, 55791, 9745, 65535, 55915, 9621, 65535, 56046, 9490, 65535, 56171, 9365, 65535, 56302, 9234, 65535, 56433, 9103, 65535, 56558, 8978, 65535, 56689, 8847, 65535, 56813, 8723, 65535, 56944, 8592, 65535, 57069, 8467, 65535, 57200, 8336, 65535, 57331, 8205, 65535, 57455, 8081, 65535, 57586, 7950, 65535, 57711, 7825, 65535, 57842, 7694, 65535, 57967, 7569, 65535, 58098, 7438, 65535, 58229, 7307, 65535, 58353, 7183, 65535, 58484, 7052, 65535, 58609, 6927, 65535, 58740, 6796, 65535, 58864, 6672, 65535, 58996, 6540, 65535, 59127, 6409, 65535, 59251, 6285, 65535, 59382, 6154, 65535, 59507, 6029, 65535, 59638, 5898, 65535, 59762, 5774, 65535, 59893, 5643, 65535, 60024, 5512, 65535, 60149, 5387, 65535, 60280, 5256, 65535, 60405, 5131, 65535, 60536, 5000, 65535, 60660, 4876, 65535, 60791, 4745, 65535, 60916, 4620, 65535, 61047, 4489, 65535, 61178, 4358, 65535, 61302, 4234, 65535, 61433, 4103, 65535, 61558, 3978, 65535, 61689, 3847, 65535, 61814, 3722, 65535, 61945, 3591, 65535, 62076, 3460, 65535, 62200, 3336, 65535, 62331, 3205, 65535, 62456, 3080, 65535, 62587, 2949, 65535, 62711, 2825, 65535, 62842, 2694, 65535, 62974, 2562, 65535, 63098, 2438, 65535, 63229, 2307, 65535, 63354, 2182, 65535, 63485, 2051, 65535, 63609, 1927, 65535, 63740, 1796, 65535, 63871, 1665, 65535, 63996, 1540, 65535, 64127, 1409, 65535, 64251, 1285, 65535, 64383, 1153, 65535, 64507, 1029, 65535, 64638, 898, 65535, 64769, 767, 65535, 64894, 642, 65535, 65025, 511, 65535, 65149, 387, 65535, 65280, 256, 65535, 65405, 131, 65535, 65535, 0, 65535};

static unsigned short bone_colormap[] = {0, 0, 46, 111, 111, 197, 223, 223, 354, 334, 334, 505, 446, 446, 662, 564, 564, 819, 675, 675, 970, 786, 786, 1127, 898, 898, 1285, 1009, 1009, 1435, 1121, 1121, 1593, 1232, 1232, 1743, 1343, 1343, 1901, 1461, 1461, 2058, 1573, 1573, 2209, 1684, 1684, 2366, 1796, 1796, 2523, 1907, 1907, 2674, 2019, 2019, 2831, 2130, 2130, 2988, 2241, 2241, 3139, 2359, 2359, 3296, 2471, 2471, 3447, 2582, 2582, 3604, 2694, 2694, 3762, 2805, 2805, 3912, 2916, 2916, 4070, 3028, 3028, 4227, 3139, 3139, 4378, 3257, 3257, 4535, 3369, 3369, 4692, 3480, 3480, 4843, 3591, 3591, 5000, 3703, 3703, 5151, 3814, 3814, 5308, 3926, 3926, 5466, 4037, 4037, 5616, 4155, 4155, 5774, 4266, 4266, 5931, 4378, 4378, 6082, 4489, 4489, 6239, 4601, 4601, 6390, 4712, 4712, 6547, 4823, 4823, 6704, 4935, 4935, 6855, 5053, 5053, 7012, 5164, 5164, 7170, 5276, 5276, 7320, 5387, 5387, 7478, 5498, 5498, 7635, 5610, 5610, 7786, 5721, 5721, 7943, 5833, 5833, 8094, 5951, 5951, 8251, 6062, 6062, 8408, 6173, 6173, 8559, 6285, 6285, 8716, 6396, 6396, 8874, 6508, 6508, 9024, 6619, 6619, 9182, 6731, 6731, 9339, 6849, 6849, 9490, 6960, 6960, 9647, 7071, 7071, 9798, 7183, 7183, 9955, 7294, 7294, 10112, 7406, 7406, 10263, 7517, 7517, 10420, 7628, 7628, 10578, 7746, 7746, 10728, 7858, 7858, 10886, 7969, 7969, 11043, 8081, 8081, 11194, 8192, 8192, 11351, 8303, 8303, 11502, 8415, 8415, 11659, 8526, 8526, 11816, 8638, 8638, 11967, 8756, 8756, 12124, 8867, 8867, 12281, 8978, 8978, 12432, 9090, 9090, 12589, 9201, 9201, 12740, 9313, 9313, 12897, 9424, 9424, 13055, 9535, 9535, 13206, 9653, 9653, 13363, 9765, 9765, 13520, 9876, 9876, 13671, 9988, 9988, 13828, 10099, 10099, 13985, 10211, 10211, 14136, 10322, 10322, 14293, 10433, 10433, 14444, 10551, 10551, 14601, 10663, 10663, 14759, 10774, 10774, 14909, 10886, 10886, 15067, 10997, 10997, 15224, 11108, 11108, 15375, 11220, 11220, 15532, 11331, 11331, 15689, 11449, 11449, 15840, 11561, 11561, 15997, 11672, 11672, 16148, 11783, 11783, 16305, 11895, 11895, 16463, 12006, 12006, 16613, 12118, 12118, 16771, 12229, 12229, 16928, 12347, 12347, 17079, 12458, 12458, 17236, 12570, 12570, 17387, 12681, 12681, 17544, 12793, 12793, 17701, 12904, 12904, 17852, 13015, 13015, 18009, 13127, 13127, 18167, 13245, 13245, 18317, 13356, 13356, 18475, 13468, 13468, 18632, 13579, 13579, 18783, 13690, 13690, 18940, 13802, 13802, 19091, 13913, 13913, 19248, 14025, 14025, 19405, 14143, 14143, 19556, 14254, 14254, 19713, 14365, 14365, 19871, 14477, 14477, 20021, 14588, 14588, 20179, 14700, 14700, 20336, 14811, 14811, 20487, 14923, 14923, 20644, 15041, 15041, 20795, 15152, 15152, 20952, 15263, 15263, 21109, 15375, 15375, 21260, 15486, 15486, 21417, 15598, 15598, 21574, 15709, 15709, 21725, 15820, 15820, 21882, 15938, 15938, 22033, 16050, 16050, 22190, 16161, 16161, 22348, 16273, 16273, 22499, 16384, 16384, 22656, 16495, 16495, 22813, 16607, 16607, 22964, 16718, 16718, 23121, 16830, 16830, 23278, 16948, 16948, 23429, 17059, 17059, 23586, 17170, 17170, 23737, 17282, 17282, 23894, 17393, 17393, 24052, 17505, 17505, 24202, 17616, 17616, 24360, 17727, 17727, 24517, 17845, 17845, 24668, 17957, 17957, 24825, 18068, 18068, 24982, 18180, 18180, 25133, 18291, 18291, 25290, 18403, 18403, 25441, 18514, 18514, 25598, 18625, 18625, 25756, 18743, 18743, 25906, 18855, 18855, 26064, 18966, 18966, 26221, 19078, 19078, 26372, 19189, 19189, 26529, 19300, 19300, 26686, 19412, 19412, 26837, 19523, 19523, 26994, 19641, 19641, 27145, 19753, 19753, 27302, 19864, 19864, 27460, 19975, 19975, 27610, 20087, 20087, 27768, 20198, 20198, 27925, 20310, 20310, 28076, 20421, 20421, 28233, 20539, 20539, 28384, 20650, 20650, 28541, 20762, 20762, 28698, 20873, 20873, 28849, 20985, 20985, 29006, 21096, 21096, 29164, 21207, 21207, 29314, 21319, 21319, 29472, 21437, 21437, 29629, 21548, 21588, 29740, 21660, 21745, 29852, 21771, 21896, 29963, 21882, 22053, 30074, 21994, 22210, 30186, 22105, 22361, 30297, 22217, 22518, 30409, 22335, 22675, 30527, 22446, 22826, 30638, 22557, 22983, 30749, 22669, 23141, 30861, 22780, 23291, 30972, 22892, 23449, 31084, 23003, 23600, 31195, 23115, 23757, 31307, 23233, 23914, 31425, 23344, 24065, 31536, 23455, 24222, 31647, 23567, 24379, 31759, 23678, 24530, 31870, 23790, 24687, 31982, 23901, 24838, 32093, 24012, 24995, 32204, 24130, 25153, 32322, 24242, 25303, 32434, 24353, 25461, 32545, 24465, 25618, 32657, 24576, 25769, 32768, 24687, 25926, 32879, 24799, 26083, 32991, 24910, 26234, 33102, 25022, 26391, 33214, 25140, 26542, 33332, 25251, 26699, 33443, 25362, 26857, 33554, 25474, 27007, 33666, 25585, 27165, 33777, 25697, 27322, 33889, 25808, 27473, 34000, 25919, 27630, 34111, 26037, 27787, 34229, 26149, 27938, 34341, 26260, 28095, 34452, 26372, 28246, 34564, 26483, 28403, 34675, 26595, 28561, 34787, 26706, 28711, 34898, 26817, 28869, 35009, 26935, 29026, 35127, 27047, 29177, 35239, 27158, 29334, 35350, 27270, 29491, 35462, 27381, 29642, 35573, 27492, 29799, 35684, 27604, 29950, 35796, 27715, 30107, 35907, 27833, 30265, 36025, 27945, 30415, 36137, 28056, 30573, 36248, 28167, 30730, 36359, 28279, 30881, 36471, 28390, 31038, 36582, 28502, 31189, 36694, 28613, 31346, 36805, 28731, 31503, 36923, 28842, 31654, 37034, 28954, 31811, 37146, 29065, 31968, 37257, 29177, 32119, 37369, 29288, 32276, 37480, 29399, 32434, 37591, 29511, 32584, 37703, 29629, 32742, 37821, 29740, 32893, 37932, 29852, 33050, 38044, 29963, 33207, 38155, 30074, 33358, 38266, 30186, 33515, 38378, 30297, 33672, 38489, 30409, 33823, 38601, 30527, 33980, 38719, 30638, 34138, 38830, 30749, 34288, 38941, 30861, 34446, 39053, 30972, 34596, 39164, 31084, 34754, 39276, 31195, 34911, 39387, 31307, 35062, 39499, 31425, 35219, 39617, 31536, 35376, 39728, 31647, 35527, 39839, 31759, 35684, 39951, 31870, 35835, 40062, 31982, 35992, 40174, 32093, 36150, 40285, 32204, 36300, 40396, 32322, 36458, 40514, 32434, 36615, 40626, 32545, 36766, 40737, 32657, 36923, 40849, 32768, 37080, 40960, 32879, 37231, 41071, 32991, 37388, 41183, 33102, 37539, 41294, 33214, 37696, 41406, 33332, 37854, 41524, 33443, 38004, 41635, 33554, 38162, 41746, 33666, 38319, 41858, 33777, 38470, 41969, 33889, 38627, 42081, 34000, 38784, 42192, 34111, 38935, 42303, 34229, 39092, 42421, 34341, 39243, 42533, 34452, 39400, 42644, 34564, 39558, 42756, 34675, 39708, 42867, 34787, 39866, 42979, 34898, 40023, 43090, 35009, 40174, 43201, 35127, 40331, 43319, 35239, 40482, 43431, 35350, 40639, 43542, 35462, 40796, 43654, 35573, 40947, 43765, 35684, 41104, 43876, 35796, 41261, 43988, 35907, 41412, 44099, 36025, 41569, 44217, 36137, 41727, 44329, 36248, 41878, 44440, 36359, 42035, 44551, 36471, 42186, 44663, 36582, 42343, 44774, 36694, 42500, 44886, 36805, 42651, 44997, 36923, 42808, 45115, 37034, 42965, 45226, 37146, 43116, 45338, 37257, 43273, 45449, 37369, 43431, 45561, 37480, 43581, 45672, 37591, 43739, 45783, 37703, 43889, 45895, 37821, 44047, 46013, 37932, 44204, 46124, 38044, 44355, 46236, 38155, 44512, 46347, 38266, 44669, 46458, 38378, 44820, 46570, 38489, 44977, 46681, 38601, 45135, 46793, 38719, 45285, 46911, 38830, 45443, 47022, 38941, 45593, 47133, 39053, 45751, 47245, 39164, 45908, 47356, 39276, 46059, 47468, 39387, 46216, 47579, 39499, 46373, 47691, 39617, 46524, 47809, 39728, 46681, 47920, 39839, 46832, 48031, 39951, 46989, 48143, 40062, 47147, 48254, 40174, 47297, 48366, 40285, 47455, 48477, 40396, 47612, 48588, 40514, 47763, 48706, 40626, 47920, 48818, 40737, 48077, 48929, 40849, 48228, 49041, 40960, 48385, 49152, 41071, 48536, 49263, 41183, 48693, 49375, 41294, 48851, 49486, 41406, 49001, 49598, 41524, 49159, 49716, 41635, 49316, 49827, 41746, 49467, 49938, 41858, 49624, 50050, 41969, 49781, 50161, 42081, 49932, 50273, 42192, 50089, 50384, 42303, 50240, 50495, 42421, 50397, 50613, 42533, 50554, 50725, 42644, 50705, 50836, 42756, 50862, 50948, 42867, 51020, 51059, 42979, 51171, 51171, 43155, 51282, 51282, 43332, 51393, 51393, 43509, 51511, 51511, 43686, 51623, 51623, 43863, 51734, 51734, 44040, 51846, 51846, 44211, 51957, 51957, 44388, 52068, 52068, 44564, 52180, 52180, 44741, 52291, 52291, 44918, 52409, 52409, 45095, 52521, 52521, 45272, 52632, 52632, 45449, 52743, 52743, 45626, 52855, 52855, 45797, 52966, 52966, 45974, 53078, 53078, 46150, 53189, 53189, 46327, 53307, 53307, 46504, 53418, 53418, 46681, 53530, 53530, 46858, 53641, 53641, 47035, 53753, 53753, 47212, 53864, 53864, 47383, 53975, 53975, 47559, 54087, 54087, 47736, 54205, 54205, 47913, 54316, 54316, 48090, 54428, 54428, 48267, 54539, 54539, 48444, 54650, 54650, 48621, 54762, 54762, 48798, 54873, 54873, 48968, 54985, 54985, 49145, 55103, 55103, 49322, 55214, 55214, 49499, 55325, 55325, 49676, 55437, 55437, 49853, 55548, 55548, 50030, 55660, 55660, 50207, 55771, 55771, 50384, 55883, 55883, 50554, 56001, 56001, 50731, 56112, 56112, 50908, 56223, 56223, 51085, 56335, 56335, 51262, 56446, 56446, 51439, 56558, 56558, 51616, 56669, 56669, 51793, 56780, 56780, 51970, 56898, 56898, 52140, 57010, 57010, 52317, 57121, 57121, 52494, 57233, 57233, 52671, 57344, 57344, 52848, 57455, 57455, 53025, 57567, 57567, 53202, 57678, 57678, 53379, 57790, 57790, 53556, 57908, 57908, 53726, 58019, 58019, 53903, 58130, 58130, 54080, 58242, 58242, 54257, 58353, 58353, 54434, 58465, 58465, 54611, 58576, 58576, 54788, 58687, 58687, 54965, 58805, 58805, 55142, 58917, 58917, 55312, 59028, 59028, 55489, 59140, 59140, 55666, 59251, 59251, 55843, 59363, 59363, 56020, 59474, 59474, 56197, 59585, 59585, 56374, 59703, 59703, 56551, 59815, 59815, 56728, 59926, 59926, 56898, 60038, 60038, 57075, 60149, 60149, 57252, 60260, 60260, 57429, 60372, 60372, 57606, 60483, 60483, 57783, 60601, 60601, 57960, 60713, 60713, 58137, 60824, 60824, 58314, 60935, 60935, 58484, 61047, 61047, 58661, 61158, 61158, 58838, 61270, 61270, 59015, 61381, 61381, 59192, 61499, 61499, 59369, 61610, 61610, 59546, 61722, 61722, 59723, 61833, 61833, 59900, 61945, 61945, 60070, 62056, 62056, 60247, 62167, 62167, 60424, 62279, 62279, 60601, 62397, 62397, 60778, 62508, 62508, 60955, 62620, 62620, 61132, 62731, 62731, 61309, 62842, 62842, 61486, 62954, 62954, 61656, 63065, 63065, 61833, 63177, 63177, 62010, 63295, 63295, 62187, 63406, 63406, 62364, 63517, 63517, 62541, 63629, 63629, 62718, 63740, 63740, 62895, 63852, 63852, 63072, 63963, 63963, 63242, 64075, 64075, 63419, 64193, 64193, 63596, 64304, 64304, 63773, 64415, 64415, 63950, 64527, 64527, 64127, 64638, 64638, 64304, 64750, 64750, 64481, 64861, 64861, 64658, 64972, 64972, 64828, 65090, 65090, 65005, 65202, 65202, 65182, 65313, 65313, 65359, 65425, 65425, 65535, 65535, 65535};

static unsigned short copper_colormap[] = {0, 0, 0, 157, 98, 66, 321, 203, 125, 478, 301, 190, 642, 400, 256, 800, 498, 321, 963, 603, 380, 1121, 701, 446, 1285, 800, 511, 1442, 904, 577, 1606, 1003, 636, 1763, 1101, 701, 1927, 1199, 767, 2084, 1304, 832, 2241, 1402, 891, 2405, 1501, 957, 2562, 1606, 1022, 2726, 1704, 1088, 2884, 1802, 1147, 3047, 1901, 1212, 3205, 2005, 1278, 3369, 2104, 1337, 3526, 2202, 1402, 3690, 2307, 1468, 3847, 2405, 1534, 4011, 2503, 1593, 4168, 2602, 1658, 4325, 2707, 1724, 4489, 2805, 1789, 4647, 2903, 1848, 4810, 3008, 1914, 4968, 3106, 1979, 5131, 3205, 2045, 5289, 3303, 2104, 5453, 3408, 2169, 5610, 3506, 2235, 5774, 3604, 2294, 5931, 3709, 2359, 6095, 3808, 2425, 6252, 3906, 2490, 6409, 4011, 2549, 6573, 4109, 2615, 6731, 4207, 2680, 6894, 4306, 2746, 7052, 4411, 2805, 7216, 4509, 2870, 7373, 4607, 2936, 7537, 4712, 3002, 7694, 4810, 3061, 7858, 4909, 3126, 8015, 5007, 3192, 8179, 5112, 3257, 8336, 5210, 3316, 8493, 5308, 3382, 8657, 5413, 3447, 8815, 5512, 3506, 8978, 5610, 3572, 9136, 5708, 3637, 9300, 5813, 3703, 9457, 5911, 3762, 9621, 6010, 3827, 9778, 6115, 3893, 9942, 6213, 3958, 10099, 6311, 4017, 10263, 6409, 4083, 10420, 6514, 4148, 10578, 6613, 4214, 10741, 6711, 4273, 10899, 6816, 4338, 11062, 6914, 4404, 11220, 7012, 4470, 11384, 7111, 4529, 11541, 7216, 4594, 11705, 7314, 4660, 11862, 7412, 4719, 12026, 7517, 4784, 12183, 7615, 4850, 12347, 7714, 4915, 12504, 7812, 4974, 12662, 7917, 5040, 12825, 8015, 5105, 12983, 8113, 5171, 13147, 8218, 5230, 13304, 8317, 5295, 13468, 8415, 5361, 13625, 8513, 5426, 13789, 8618, 5485, 13946, 8716, 5551, 14110, 8815, 5616, 14267, 8919, 5675, 14431, 9018, 5741, 14588, 9116, 5806, 14746, 9214, 5872, 14909, 9319, 5931, 15067, 9418, 5997, 15231, 9516, 6062, 15388, 9621, 6128, 15552, 9719, 6187, 15709, 9817, 6252, 15873, 9916, 6318, 16030, 10020, 6383, 16194, 10119, 6442, 16351, 10217, 6508, 16515, 10322, 6573, 16672, 10420, 6639, 16830, 10519, 6698, 16993, 10617, 6763, 17151, 10722, 6829, 17315, 10820, 6888, 17472, 10918, 6953, 17636, 11023, 7019, 17793, 11121, 7084, 17957, 11220, 7143, 18114, 11325, 7209, 18278, 11423, 7274, 18435, 11521, 7340, 18599, 11620, 7399, 18756, 11724, 7465, 18914, 11823, 7530, 19078, 11921, 7596, 19235, 12026, 7655, 19399, 12124, 7720, 19556, 12222, 7786, 19720, 12321, 7851, 19877, 12426, 7910, 20041, 12524, 7976, 20198, 12622, 8041, 20362, 12727, 8100, 20519, 12825, 8166, 20683, 12924, 8231, 20840, 13022, 8297, 21004, 13127, 8356, 21162, 13225, 8421, 21319, 13323, 8487, 21483, 13428, 8552, 21640, 13527, 8611, 21804, 13625, 8677, 21961, 13723, 8743, 22125, 13828, 8808, 22282, 13926, 8867, 22446, 14025, 8933, 22603, 14130, 8998, 22767, 14228, 9057, 22924, 14326, 9123, 23088, 14424, 9188, 23246, 14529, 9254, 23403, 14628, 9313, 23567, 14726, 9378, 23724, 14831, 9444, 23888, 14929, 9509, 24045, 15027, 9568, 24209, 15126, 9634, 24366, 15231, 9699, 24530, 15329, 9765, 24687, 15427, 9824, 24851, 15532, 9889, 25009, 15630, 9955, 25172, 15729, 10020, 25330, 15827, 10079, 25487, 15932, 10145, 25651, 16030, 10211, 25808, 16128, 10269, 25972, 16233, 10335, 26129, 16332, 10401, 26293, 16430, 10466, 26450, 16528, 10525, 26614, 16633, 10591, 26771, 16731, 10656, 26935, 16830, 10722, 27093, 16935, 10781, 27256, 17033, 10846, 27414, 17131, 10912, 27571, 17229, 10977, 27735, 17334, 11036, 27892, 17433, 11102, 28056, 17531, 11167, 28213, 17636, 11233, 28377, 17734, 11292, 28534, 17832, 11357, 28698, 17931, 11423, 28856, 18036, 11482, 29019, 18134, 11547, 29177, 18232, 11613, 29340, 18337, 11679, 29498, 18435, 11737, 29655, 18534, 11803, 29819, 18638, 11869, 29976, 18737, 11934, 30140, 18835, 11993, 30297, 18933, 12059, 30461, 19038, 12124, 30618, 19137, 12190, 30782, 19235, 12249, 30940, 19340, 12314, 31103, 19438, 12380, 31261, 19536, 12439, 31425, 19635, 12504, 31582, 19739, 12570, 31739, 19838, 12635, 31903, 19936, 12694, 32060, 20041, 12760, 32224, 20139, 12825, 32381, 20238, 12891, 32545, 20336, 12950, 32702, 20441, 13015, 32866, 20539, 13081, 33024, 20637, 13147, 33187, 20742, 13206, 33345, 20840, 13271, 33509, 20939, 13337, 33666, 21037, 13402, 33823, 21142, 13461, 33987, 21240, 13527, 34144, 21339, 13592, 34308, 21443, 13651, 34465, 21542, 13717, 34629, 21640, 13782, 34787, 21738, 13848, 34950, 21843, 13907, 35108, 21941, 13972, 35271, 22040, 14038, 35429, 22145, 14103, 35593, 22243, 14162, 35750, 22341, 14228, 35907, 22440, 14293, 36071, 22544, 14359, 36228, 22643, 14418, 36392, 22741, 14483, 36549, 22846, 14549, 36713, 22944, 14615, 36871, 23042, 14674, 37034, 23141, 14739, 37192, 23246, 14805, 37356, 23344, 14864, 37513, 23442, 14929, 37677, 23547, 14995, 37834, 23645, 15060, 37991, 23744, 15119, 38155, 23842, 15185, 38312, 23947, 15250, 38476, 24045, 15316, 38633, 24143, 15375, 38797, 24248, 15440, 38955, 24347, 15506, 39118, 24445, 15571, 39276, 24543, 15630, 39440, 24648, 15696, 39597, 24746, 15761, 39761, 24845, 15820, 39918, 24950, 15886, 40075, 25048, 15951, 40239, 25146, 16017, 40396, 25244, 16076, 40560, 25349, 16142, 40718, 25448, 16207, 40881, 25546, 16273, 41039, 25651, 16332, 41202, 25749, 16397, 41360, 25847, 16463, 41524, 25952, 16528, 41681, 26051, 16587, 41845, 26149, 16653, 42002, 26247, 16718, 42159, 26352, 16784, 42323, 26450, 16843, 42480, 26549, 16908, 42644, 26653, 16974, 42802, 26752, 17033, 42965, 26850, 17098, 43123, 26948, 17164, 43287, 27053, 17229, 43444, 27152, 17288, 43608, 27250, 17354, 43765, 27355, 17419, 43929, 27453, 17485, 44086, 27551, 17544, 44243, 27650, 17610, 44407, 27754, 17675, 44564, 27853, 17741, 44728, 27951, 17800, 44886, 28056, 17865, 45049, 28154, 17931, 45207, 28253, 17990, 45371, 28351, 18055, 45528, 28456, 18121, 45692, 28554, 18186, 45849, 28652, 18245, 46013, 28757, 18311, 46170, 28856, 18376, 46327, 28954, 18442, 46491, 29052, 18501, 46649, 29157, 18566, 46812, 29255, 18632, 46970, 29354, 18697, 47133, 29458, 18756, 47291, 29557, 18822, 47455, 29655, 18887, 47612, 29753, 18953, 47776, 29858, 19012, 47933, 29957, 19078, 48097, 30055, 19143, 48254, 30160, 19202, 48411, 30258, 19268, 48575, 30356, 19333, 48733, 30455, 19399, 48896, 30559, 19458, 49054, 30658, 19523, 49218, 30756, 19589, 49375, 30861, 19654, 49539, 30959, 19713, 49696, 31058, 19779, 49860, 31156, 19844, 50017, 31261, 19910, 50181, 31359, 19969, 50338, 31457, 20034, 50495, 31562, 20100, 50659, 31660, 20165, 50817, 31759, 20224, 50980, 31857, 20290, 51138, 31962, 20355, 51302, 32060, 20414, 51459, 32159, 20480, 51623, 32263, 20546, 51780, 32362, 20611, 51944, 32460, 20670, 52101, 32558, 20736, 52265, 32663, 20801, 52422, 32761, 20867, 52580, 32860, 20926, 52743, 32965, 20991, 52901, 33063, 21057, 53064, 33161, 21122, 53222, 33266, 21181, 53386, 33364, 21247, 53543, 33463, 21312, 53707, 33561, 21371, 53864, 33666, 21437, 54028, 33764, 21502, 54185, 33862, 21568, 54349, 33967, 21627, 54506, 34066, 21692, 54664, 34164, 21758, 54827, 34262, 21823, 54985, 34367, 21882, 55149, 34465, 21948, 55306, 34564, 22014, 55470, 34669, 22079, 55627, 34767, 22138, 55791, 34865, 22204, 55948, 34963, 22269, 56112, 35068, 22335, 56269, 35167, 22394, 56433, 35265, 22459, 56590, 35370, 22525, 56748, 35468, 22584, 56911, 35566, 22649, 57069, 35665, 22715, 57233, 35770, 22780, 57390, 35868, 22839, 57554, 35966, 22905, 57711, 36071, 22970, 57875, 36169, 23036, 58032, 36268, 23095, 58196, 36366, 23160, 58353, 36471, 23226, 58517, 36569, 23291, 58674, 36667, 23350, 58832, 36772, 23416, 58996, 36871, 23482, 59153, 36969, 23547, 59317, 37067, 23606, 59474, 37172, 23672, 59638, 37270, 23737, 59795, 37369, 23796, 59959, 37473, 23862, 60116, 37572, 23927, 60280, 37670, 23993, 60437, 37768, 24052, 60601, 37873, 24117, 60758, 37972, 24183, 60916, 38070, 24248, 61080, 38175, 24307, 61237, 38273, 24373, 61401, 38371, 24438, 61558, 38470, 24504, 61722, 38574, 24563, 61879, 38673, 24628, 62043, 38771, 24694, 62200, 38876, 24753, 62364, 38974, 24818, 62521, 39073, 24884, 62685, 39171, 24950, 62842, 39276, 25009, 63006, 39374, 25074, 63164, 39472, 25140, 63321, 39577, 25205, 63485, 39675, 25264, 63642, 39774, 25330, 63806, 39872, 25395, 63963, 39977, 25461, 64127, 40075, 25520, 64284, 40174, 25585, 64448, 40278, 25651, 64605, 40377, 25716, 64769, 40475, 25775, 64927, 40580, 25841, 65090, 40678, 25906, 65248, 40776, 25965, 65405, 40875, 26031, 65535, 40980, 26096, 65535, 41078, 26162, 65535, 41176, 26221, 65535, 41281, 26286, 65535, 41379, 26352, 65535, 41478, 26418, 65535, 41576, 26477, 65535, 41681, 26542, 65535, 41779, 26608, 65535, 41878, 26673, 65535, 41982, 26732, 65535, 42081, 26798, 65535, 42179, 26863, 65535, 42277, 26929, 65535, 42382, 26988, 65535, 42480, 27053, 65535, 42579, 27119, 65535, 42684, 27178, 65535, 42782, 27243, 65535, 42880, 27309, 65535, 42979, 27374, 65535, 43083, 27433, 65535, 43182, 27499, 65535, 43280, 27564, 65535, 43385, 27630, 65535, 43483, 27689, 65535, 43581, 27754, 65535, 43680, 27820, 65535, 43785, 27886, 65535, 43883, 27945, 65535, 43981, 28010, 65535, 44086, 28076, 65535, 44184, 28135, 65535, 44283, 28200, 65535, 44381, 28266, 65535, 44486, 28331, 65535, 44584, 28390, 65535, 44682, 28456, 65535, 44787, 28521, 65535, 44886, 28587, 65535, 44984, 28646, 65535, 45082, 28711, 65535, 45187, 28777, 65535, 45285, 28842, 65535, 45384, 28901, 65535, 45489, 28967, 65535, 45587, 29032, 65535, 45685, 29098, 65535, 45783, 29157, 65535, 45888, 29223, 65535, 45987, 29288, 65535, 46085, 29347, 65535, 46190, 29413, 65535, 46288, 29478, 65535, 46386, 29544, 65535, 46485, 29603, 65535, 46590, 29668, 65535, 46688, 29734, 65535, 46786, 29799, 65535, 46891, 29858, 65535, 46989, 29924, 65535, 47088, 29989, 65535, 47186, 30055, 65535, 47291, 30114, 65535, 47389, 30179, 65535, 47487, 30245, 65535, 47592, 30310, 65535, 47691, 30369, 65535, 47789, 30435, 65535, 47894, 30500, 65535, 47992, 30559, 65535, 48090, 30625, 65535, 48189, 30691, 65535, 48293, 30756, 65535, 48392, 30815, 65535, 48490, 30881, 65535, 48595, 30946, 65535, 48693, 31012, 65535, 48792, 31071, 65535, 48890, 31136, 65535, 48995, 31202, 65535, 49093, 31267, 65535, 49191, 31326, 65535, 49296, 31392, 65535, 49394, 31457, 65535, 49493, 31516, 65535, 49591, 31582, 65535, 49696, 31647, 65535, 49794, 31713, 65535, 49893, 31772, 65535, 49997, 31837, 65535, 50096, 31903, 65535, 50194, 31968, 65535, 50292, 32027, 65535, 50397, 32093, 65535, 50495, 32159, 65535, 50594, 32224, 65535, 50699, 32283, 65535, 50797, 32349, 65535, 50895, 32414, 65535, 50994, 32480, 65535, 51098, 32539, 65535, 51197, 32604};

static unsigned short pink_colormap[] = {2733, 0, 0, 4529, 2366, 2366, 5793, 3349, 3349, 6829, 4103, 4103, 7727, 4732, 4732, 8533, 5295, 5295, 9267, 5800, 5800, 9942, 6265, 6265, 10578, 6698, 6698, 11180, 7104, 7104, 11751, 7484, 7484, 12295, 7851, 7851, 12812, 8199, 8199, 13310, 8533, 8533, 13795, 8854, 8854, 14261, 9168, 9168, 14713, 9470, 9470, 15145, 9758, 9758, 15571, 10040, 10040, 15984, 10315, 10315, 16391, 10584, 10584, 16784, 10846, 10846, 17170, 11102, 11102, 17544, 11351, 11351, 17911, 11593, 11593, 18271, 11836, 11836, 18625, 12072, 12072, 18973, 12301, 12301, 19313, 12524, 12524, 19654, 12747, 12747, 19982, 12963, 12963, 20303, 13179, 13179, 20624, 13389, 13389, 20939, 13599, 13599, 21247, 13802, 13802, 21555, 14005, 14005, 21856, 14202, 14202, 22151, 14398, 14398, 22446, 14595, 14595, 22734, 14785, 14785, 23016, 14968, 14968, 23298, 15158, 15158, 23580, 15342, 15342, 23855, 15525, 15525, 24124, 15702, 15702, 24392, 15879, 15879, 24661, 16056, 16056, 24923, 16227, 16227, 25185, 16397, 16397, 25441, 16568, 16568, 25697, 16738, 16738, 25952, 16902, 16902, 26201, 17072, 17072, 26450, 17236, 17236, 26699, 17393, 17393, 26942, 17557, 17557, 27184, 17714, 17714, 27420, 17872, 17872, 27656, 18029, 18029, 27892, 18180, 18180, 28128, 18337, 18337, 28357, 18488, 18488, 28587, 18638, 18638, 28816, 18789, 18789, 29039, 18940, 18940, 29262, 19084, 19084, 29485, 19228, 19228, 29707, 19379, 19379, 29924, 19523, 19523, 30140, 19661, 19661, 30356, 19805, 19805, 30573, 19943, 19943, 30789, 20087, 20087, 30999, 20224, 20224, 31208, 20362, 20362, 31418, 20500, 20500, 31621, 20637, 20637, 31831, 20768, 20768, 32034, 20906, 20906, 32237, 21037, 21037, 32440, 21175, 21175, 32637, 21306, 21306, 32840, 21437, 21437, 33037, 21568, 21568, 33233, 21692, 21692, 33430, 21823, 21823, 33627, 21955, 21955, 33817, 22079, 22079, 34013, 22204, 22204, 34203, 22335, 22335, 34393, 22459, 22459, 34583, 22584, 22584, 34773, 22702, 22702, 34957, 22826, 22826, 35147, 22951, 22951, 35330, 23075, 23075, 35514, 23193, 23193, 35697, 23311, 23311, 35881, 23436, 23436, 36058, 23554, 23554, 36241, 23672, 23672, 36418, 23790, 23790, 36602, 23908, 23908, 36779, 24025, 24025, 36956, 24137, 24137, 37133, 24255, 24255, 37310, 24373, 24373, 37480, 24484, 24484, 37657, 24602, 24602, 37827, 24714, 24714, 37998, 24825, 24825, 38175, 24936, 24936, 38345, 25054, 25054, 38516, 25166, 25166, 38679, 25277, 25277, 38850, 25382, 25382, 39020, 25494, 25494, 39184, 25605, 25605, 39354, 25716, 25716, 39518, 25821, 25821, 39682, 25933, 25933, 39846, 26037, 26037, 40010, 26149, 26149, 40174, 26254, 26254, 40337, 26359, 26359, 40495, 26463, 26463, 40659, 26568, 26568, 40816, 26673, 26673, 40980, 26778, 26778, 41137, 26883, 26883, 41294, 26988, 26988, 41452, 27093, 27093, 41609, 27197, 27197, 41766, 27302, 27302, 41923, 27401, 27401, 42081, 27505, 27505, 42231, 27604, 27604, 42389, 27709, 27709, 42539, 27807, 27807, 42697, 27905, 27905, 42847, 28010, 28010, 42998, 28108, 28108, 43149, 28207, 28207, 43300, 28305, 28305, 43450, 28403, 28403, 43601, 28502, 28502, 43752, 28600, 28600, 43903, 28698, 28698, 44047, 28797, 28797, 44197, 28895, 28895, 44342, 28993, 28993, 44492, 29085, 29085, 44637, 29183, 29183, 44787, 29281, 29281, 44931, 29373, 29373, 45076, 29472, 29472, 45220, 29563, 29563, 45364, 29662, 29662, 45508, 29753, 29753, 45652, 29852, 29852, 45797, 29943, 29943, 45934, 30035, 30035, 46078, 30127, 30127, 46216, 30219, 30219, 46360, 30317, 30317, 46498, 30409, 30409, 46642, 30500, 30500, 46780, 30592, 30592, 46917, 30684, 30684, 47061, 30776, 30776, 47199, 30861, 30861, 47337, 30953, 30953, 47474, 31044, 31044, 47612, 31136, 31136, 47750, 31228, 31228, 47887, 31313, 31313, 48018, 31405, 31405, 48156, 31490, 31490, 48293, 31582, 31582, 48425, 31667, 31667, 48562, 31759, 31759, 48693, 31844, 31844, 48831, 31936, 31936, 48962, 32021, 32021, 49100, 32113, 32113, 49231, 32198, 32198, 49362, 32283, 32283, 49493, 32368, 32368, 49624, 32453, 32453, 49755, 32545, 32545, 49886, 32630, 32630, 50017, 32716, 32716, 50076, 32912, 32801, 50128, 33109, 32886, 50187, 33305, 32971, 50240, 33502, 33056, 50299, 33699, 33142, 50351, 33889, 33227, 50410, 34085, 33305, 50463, 34275, 33391, 50522, 34465, 33476, 50574, 34655, 33561, 50633, 34839, 33646, 50686, 35029, 33725, 50745, 35212, 33810, 50797, 35396, 33895, 50849, 35586, 33974, 50908, 35763, 34059, 50961, 35946, 34138, 51020, 36130, 34223, 51072, 36307, 34302, 51125, 36490, 34387, 51184, 36667, 34465, 51236, 36844, 34544, 51288, 37021, 34629, 51347, 37198, 34708, 51400, 37375, 34787, 51452, 37546, 34872, 51511, 37723, 34950, 51564, 37893, 35029, 51616, 38063, 35108, 51675, 38234, 35193, 51728, 38404, 35271, 51780, 38574, 35350, 51832, 38745, 35429, 51891, 38915, 35507, 51944, 39079, 35586, 51996, 39250, 35665, 52049, 39413, 35743, 52101, 39577, 35822, 52160, 39741, 35901, 52213, 39905, 35979, 52265, 40069, 36058, 52317, 40233, 36130, 52370, 40396, 36209, 52429, 40560, 36287, 52481, 40718, 36366, 52534, 40875, 36445, 52586, 41039, 36517, 52639, 41196, 36595, 52691, 41353, 36674, 52743, 41511, 36746, 52796, 41668, 36825, 52848, 41825, 36903, 52907, 41982, 36975, 52960, 42140, 37054, 53012, 42290, 37126, 53064, 42448, 37205, 53117, 42598, 37277, 53169, 42749, 37356, 53222, 42906, 37428, 53274, 43057, 37500, 53327, 43208, 37578, 53379, 43359, 37650, 53432, 43509, 37729, 53484, 43660, 37801, 53536, 43811, 37873, 53589, 43955, 37945, 53641, 44106, 38024, 53694, 44250, 38096, 53746, 44401, 38168, 53799, 44545, 38240, 53851, 44696, 38312, 53903, 44840, 38391, 53956, 44984, 38463, 54008, 45128, 38535, 54054, 45272, 38607, 54107, 45416, 38679, 54159, 45561, 38751, 54211, 45705, 38824, 54264, 45849, 38896, 54316, 45987, 38968, 54369, 46131, 39040, 54421, 46275, 39112, 54467, 46413, 39184, 54519, 46557, 39256, 54572, 46694, 39328, 54624, 46832, 39400, 54677, 46970, 39466, 54729, 47114, 39538, 54775, 47251, 39610, 54827, 47389, 39682, 54880, 47527, 39754, 54932, 47664, 39820, 54985, 47802, 39892, 55031, 47933, 39964, 55083, 48071, 40029, 55135, 48208, 40101, 55188, 48346, 40174, 55234, 48477, 40239, 55286, 48615, 40311, 55339, 48746, 40383, 55391, 48883, 40449, 55437, 49014, 40521, 55489, 49145, 40586, 55542, 49277, 40659, 55588, 49414, 40724, 55640, 49545, 40796, 55692, 49676, 40862, 55738, 49807, 40934, 55791, 49938, 40999, 55843, 50070, 41071, 55889, 50201, 41137, 55942, 50332, 41202, 55994, 50456, 41275, 56040, 50587, 41340, 56092, 50718, 41406, 56145, 50843, 41478, 56191, 50974, 41543, 56243, 51098, 41609, 56289, 51229, 41681, 56341, 51354, 41746, 56394, 51485, 41812, 56440, 51610, 41878, 56492, 51734, 41943, 56538, 51865, 42015, 56590, 51990, 42081, 56636, 52114, 42146, 56689, 52239, 42212, 56735, 52363, 42277, 56787, 52488, 42343, 56833, 52612, 42408, 56885, 52737, 42474, 56938, 52861, 42546, 56984, 52986, 42612, 57036, 53104, 42677, 57082, 53228, 42743, 57128, 53353, 42808, 57180, 53471, 42874, 57226, 53595, 42939, 57278, 53720, 42998, 57324, 53838, 43064, 57377, 53962, 43129, 57423, 54080, 43195, 57475, 54198, 43260, 57521, 54323, 43326, 57573, 54441, 43391, 57619, 54559, 43457, 57665, 54683, 43522, 57718, 54801, 43581, 57763, 54919, 43647, 57816, 55037, 43713, 57862, 55155, 43778, 57908, 55273, 43837, 57960, 55391, 43903, 58006, 55509, 43968, 58058, 55627, 44034, 58104, 55745, 44093, 58150, 55863, 44158, 58203, 55981, 44224, 58248, 56099, 44283, 58294, 56210, 44348, 58347, 56328, 44414, 58393, 56446, 44473, 58438, 56558, 44538, 58491, 56676, 44597, 58537, 56787, 44663, 58583, 56905, 44728, 58629, 57023, 44787, 58681, 57134, 44853, 58727, 57246, 44912, 58773, 57364, 44977, 58825, 57475, 45036, 58871, 57586, 45102, 58917, 57704, 45161, 58963, 57816, 45226, 59015, 57927, 45285, 59061, 58039, 45351, 59107, 58157, 45410, 59153, 58268, 45469, 59205, 58379, 45534, 59251, 58491, 45593, 59297, 58602, 45659, 59343, 58714, 45718, 59389, 58825, 45777, 59441, 58937, 45842, 59487, 59048, 45901, 59533, 59153, 45960, 59579, 59264, 46019, 59625, 59376, 46085, 59671, 59487, 46144, 59723, 59598, 46203, 59769, 59703, 46268, 59815, 59815, 46327, 59861, 59861, 46504, 59906, 59906, 46688, 59952, 59952, 46865, 59998, 59998, 47048, 60051, 60051, 47225, 60097, 60097, 47402, 60142, 60142, 47579, 60188, 60188, 47756, 60234, 60234, 47926, 60280, 60280, 48103, 60326, 60326, 48280, 60372, 60372, 48451, 60418, 60418, 48621, 60464, 60464, 48798, 60516, 60516, 48968, 60562, 60562, 49139, 60608, 60608, 49309, 60654, 60654, 49480, 60699, 60699, 49650, 60745, 60745, 49820, 60791, 60791, 49984, 60837, 60837, 50155, 60883, 60883, 50319, 60929, 60929, 50489, 60975, 60975, 50653, 61021, 61021, 50817, 61066, 61066, 50987, 61112, 61112, 51151, 61158, 61158, 51315, 61204, 61204, 51479, 61250, 61250, 51636, 61296, 61296, 51800, 61342, 61342, 51963, 61388, 61388, 52121, 61433, 61433, 52285, 61479, 61479, 52442, 61525, 61525, 52606, 61571, 61571, 52763, 61617, 61617, 52920, 61656, 61656, 53084, 61702, 61702, 53241, 61748, 61748, 53399, 61794, 61794, 53556, 61840, 61840, 53707, 61886, 61886, 53864, 61932, 61932, 54021, 61977, 61977, 54179, 62023, 62023, 54329, 62069, 62069, 54487, 62115, 62115, 54637, 62154, 62154, 54795, 62200, 62200, 54945, 62246, 62246, 55096, 62292, 62292, 55253, 62338, 62338, 55404, 62384, 62384, 55555, 62430, 62430, 55706, 62469, 62469, 55856, 62515, 62515, 56007, 62561, 62561, 56158, 62607, 62607, 56302, 62652, 62652, 56453, 62698, 62698, 56603, 62738, 62738, 56748, 62783, 62783, 56898, 62829, 62829, 57043, 62875, 62875, 57193, 62921, 62921, 57337, 62960, 62960, 57482, 63006, 63006, 57632, 63052, 63052, 57777, 63098, 63098, 57921, 63144, 63144, 58065, 63183, 63183, 58209, 63229, 63229, 58353, 63275, 63275, 58497, 63321, 63321, 58642, 63360, 63360, 58786, 63406, 63406, 58923, 63452, 63452, 59068, 63498, 63498, 59212, 63537, 63537, 59349, 63583, 63583, 59494, 63629, 63629, 59638, 63668, 63668, 59775, 63714, 63714, 59913, 63760, 63760, 60057, 63806, 63806, 60195, 63845, 63845, 60332, 63891, 63891, 60470, 63937, 63937, 60614, 63976, 63976, 60752, 64022, 64022, 60889, 64068, 64068, 61027, 64107, 64107, 61165, 64153, 64153, 61302, 64199, 64199, 61440, 64238, 64238, 61571, 64284, 64284, 61709, 64330, 64330, 61846, 64369, 64369, 61984, 64415, 64415, 62115, 64461, 64461, 62253, 64501, 64501, 62384, 64546, 64546, 62521, 64586, 64586, 62652, 64632, 64632, 62790, 64677, 64677, 62921, 64717, 64717, 63059, 64763, 64763, 63190, 64802, 64802, 63321, 64848, 64848, 63452, 64894, 64894, 63583, 64933, 64933, 63721, 64979, 64979, 63852, 65018, 65018, 63983, 65064, 65064, 64114, 65110, 65110, 64245, 65149, 65149, 64376, 65195, 65195, 64501, 65235, 65235, 64632, 65280, 65280, 64763, 65320, 65320, 64894, 65366, 65366, 65025, 65405, 65405, 65149, 65451, 65451, 65280, 65490, 65490, 65405, 65535, 65535, 65535};

static unsigned short jet_colormap[] = {0, 0, 33279, 0, 0, 33790, 0, 0, 34302, 0, 0, 34813, 0, 0, 35330, 0, 0, 35842, 0, 0, 36353, 0, 0, 36864, 0, 0, 37375, 0, 0, 37886, 0, 0, 38398, 0, 0, 38915, 0, 0, 39426, 0, 0, 39938, 0, 0, 40449, 0, 0, 40960, 0, 0, 41471, 0, 0, 41982, 0, 0, 42494, 0, 0, 43005, 0, 0, 43522, 0, 0, 44034, 0, 0, 44545, 0, 0, 45056, 0, 0, 45567, 0, 0, 46078, 0, 0, 46590, 0, 0, 47107, 0, 0, 47618, 0, 0, 48130, 0, 0, 48641, 0, 0, 49152, 0, 0, 49663, 0, 0, 50174, 0, 0, 50686, 0, 0, 51197, 0, 0, 51714, 0, 0, 52226, 0, 0, 52737, 0, 0, 53248, 0, 0, 53759, 0, 0, 54270, 0, 0, 54782, 0, 0, 55299, 0, 0, 55810, 0, 0, 56322, 0, 0, 56833, 0, 0, 57344, 0, 0, 57855, 0, 0, 58366, 0, 0, 58878, 0, 0, 59389, 0, 0, 59906, 0, 0, 60418, 0, 0, 60929, 0, 0, 61440, 0, 0, 61951, 0, 0, 62462, 0, 0, 62974, 0, 0, 63491, 0, 0, 64002, 0, 0, 64514, 0, 0, 65025, 0, 0, 65535, 0, 511, 65535, 0, 1022, 65535, 0, 1534, 65535, 0, 2045, 65535, 0, 2562, 65535, 0, 3074, 65535, 0, 3585, 65535, 0, 4096, 65535, 0, 4607, 65535, 0, 5118, 65535, 0, 5630, 65535, 0, 6147, 65535, 0, 6658, 65535, 0, 7170, 65535, 0, 7681, 65535, 0, 8192, 65535, 0, 8703, 65535, 0, 9214, 65535, 0, 9726, 65535, 0, 10237, 65535, 0, 10754, 65535, 0, 11266, 65535, 0, 11777, 65535, 0, 12288, 65535, 0, 12799, 65535, 0, 13310, 65535, 0, 13822, 65535, 0, 14339, 65535, 0, 14850, 65535, 0, 15362, 65535, 0, 15873, 65535, 0, 16384, 65535, 0, 16895, 65535, 0, 17406, 65535, 0, 17918, 65535, 0, 18429, 65535, 0, 18946, 65535, 0, 19458, 65535, 0, 19969, 65535, 0, 20480, 65535, 0, 20991, 65535, 0, 21502, 65535, 0, 22014, 65535, 0, 22531, 65535, 0, 23042, 65535, 0, 23554, 65535, 0, 24065, 65535, 0, 24576, 65535, 0, 25087, 65535, 0, 25598, 65535, 0, 26110, 65535, 0, 26621, 65535, 0, 27138, 65535, 0, 27650, 65535, 0, 28161, 65535, 0, 28672, 65535, 0, 29183, 65535, 0, 29694, 65535, 0, 30206, 65535, 0, 30723, 65535, 0, 31234, 65535, 0, 31746, 65535, 0, 32257, 65535, 0, 32768, 65535, 0, 33279, 65535, 0, 33790, 65535, 0, 34302, 65535, 0, 34813, 65535, 0, 35330, 65535, 0, 35842, 65535, 0, 36353, 65535, 0, 36864, 65535, 0, 37375, 65535, 0, 37886, 65535, 0, 38398, 65535, 0, 38915, 65535, 0, 39426, 65535, 0, 39938, 65535, 0, 40449, 65535, 0, 40960, 65535, 0, 41471, 65535, 0, 41982, 65535, 0, 42494, 65535, 0, 43005, 65535, 0, 43522, 65535, 0, 44034, 65535, 0, 44545, 65535, 0, 45056, 65535, 0, 45567, 65535, 0, 46078, 65535, 0, 46590, 65535, 0, 47107, 65535, 0, 47618, 65535, 0, 48130, 65535, 0, 48641, 65535, 0, 49152, 65535, 0, 49663, 65535, 0, 50174, 65535, 0, 50686, 65535, 0, 51197, 65535, 0, 51714, 65535, 0, 52226, 65535, 0, 52737, 65535, 0, 53248, 65535, 0, 53759, 65535, 0, 54270, 65535, 0, 54782, 65535, 0, 55299, 65535, 0, 55810, 65535, 0, 56322, 65535, 0, 56833, 65535, 0, 57344, 65535, 0, 57855, 65535, 0, 58366, 65535, 0, 58878, 65535, 0, 59389, 65535, 0, 59906, 65535, 0, 60418, 65535, 0, 60929, 65535, 0, 61440, 65535, 0, 61951, 65535, 0, 62462, 65535, 0, 62974, 65535, 0, 63491, 65535, 0, 64002, 65535, 0, 64514, 65535, 0, 65025, 65535, 0, 65535, 65535, 511, 65535, 65535, 1022, 65535, 65025, 1534, 65535, 64514, 2045, 65535, 64002, 2562, 65535, 63491, 3074, 65535, 62974, 3585, 65535, 62462, 4096, 65535, 61951, 4607, 65535, 61440, 5118, 65535, 60929, 5630, 65535, 60418, 6147, 65535, 59906, 6658, 65535, 59389, 7170, 65535, 58878, 7681, 65535, 58366, 8192, 65535, 57855, 8703, 65535, 57344, 9214, 65535, 56833, 9726, 65535, 56322, 10237, 65535, 55810, 10754, 65535, 55299, 11266, 65535, 54782, 11777, 65535, 54270, 12288, 65535, 53759, 12799, 65535, 53248, 13310, 65535, 52737, 13822, 65535, 52226, 14339, 65535, 51714, 14850, 65535, 51197, 15362, 65535, 50686, 15873, 65535, 50174, 16384, 65535, 49663, 16895, 65535, 49152, 17406, 65535, 48641, 17918, 65535, 48130, 18429, 65535, 47618, 18946, 65535, 47107, 19458, 65535, 46590, 19969, 65535, 46078, 20480, 65535, 45567, 20991, 65535, 45056, 21502, 65535, 44545, 22014, 65535, 44034, 22531, 65535, 43522, 23042, 65535, 43005, 23554, 65535, 42494, 24065, 65535, 41982, 24576, 65535, 41471, 25087, 65535, 40960, 25598, 65535, 40449, 26110, 65535, 39938, 26621, 65535, 39426, 27138, 65535, 38915, 27650, 65535, 38398, 28161, 65535, 37886, 28672, 65535, 37375, 29183, 65535, 36864, 29694, 65535, 36353, 30206, 65535, 35842, 30723, 65535, 35330, 31234, 65535, 34813, 31746, 65535, 34302, 32257, 65535, 33790, 32768, 65535, 33279, 33279, 65535, 32768, 33790, 65535, 32257, 34302, 65535, 31746, 34813, 65535, 31234, 35330, 65535, 30723, 35842, 65535, 30206, 36353, 65535, 29694, 36864, 65535, 29183, 37375, 65535, 28672, 37886, 65535, 28161, 38398, 65535, 27650, 38915, 65535, 27138, 39426, 65535, 26621, 39938, 65535, 26110, 40449, 65535, 25598, 40960, 65535, 25087, 41471, 65535, 24576, 41982, 65535, 24065, 42494, 65535, 23554, 43005, 65535, 23042, 43522, 65535, 22531, 44034, 65535, 22014, 44545, 65535, 21502, 45056, 65535, 20991, 45567, 65535, 20480, 46078, 65535, 19969, 46590, 65535, 19458, 47107, 65535, 18946, 47618, 65535, 18429, 48130, 65535, 17918, 48641, 65535, 17406, 49152, 65535, 16895, 49663, 65535, 16384, 50174, 65535, 15873, 50686, 65535, 15362, 51197, 65535, 14850, 51714, 65535, 14339, 52226, 65535, 13822, 52737, 65535, 13310, 53248, 65535, 12799, 53759, 65535, 12288, 54270, 65535, 11777, 54782, 65535, 11266, 55299, 65535, 10754, 55810, 65535, 10237, 56322, 65535, 9726, 56833, 65535, 9214, 57344, 65535, 8703, 57855, 65535, 8192, 58366, 65535, 7681, 58878, 65535, 7170, 59389, 65535, 6658, 59906, 65535, 6147, 60418, 65535, 5630, 60929, 65535, 5118, 61440, 65535, 4607, 61951, 65535, 4096, 62462, 65535, 3585, 62974, 65535, 3074, 63491, 65535, 2562, 64002, 65535, 2045, 64514, 65535, 1534, 65025, 65535, 1022, 65535, 65535, 511, 65535, 65535, 0, 65535, 65025, 0, 65535, 64514, 0, 65535, 64002, 0, 65535, 63491, 0, 65535, 62974, 0, 65535, 62462, 0, 65535, 61951, 0, 65535, 61440, 0, 65535, 60929, 0, 65535, 60418, 0, 65535, 59906, 0, 65535, 59389, 0, 65535, 58878, 0, 65535, 58366, 0, 65535, 57855, 0, 65535, 57344, 0, 65535, 56833, 0, 65535, 56322, 0, 65535, 55810, 0, 65535, 55299, 0, 65535, 54782, 0, 65535, 54270, 0, 65535, 53759, 0, 65535, 53248, 0, 65535, 52737, 0, 65535, 52226, 0, 65535, 51714, 0, 65535, 51197, 0, 65535, 50686, 0, 65535, 50174, 0, 65535, 49663, 0, 65535, 49152, 0, 65535, 48641, 0, 65535, 48130, 0, 65535, 47618, 0, 65535, 47107, 0, 65535, 46590, 0, 65535, 46078, 0, 65535, 45567, 0, 65535, 45056, 0, 65535, 44545, 0, 65535, 44034, 0, 65535, 43522, 0, 65535, 43005, 0, 65535, 42494, 0, 65535, 41982, 0, 65535, 41471, 0, 65535, 40960, 0, 65535, 40449, 0, 65535, 39938, 0, 65535, 39426, 0, 65535, 38915, 0, 65535, 38398, 0, 65535, 37886, 0, 65535, 37375, 0, 65535, 36864, 0, 65535, 36353, 0, 65535, 35842, 0, 65535, 35330, 0, 65535, 34813, 0, 65535, 34302, 0, 65535, 33790, 0, 65535, 33279, 0, 65535, 32768, 0, 65535, 32257, 0, 65535, 31746, 0, 65535, 31234, 0, 65535, 30723, 0, 65535, 30206, 0, 65535, 29694, 0, 65535, 29183, 0, 65535, 28672, 0, 65535, 28161, 0, 65535, 27650, 0, 65535, 27138, 0, 65535, 26621, 0, 65535, 26110, 0, 65535, 25598, 0, 65535, 25087, 0, 65535, 24576, 0, 65535, 24065, 0, 65535, 23554, 0, 65535, 23042, 0, 65535, 22531, 0, 65535, 22014, 0, 65535, 21502, 0, 65535, 20991, 0, 65535, 20480, 0, 65535, 19969, 0, 65535, 19458, 0, 65535, 18946, 0, 65535, 18429, 0, 65535, 17918, 0, 65535, 17406, 0, 65535, 16895, 0, 65535, 16384, 0, 65535, 15873, 0, 65535, 15362, 0, 65535, 14850, 0, 65535, 14339, 0, 65535, 13822, 0, 65535, 13310, 0, 65535, 12799, 0, 65535, 12288, 0, 65535, 11777, 0, 65535, 11266, 0, 65535, 10754, 0, 65535, 10237, 0, 65535, 9726, 0, 65535, 9214, 0, 65535, 8703, 0, 65535, 8192, 0, 65535, 7681, 0, 65535, 7170, 0, 65535, 6658, 0, 65535, 6147, 0, 65535, 5630, 0, 65535, 5118, 0, 65535, 4607, 0, 65535, 4096, 0, 65535, 3585, 0, 65535, 3074, 0, 65535, 2562, 0, 65535, 2045, 0, 65535, 1534, 0, 65535, 1022, 0, 65535, 511, 0, 65535, 0, 0, 65025, 0, 0, 64514, 0, 0, 64002, 0, 0, 63491, 0, 0, 62974, 0, 0, 62462, 0, 0, 61951, 0, 0, 61440, 0, 0, 60929, 0, 0, 60418, 0, 0, 59906, 0, 0, 59389, 0, 0, 58878, 0, 0, 58366, 0, 0, 57855, 0, 0, 57344, 0, 0, 56833, 0, 0, 56322, 0, 0, 55810, 0, 0, 55299, 0, 0, 54782, 0, 0, 54270, 0, 0, 53759, 0, 0, 53248, 0, 0, 52737, 0, 0, 52226, 0, 0, 51714, 0, 0, 51197, 0, 0, 50686, 0, 0, 50174, 0, 0, 49663, 0, 0, 49152, 0, 0, 48641, 0, 0, 48130, 0, 0, 47618, 0, 0, 47107, 0, 0, 46590, 0, 0, 46078, 0, 0, 45567, 0, 0, 45056, 0, 0, 44545, 0, 0, 44034, 0, 0, 43522, 0, 0, 43005, 0, 0, 42494, 0, 0, 41982, 0, 0, 41471, 0, 0, 40960, 0, 0, 40449, 0, 0, 39938, 0, 0, 39426, 0, 0, 38915, 0, 0, 38398, 0, 0, 37886, 0, 0, 37375, 0, 0, 36864, 0, 0, 36353, 0, 0, 35842, 0, 0, 35330, 0, 0, 34813, 0, 0, 34302, 0, 0, 33790, 0, 0, 33279, 0, 0};

static unsigned short prism_colormap[] = {65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 43693, 0, 65535, 65535, 0, 0, 65535, 32768, 0};

static unsigned short autumn_colormap[] = {65535, 0, 0, 65535, 131, 0, 65535, 256, 0, 65535, 387, 0, 65535, 511, 0, 65535, 642, 0, 65535, 767, 0, 65535, 898, 0, 65535, 1029, 0, 65535, 1153, 0, 65535, 1285, 0, 65535, 1409, 0, 65535, 1540, 0, 65535, 1665, 0, 65535, 1796, 0, 65535, 1927, 0, 65535, 2051, 0, 65535, 2182, 0, 65535, 2307, 0, 65535, 2438, 0, 65535, 2562, 0, 65535, 2694, 0, 65535, 2825, 0, 65535, 2949, 0, 65535, 3080, 0, 65535, 3205, 0, 65535, 3336, 0, 65535, 3460, 0, 65535, 3591, 0, 65535, 3722, 0, 65535, 3847, 0, 65535, 3978, 0, 65535, 4103, 0, 65535, 4234, 0, 65535, 4358, 0, 65535, 4489, 0, 65535, 4620, 0, 65535, 4745, 0, 65535, 4876, 0, 65535, 5000, 0, 65535, 5131, 0, 65535, 5256, 0, 65535, 5387, 0, 65535, 5512, 0, 65535, 5643, 0, 65535, 5774, 0, 65535, 5898, 0, 65535, 6029, 0, 65535, 6154, 0, 65535, 6285, 0, 65535, 6409, 0, 65535, 6540, 0, 65535, 6672, 0, 65535, 6796, 0, 65535, 6927, 0, 65535, 7052, 0, 65535, 7183, 0, 65535, 7307, 0, 65535, 7438, 0, 65535, 7569, 0, 65535, 7694, 0, 65535, 7825, 0, 65535, 7950, 0, 65535, 8081, 0, 65535, 8205, 0, 65535, 8336, 0, 65535, 8467, 0, 65535, 8592, 0, 65535, 8723, 0, 65535, 8847, 0, 65535, 8978, 0, 65535, 9103, 0, 65535, 9234, 0, 65535, 9365, 0, 65535, 9490, 0, 65535, 9621, 0, 65535, 9745, 0, 65535, 9876, 0, 65535, 10001, 0, 65535, 10132, 0, 65535, 10263, 0, 65535, 10387, 0, 65535, 10519, 0, 65535, 10643, 0, 65535, 10774, 0, 65535, 10899, 0, 65535, 11030, 0, 65535, 11161, 0, 65535, 11285, 0, 65535, 11416, 0, 65535, 11541, 0, 65535, 11672, 0, 65535, 11796, 0, 65535, 11928, 0, 65535, 12059, 0, 65535, 12183, 0, 65535, 12314, 0, 65535, 12439, 0, 65535, 12570, 0, 65535, 12694, 0, 65535, 12825, 0, 65535, 12956, 0, 65535, 13081, 0, 65535, 13212, 0, 65535, 13337, 0, 65535, 13468, 0, 65535, 13592, 0, 65535, 13723, 0, 65535, 13854, 0, 65535, 13979, 0, 65535, 14110, 0, 65535, 14234, 0, 65535, 14365, 0, 65535, 14490, 0, 65535, 14621, 0, 65535, 14746, 0, 65535, 14877, 0, 65535, 15008, 0, 65535, 15132, 0, 65535, 15263, 0, 65535, 15388, 0, 65535, 15519, 0, 65535, 15643, 0, 65535, 15775, 0, 65535, 15906, 0, 65535, 16030, 0, 65535, 16161, 0, 65535, 16286, 0, 65535, 16417, 0, 65535, 16541, 0, 65535, 16672, 0, 65535, 16803, 0, 65535, 16928, 0, 65535, 17059, 0, 65535, 17184, 0, 65535, 17315, 0, 65535, 17439, 0, 65535, 17570, 0, 65535, 17701, 0, 65535, 17826, 0, 65535, 17957, 0, 65535, 18081, 0, 65535, 18212, 0, 65535, 18337, 0, 65535, 18468, 0, 65535, 18599, 0, 65535, 18724, 0, 65535, 18855, 0, 65535, 18979, 0, 65535, 19110, 0, 65535, 19235, 0, 65535, 19366, 0, 65535, 19497, 0, 65535, 19621, 0, 65535, 19753, 0, 65535, 19877, 0, 65535, 20008, 0, 65535, 20133, 0, 65535, 20264, 0, 65535, 20395, 0, 65535, 20519, 0, 65535, 20650, 0, 65535, 20775, 0, 65535, 20906, 0, 65535, 21031, 0, 65535, 21162, 0, 65535, 21293, 0, 65535, 21417, 0, 65535, 21548, 0, 65535, 21673, 0, 65535, 21804, 0, 65535, 21928, 0, 65535, 22059, 0, 65535, 22190, 0, 65535, 22315, 0, 65535, 22446, 0, 65535, 22571, 0, 65535, 22702, 0, 65535, 22826, 0, 65535, 22957, 0, 65535, 23088, 0, 65535, 23213, 0, 65535, 23344, 0, 65535, 23468, 0, 65535, 23600, 0, 65535, 23724, 0, 65535, 23855, 0, 65535, 23980, 0, 65535, 24111, 0, 65535, 24242, 0, 65535, 24366, 0, 65535, 24497, 0, 65535, 24622, 0, 65535, 24753, 0, 65535, 24877, 0, 65535, 25009, 0, 65535, 25140, 0, 65535, 25264, 0, 65535, 25395, 0, 65535, 25520, 0, 65535, 25651, 0, 65535, 25775, 0, 65535, 25906, 0, 65535, 26037, 0, 65535, 26162, 0, 65535, 26293, 0, 65535, 26418, 0, 65535, 26549, 0, 65535, 26673, 0, 65535, 26804, 0, 65535, 26935, 0, 65535, 27060, 0, 65535, 27191, 0, 65535, 27315, 0, 65535, 27446, 0, 65535, 27571, 0, 65535, 27702, 0, 65535, 27833, 0, 65535, 27958, 0, 65535, 28089, 0, 65535, 28213, 0, 65535, 28344, 0, 65535, 28469, 0, 65535, 28600, 0, 65535, 28731, 0, 65535, 28856, 0, 65535, 28987, 0, 65535, 29111, 0, 65535, 29242, 0, 65535, 29367, 0, 65535, 29498, 0, 65535, 29629, 0, 65535, 29753, 0, 65535, 29884, 0, 65535, 30009, 0, 65535, 30140, 0, 65535, 30265, 0, 65535, 30396, 0, 65535, 30527, 0, 65535, 30651, 0, 65535, 30782, 0, 65535, 30907, 0, 65535, 31038, 0, 65535, 31162, 0, 65535, 31293, 0, 65535, 31425, 0, 65535, 31549, 0, 65535, 31680, 0, 65535, 31805, 0, 65535, 31936, 0, 65535, 32060, 0, 65535, 32191, 0, 65535, 32322, 0, 65535, 32447, 0, 65535, 32578, 0, 65535, 32702, 0, 65535, 32834, 0, 65535, 32958, 0, 65535, 33089, 0, 65535, 33214, 0, 65535, 33345, 0, 65535, 33476, 0, 65535, 33600, 0, 65535, 33731, 0, 65535, 33856, 0, 65535, 33987, 0, 65535, 34111, 0, 65535, 34243, 0, 65535, 34374, 0, 65535, 34498, 0, 65535, 34629, 0, 65535, 34754, 0, 65535, 34885, 0, 65535, 35009, 0, 65535, 35140, 0, 65535, 35271, 0, 65535, 35396, 0, 65535, 35527, 0, 65535, 35652, 0, 65535, 35783, 0, 65535, 35907, 0, 65535, 36038, 0, 65535, 36169, 0, 65535, 36294, 0, 65535, 36425, 0, 65535, 36549, 0, 65535, 36680, 0, 65535, 36805, 0, 65535, 36936, 0, 65535, 37067, 0, 65535, 37192, 0, 65535, 37323, 0, 65535, 37447, 0, 65535, 37578, 0, 65535, 37703, 0, 65535, 37834, 0, 65535, 37965, 0, 65535, 38090, 0, 65535, 38221, 0, 65535, 38345, 0, 65535, 38476, 0, 65535, 38601, 0, 65535, 38732, 0, 65535, 38863, 0, 65535, 38987, 0, 65535, 39118, 0, 65535, 39243, 0, 65535, 39374, 0, 65535, 39499, 0, 65535, 39630, 0, 65535, 39761, 0, 65535, 39885, 0, 65535, 40016, 0, 65535, 40141, 0, 65535, 40272, 0, 65535, 40396, 0, 65535, 40527, 0, 65535, 40659, 0, 65535, 40783, 0, 65535, 40914, 0, 65535, 41039, 0, 65535, 41170, 0, 65535, 41294, 0, 65535, 41425, 0, 65535, 41556, 0, 65535, 41681, 0, 65535, 41812, 0, 65535, 41936, 0, 65535, 42068, 0, 65535, 42192, 0, 65535, 42323, 0, 65535, 42448, 0, 65535, 42579, 0, 65535, 42710, 0, 65535, 42834, 0, 65535, 42965, 0, 65535, 43090, 0, 65535, 43221, 0, 65535, 43346, 0, 65535, 43477, 0, 65535, 43608, 0, 65535, 43732, 0, 65535, 43863, 0, 65535, 43988, 0, 65535, 44119, 0, 65535, 44243, 0, 65535, 44374, 0, 65535, 44505, 0, 65535, 44630, 0, 65535, 44761, 0, 65535, 44886, 0, 65535, 45017, 0, 65535, 45141, 0, 65535, 45272, 0, 65535, 45403, 0, 65535, 45528, 0, 65535, 45659, 0, 65535, 45783, 0, 65535, 45915, 0, 65535, 46039, 0, 65535, 46170, 0, 65535, 46301, 0, 65535, 46426, 0, 65535, 46557, 0, 65535, 46681, 0, 65535, 46812, 0, 65535, 46937, 0, 65535, 47068, 0, 65535, 47199, 0, 65535, 47324, 0, 65535, 47455, 0, 65535, 47579, 0, 65535, 47710, 0, 65535, 47835, 0, 65535, 47966, 0, 65535, 48097, 0, 65535, 48221, 0, 65535, 48352, 0, 65535, 48477, 0, 65535, 48608, 0, 65535, 48733, 0, 65535, 48864, 0, 65535, 48995, 0, 65535, 49119, 0, 65535, 49250, 0, 65535, 49375, 0, 65535, 49506, 0, 65535, 49630, 0, 65535, 49761, 0, 65535, 49893, 0, 65535, 50017, 0, 65535, 50148, 0, 65535, 50273, 0, 65535, 50404, 0, 65535, 50528, 0, 65535, 50659, 0, 65535, 50790, 0, 65535, 50915, 0, 65535, 51046, 0, 65535, 51171, 0, 65535, 51302, 0, 65535, 51426, 0, 65535, 51557, 0, 65535, 51682, 0, 65535, 51813, 0, 65535, 51944, 0, 65535, 52068, 0, 65535, 52199, 0, 65535, 52324, 0, 65535, 52455, 0, 65535, 52580, 0, 65535, 52711, 0, 65535, 52842, 0, 65535, 52966, 0, 65535, 53097, 0, 65535, 53222, 0, 65535, 53353, 0, 65535, 53477, 0, 65535, 53608, 0, 65535, 53740, 0, 65535, 53864, 0, 65535, 53995, 0, 65535, 54120, 0, 65535, 54251, 0, 65535, 54375, 0, 65535, 54506, 0, 65535, 54637, 0, 65535, 54762, 0, 65535, 54893, 0, 65535, 55017, 0, 65535, 55149, 0, 65535, 55273, 0, 65535, 55404, 0, 65535, 55535, 0, 65535, 55660, 0, 65535, 55791, 0, 65535, 55915, 0, 65535, 56046, 0, 65535, 56171, 0, 65535, 56302, 0, 65535, 56433, 0, 65535, 56558, 0, 65535, 56689, 0, 65535, 56813, 0, 65535, 56944, 0, 65535, 57069, 0, 65535, 57200, 0, 65535, 57331, 0, 65535, 57455, 0, 65535, 57586, 0, 65535, 57711, 0, 65535, 57842, 0, 65535, 57967, 0, 65535, 58098, 0, 65535, 58229, 0, 65535, 58353, 0, 65535, 58484, 0, 65535, 58609, 0, 65535, 58740, 0, 65535, 58864, 0, 65535, 58996, 0, 65535, 59127, 0, 65535, 59251, 0, 65535, 59382, 0, 65535, 59507, 0, 65535, 59638, 0, 65535, 59762, 0, 65535, 59893, 0, 65535, 60024, 0, 65535, 60149, 0, 65535, 60280, 0, 65535, 60405, 0, 65535, 60536, 0, 65535, 60660, 0, 65535, 60791, 0, 65535, 60916, 0, 65535, 61047, 0, 65535, 61178, 0, 65535, 61302, 0, 65535, 61433, 0, 65535, 61558, 0, 65535, 61689, 0, 65535, 61814, 0, 65535, 61945, 0, 65535, 62076, 0, 65535, 62200, 0, 65535, 62331, 0, 65535, 62456, 0, 65535, 62587, 0, 65535, 62711, 0, 65535, 62842, 0, 65535, 62974, 0, 65535, 63098, 0, 65535, 63229, 0, 65535, 63354, 0, 65535, 63485, 0, 65535, 63609, 0, 65535, 63740, 0, 65535, 63871, 0, 65535, 63996, 0, 65535, 64127, 0, 65535, 64251, 0, 65535, 64383, 0, 65535, 64507, 0, 65535, 64638, 0, 65535, 64769, 0, 65535, 64894, 0, 65535, 65025, 0, 65535, 65149, 0, 65535, 65280, 0, 65535, 65405, 0, 65535, 65535, 0};

static unsigned short winter_colormap[] = {0, 0, 65535, 0, 131, 65470, 0, 256, 65405, 0, 387, 65346, 0, 511, 65280, 0, 642, 65215, 0, 767, 65149, 0, 898, 65090, 0, 1029, 65025, 0, 1153, 64959, 0, 1285, 64894, 0, 1409, 64828, 0, 1540, 64769, 0, 1665, 64704, 0, 1796, 64638, 0, 1927, 64573, 0, 2051, 64507, 0, 2182, 64448, 0, 2307, 64383, 0, 2438, 64317, 0, 2562, 64251, 0, 2694, 64193, 0, 2825, 64127, 0, 2949, 64061, 0, 3080, 63996, 0, 3205, 63930, 0, 3336, 63871, 0, 3460, 63806, 0, 3591, 63740, 0, 3722, 63675, 0, 3847, 63609, 0, 3978, 63550, 0, 4103, 63485, 0, 4234, 63419, 0, 4358, 63354, 0, 4489, 63295, 0, 4620, 63229, 0, 4745, 63164, 0, 4876, 63098, 0, 5000, 63033, 0, 5131, 62974, 0, 5256, 62908, 0, 5387, 62842, 0, 5512, 62777, 0, 5643, 62711, 0, 5774, 62652, 0, 5898, 62587, 0, 6029, 62521, 0, 6154, 62456, 0, 6285, 62397, 0, 6409, 62331, 0, 6540, 62266, 0, 6672, 62200, 0, 6796, 62135, 0, 6927, 62076, 0, 7052, 62010, 0, 7183, 61945, 0, 7307, 61879, 0, 7438, 61814, 0, 7569, 61755, 0, 7694, 61689, 0, 7825, 61624, 0, 7950, 61558, 0, 8081, 61499, 0, 8205, 61433, 0, 8336, 61368, 0, 8467, 61302, 0, 8592, 61237, 0, 8723, 61178, 0, 8847, 61112, 0, 8978, 61047, 0, 9103, 60981, 0, 9234, 60916, 0, 9365, 60857, 0, 9490, 60791, 0, 9621, 60726, 0, 9745, 60660, 0, 9876, 60601, 0, 10001, 60536, 0, 10132, 60470, 0, 10263, 60405, 0, 10387, 60339, 0, 10519, 60280, 0, 10643, 60214, 0, 10774, 60149, 0, 10899, 60083, 0, 11030, 60024, 0, 11161, 59959, 0, 11285, 59893, 0, 11416, 59828, 0, 11541, 59762, 0, 11672, 59703, 0, 11796, 59638, 0, 11928, 59572, 0, 12059, 59507, 0, 12183, 59441, 0, 12314, 59382, 0, 12439, 59317, 0, 12570, 59251, 0, 12694, 59186, 0, 12825, 59127, 0, 12956, 59061, 0, 13081, 58996, 0, 13212, 58930, 0, 13337, 58864, 0, 13468, 58805, 0, 13592, 58740, 0, 13723, 58674, 0, 13854, 58609, 0, 13979, 58543, 0, 14110, 58484, 0, 14234, 58419, 0, 14365, 58353, 0, 14490, 58288, 0, 14621, 58229, 0, 14746, 58163, 0, 14877, 58098, 0, 15008, 58032, 0, 15132, 57967, 0, 15263, 57908, 0, 15388, 57842, 0, 15519, 57777, 0, 15643, 57711, 0, 15775, 57645, 0, 15906, 57586, 0, 16030, 57521, 0, 16161, 57455, 0, 16286, 57390, 0, 16417, 57331, 0, 16541, 57265, 0, 16672, 57200, 0, 16803, 57134, 0, 16928, 57069, 0, 17059, 57010, 0, 17184, 56944, 0, 17315, 56879, 0, 17439, 56813, 0, 17570, 56748, 0, 17701, 56689, 0, 17826, 56623, 0, 17957, 56558, 0, 18081, 56492, 0, 18212, 56433, 0, 18337, 56368, 0, 18468, 56302, 0, 18599, 56236, 0, 18724, 56171, 0, 18855, 56112, 0, 18979, 56046, 0, 19110, 55981, 0, 19235, 55915, 0, 19366, 55856, 0, 19497, 55791, 0, 19621, 55725, 0, 19753, 55660, 0, 19877, 55594, 0, 20008, 55535, 0, 20133, 55470, 0, 20264, 55404, 0, 20395, 55339, 0, 20519, 55273, 0, 20650, 55214, 0, 20775, 55149, 0, 20906, 55083, 0, 21031, 55017, 0, 21162, 54958, 0, 21293, 54893, 0, 21417, 54827, 0, 21548, 54762, 0, 21673, 54696, 0, 21804, 54637, 0, 21928, 54572, 0, 22059, 54506, 0, 22190, 54441, 0, 22315, 54375, 0, 22446, 54316, 0, 22571, 54251, 0, 22702, 54185, 0, 22826, 54120, 0, 22957, 54061, 0, 23088, 53995, 0, 23213, 53930, 0, 23344, 53864, 0, 23468, 53799, 0, 23600, 53740, 0, 23724, 53674, 0, 23855, 53608, 0, 23980, 53543, 0, 24111, 53477, 0, 24242, 53418, 0, 24366, 53353, 0, 24497, 53287, 0, 24622, 53222, 0, 24753, 53163, 0, 24877, 53097, 0, 25009, 53032, 0, 25140, 52966, 0, 25264, 52901, 0, 25395, 52842, 0, 25520, 52776, 0, 25651, 52711, 0, 25775, 52645, 0, 25906, 52580, 0, 26037, 52521, 0, 26162, 52455, 0, 26293, 52389, 0, 26418, 52324, 0, 26549, 52265, 0, 26673, 52199, 0, 26804, 52134, 0, 26935, 52068, 0, 27060, 52003, 0, 27191, 51944, 0, 27315, 51878, 0, 27446, 51813, 0, 27571, 51747, 0, 27702, 51682, 0, 27833, 51623, 0, 27958, 51557, 0, 28089, 51492, 0, 28213, 51426, 0, 28344, 51367, 0, 28469, 51302, 0, 28600, 51236, 0, 28731, 51171, 0, 28856, 51105, 0, 28987, 51046, 0, 29111, 50980, 0, 29242, 50915, 0, 29367, 50849, 0, 29498, 50790, 0, 29629, 50725, 0, 29753, 50659, 0, 29884, 50594, 0, 30009, 50528, 0, 30140, 50469, 0, 30265, 50404, 0, 30396, 50338, 0, 30527, 50273, 0, 30651, 50207, 0, 30782, 50148, 0, 30907, 50083, 0, 31038, 50017, 0, 31162, 49952, 0, 31293, 49893, 0, 31425, 49827, 0, 31549, 49761, 0, 31680, 49696, 0, 31805, 49630, 0, 31936, 49571, 0, 32060, 49506, 0, 32191, 49440, 0, 32322, 49375, 0, 32447, 49309, 0, 32578, 49250, 0, 32702, 49185, 0, 32834, 49119, 0, 32958, 49054, 0, 33089, 48995, 0, 33214, 48929, 0, 33345, 48864, 0, 33476, 48798, 0, 33600, 48733, 0, 33731, 48674, 0, 33856, 48608, 0, 33987, 48543, 0, 34111, 48477, 0, 34243, 48411, 0, 34374, 48352, 0, 34498, 48287, 0, 34629, 48221, 0, 34754, 48156, 0, 34885, 48097, 0, 35009, 48031, 0, 35140, 47966, 0, 35271, 47900, 0, 35396, 47835, 0, 35527, 47776, 0, 35652, 47710, 0, 35783, 47645, 0, 35907, 47579, 0, 36038, 47514, 0, 36169, 47455, 0, 36294, 47389, 0, 36425, 47324, 0, 36549, 47258, 0, 36680, 47199, 0, 36805, 47133, 0, 36936, 47068, 0, 37067, 47002, 0, 37192, 46937, 0, 37323, 46878, 0, 37447, 46812, 0, 37578, 46747, 0, 37703, 46681, 0, 37834, 46622, 0, 37965, 46557, 0, 38090, 46491, 0, 38221, 46426, 0, 38345, 46360, 0, 38476, 46301, 0, 38601, 46236, 0, 38732, 46170, 0, 38863, 46105, 0, 38987, 46039, 0, 39118, 45980, 0, 39243, 45915, 0, 39374, 45849, 0, 39499, 45783, 0, 39630, 45724, 0, 39761, 45659, 0, 39885, 45593, 0, 40016, 45528, 0, 40141, 45462, 0, 40272, 45403, 0, 40396, 45338, 0, 40527, 45272, 0, 40659, 45207, 0, 40783, 45141, 0, 40914, 45082, 0, 41039, 45017, 0, 41170, 44951, 0, 41294, 44886, 0, 41425, 44827, 0, 41556, 44761, 0, 41681, 44696, 0, 41812, 44630, 0, 41936, 44564, 0, 42068, 44505, 0, 42192, 44440, 0, 42323, 44374, 0, 42448, 44309, 0, 42579, 44243, 0, 42710, 44184, 0, 42834, 44119, 0, 42965, 44053, 0, 43090, 43988, 0, 43221, 43929, 0, 43346, 43863, 0, 43477, 43798, 0, 43608, 43732, 0, 43732, 43667, 0, 43863, 43608, 0, 43988, 43542, 0, 44119, 43477, 0, 44243, 43411, 0, 44374, 43346, 0, 44505, 43287, 0, 44630, 43221, 0, 44761, 43155, 0, 44886, 43090, 0, 45017, 43031, 0, 45141, 42965, 0, 45272, 42900, 0, 45403, 42834, 0, 45528, 42769, 0, 45659, 42710, 0, 45783, 42644, 0, 45915, 42579, 0, 46039, 42513, 0, 46170, 42448, 0, 46301, 42389, 0, 46426, 42323, 0, 46557, 42258, 0, 46681, 42192, 0, 46812, 42133, 0, 46937, 42068, 0, 47068, 42002, 0, 47199, 41936, 0, 47324, 41871, 0, 47455, 41812, 0, 47579, 41746, 0, 47710, 41681, 0, 47835, 41615, 0, 47966, 41556, 0, 48097, 41491, 0, 48221, 41425, 0, 48352, 41360, 0, 48477, 41294, 0, 48608, 41235, 0, 48733, 41170, 0, 48864, 41104, 0, 48995, 41039, 0, 49119, 40973, 0, 49250, 40914, 0, 49375, 40849, 0, 49506, 40783, 0, 49630, 40718, 0, 49761, 40659, 0, 49893, 40593, 0, 50017, 40527, 0, 50148, 40462, 0, 50273, 40396, 0, 50404, 40337, 0, 50528, 40272, 0, 50659, 40206, 0, 50790, 40141, 0, 50915, 40075, 0, 51046, 40016, 0, 51171, 39951, 0, 51302, 39885, 0, 51426, 39820, 0, 51557, 39761, 0, 51682, 39695, 0, 51813, 39630, 0, 51944, 39564, 0, 52068, 39499, 0, 52199, 39440, 0, 52324, 39374, 0, 52455, 39308, 0, 52580, 39243, 0, 52711, 39177, 0, 52842, 39118, 0, 52966, 39053, 0, 53097, 38987, 0, 53222, 38922, 0, 53353, 38863, 0, 53477, 38797, 0, 53608, 38732, 0, 53740, 38666, 0, 53864, 38601, 0, 53995, 38542, 0, 54120, 38476, 0, 54251, 38411, 0, 54375, 38345, 0, 54506, 38280, 0, 54637, 38221, 0, 54762, 38155, 0, 54893, 38090, 0, 55017, 38024, 0, 55149, 37965, 0, 55273, 37899, 0, 55404, 37834, 0, 55535, 37768, 0, 55660, 37703, 0, 55791, 37644, 0, 55915, 37578, 0, 56046, 37513, 0, 56171, 37447, 0, 56302, 37388, 0, 56433, 37323, 0, 56558, 37257, 0, 56689, 37192, 0, 56813, 37126, 0, 56944, 37067, 0, 57069, 37002, 0, 57200, 36936, 0, 57331, 36871, 0, 57455, 36805, 0, 57586, 36746, 0, 57711, 36680, 0, 57842, 36615, 0, 57967, 36549, 0, 58098, 36490, 0, 58229, 36425, 0, 58353, 36359, 0, 58484, 36294, 0, 58609, 36228, 0, 58740, 36169, 0, 58864, 36104, 0, 58996, 36038, 0, 59127, 35973, 0, 59251, 35907, 0, 59382, 35848, 0, 59507, 35783, 0, 59638, 35717, 0, 59762, 35652, 0, 59893, 35593, 0, 60024, 35527, 0, 60149, 35462, 0, 60280, 35396, 0, 60405, 35330, 0, 60536, 35271, 0, 60660, 35206, 0, 60791, 35140, 0, 60916, 35075, 0, 61047, 35009, 0, 61178, 34950, 0, 61302, 34885, 0, 61433, 34819, 0, 61558, 34754, 0, 61689, 34695, 0, 61814, 34629, 0, 61945, 34564, 0, 62076, 34498, 0, 62200, 34433, 0, 62331, 34374, 0, 62456, 34308, 0, 62587, 34243, 0, 62711, 34177, 0, 62842, 34111, 0, 62974, 34053, 0, 63098, 33987, 0, 63229, 33921, 0, 63354, 33856, 0, 63485, 33797, 0, 63609, 33731, 0, 63740, 33666, 0, 63871, 33600, 0, 63996, 33535, 0, 64127, 33476, 0, 64251, 33410, 0, 64383, 33345, 0, 64507, 33279, 0, 64638, 33214, 0, 64769, 33155, 0, 64894, 33089, 0, 65025, 33024, 0, 65149, 32958, 0, 65280, 32899, 0, 65405, 32834, 0, 65535, 32768};

static unsigned short spring_colormap[] = {65535, 0, 65535, 65535, 131, 65405, 65535, 256, 65280, 65535, 387, 65149, 65535, 511, 65025, 65535, 642, 64894, 65535, 767, 64769, 65535, 898, 64638, 65535, 1029, 64507, 65535, 1153, 64383, 65535, 1285, 64251, 65535, 1409, 64127, 65535, 1540, 63996, 65535, 1665, 63871, 65535, 1796, 63740, 65535, 1927, 63609, 65535, 2051, 63485, 65535, 2182, 63354, 65535, 2307, 63229, 65535, 2438, 63098, 65535, 2562, 62974, 65535, 2694, 62842, 65535, 2825, 62711, 65535, 2949, 62587, 65535, 3080, 62456, 65535, 3205, 62331, 65535, 3336, 62200, 65535, 3460, 62076, 65535, 3591, 61945, 65535, 3722, 61814, 65535, 3847, 61689, 65535, 3978, 61558, 65535, 4103, 61433, 65535, 4234, 61302, 65535, 4358, 61178, 65535, 4489, 61047, 65535, 4620, 60916, 65535, 4745, 60791, 65535, 4876, 60660, 65535, 5000, 60536, 65535, 5131, 60405, 65535, 5256, 60280, 65535, 5387, 60149, 65535, 5512, 60024, 65535, 5643, 59893, 65535, 5774, 59762, 65535, 5898, 59638, 65535, 6029, 59507, 65535, 6154, 59382, 65535, 6285, 59251, 65535, 6409, 59127, 65535, 6540, 58996, 65535, 6672, 58864, 65535, 6796, 58740, 65535, 6927, 58609, 65535, 7052, 58484, 65535, 7183, 58353, 65535, 7307, 58229, 65535, 7438, 58098, 65535, 7569, 57967, 65535, 7694, 57842, 65535, 7825, 57711, 65535, 7950, 57586, 65535, 8081, 57455, 65535, 8205, 57331, 65535, 8336, 57200, 65535, 8467, 57069, 65535, 8592, 56944, 65535, 8723, 56813, 65535, 8847, 56689, 65535, 8978, 56558, 65535, 9103, 56433, 65535, 9234, 56302, 65535, 9365, 56171, 65535, 9490, 56046, 65535, 9621, 55915, 65535, 9745, 55791, 65535, 9876, 55660, 65535, 10001, 55535, 65535, 10132, 55404, 65535, 10263, 55273, 65535, 10387, 55149, 65535, 10519, 55017, 65535, 10643, 54893, 65535, 10774, 54762, 65535, 10899, 54637, 65535, 11030, 54506, 65535, 11161, 54375, 65535, 11285, 54251, 65535, 11416, 54120, 65535, 11541, 53995, 65535, 11672, 53864, 65535, 11796, 53740, 65535, 11928, 53608, 65535, 12059, 53477, 65535, 12183, 53353, 65535, 12314, 53222, 65535, 12439, 53097, 65535, 12570, 52966, 65535, 12694, 52842, 65535, 12825, 52711, 65535, 12956, 52580, 65535, 13081, 52455, 65535, 13212, 52324, 65535, 13337, 52199, 65535, 13468, 52068, 65535, 13592, 51944, 65535, 13723, 51813, 65535, 13854, 51682, 65535, 13979, 51557, 65535, 14110, 51426, 65535, 14234, 51302, 65535, 14365, 51171, 65535, 14490, 51046, 65535, 14621, 50915, 65535, 14746, 50790, 65535, 14877, 50659, 65535, 15008, 50528, 65535, 15132, 50404, 65535, 15263, 50273, 65535, 15388, 50148, 65535, 15519, 50017, 65535, 15643, 49893, 65535, 15775, 49761, 65535, 15906, 49630, 65535, 16030, 49506, 65535, 16161, 49375, 65535, 16286, 49250, 65535, 16417, 49119, 65535, 16541, 48995, 65535, 16672, 48864, 65535, 16803, 48733, 65535, 16928, 48608, 65535, 17059, 48477, 65535, 17184, 48352, 65535, 17315, 48221, 65535, 17439, 48097, 65535, 17570, 47966, 65535, 17701, 47835, 65535, 17826, 47710, 65535, 17957, 47579, 65535, 18081, 47455, 65535, 18212, 47324, 65535, 18337, 47199, 65535, 18468, 47068, 65535, 18599, 46937, 65535, 18724, 46812, 65535, 18855, 46681, 65535, 18979, 46557, 65535, 19110, 46426, 65535, 19235, 46301, 65535, 19366, 46170, 65535, 19497, 46039, 65535, 19621, 45915, 65535, 19753, 45783, 65535, 19877, 45659, 65535, 20008, 45528, 65535, 20133, 45403, 65535, 20264, 45272, 65535, 20395, 45141, 65535, 20519, 45017, 65535, 20650, 44886, 65535, 20775, 44761, 65535, 20906, 44630, 65535, 21031, 44505, 65535, 21162, 44374, 65535, 21293, 44243, 65535, 21417, 44119, 65535, 21548, 43988, 65535, 21673, 43863, 65535, 21804, 43732, 65535, 21928, 43608, 65535, 22059, 43477, 65535, 22190, 43346, 65535, 22315, 43221, 65535, 22446, 43090, 65535, 22571, 42965, 65535, 22702, 42834, 65535, 22826, 42710, 65535, 22957, 42579, 65535, 23088, 42448, 65535, 23213, 42323, 65535, 23344, 42192, 65535, 23468, 42068, 65535, 23600, 41936, 65535, 23724, 41812, 65535, 23855, 41681, 65535, 23980, 41556, 65535, 24111, 41425, 65535, 24242, 41294, 65535, 24366, 41170, 65535, 24497, 41039, 65535, 24622, 40914, 65535, 24753, 40783, 65535, 24877, 40659, 65535, 25009, 40527, 65535, 25140, 40396, 65535, 25264, 40272, 65535, 25395, 40141, 65535, 25520, 40016, 65535, 25651, 39885, 65535, 25775, 39761, 65535, 25906, 39630, 65535, 26037, 39499, 65535, 26162, 39374, 65535, 26293, 39243, 65535, 26418, 39118, 65535, 26549, 38987, 65535, 26673, 38863, 65535, 26804, 38732, 65535, 26935, 38601, 65535, 27060, 38476, 65535, 27191, 38345, 65535, 27315, 38221, 65535, 27446, 38090, 65535, 27571, 37965, 65535, 27702, 37834, 65535, 27833, 37703, 65535, 27958, 37578, 65535, 28089, 37447, 65535, 28213, 37323, 65535, 28344, 37192, 65535, 28469, 37067, 65535, 28600, 36936, 65535, 28731, 36805, 65535, 28856, 36680, 65535, 28987, 36549, 65535, 29111, 36425, 65535, 29242, 36294, 65535, 29367, 36169, 65535, 29498, 36038, 65535, 29629, 35907, 65535, 29753, 35783, 65535, 29884, 35652, 65535, 30009, 35527, 65535, 30140, 35396, 65535, 30265, 35271, 65535, 30396, 35140, 65535, 30527, 35009, 65535, 30651, 34885, 65535, 30782, 34754, 65535, 30907, 34629, 65535, 31038, 34498, 65535, 31162, 34374, 65535, 31293, 34243, 65535, 31425, 34111, 65535, 31549, 33987, 65535, 31680, 33856, 65535, 31805, 33731, 65535, 31936, 33600, 65535, 32060, 33476, 65535, 32191, 33345, 65535, 32322, 33214, 65535, 32447, 33089, 65535, 32578, 32958, 65535, 32702, 32834, 65535, 32834, 32702, 65535, 32958, 32578, 65535, 33089, 32447, 65535, 33214, 32322, 65535, 33345, 32191, 65535, 33476, 32060, 65535, 33600, 31936, 65535, 33731, 31805, 65535, 33856, 31680, 65535, 33987, 31549, 65535, 34111, 31425, 65535, 34243, 31293, 65535, 34374, 31162, 65535, 34498, 31038, 65535, 34629, 30907, 65535, 34754, 30782, 65535, 34885, 30651, 65535, 35009, 30527, 65535, 35140, 30396, 65535, 35271, 30265, 65535, 35396, 30140, 65535, 35527, 30009, 65535, 35652, 29884, 65535, 35783, 29753, 65535, 35907, 29629, 65535, 36038, 29498, 65535, 36169, 29367, 65535, 36294, 29242, 65535, 36425, 29111, 65535, 36549, 28987, 65535, 36680, 28856, 65535, 36805, 28731, 65535, 36936, 28600, 65535, 37067, 28469, 65535, 37192, 28344, 65535, 37323, 28213, 65535, 37447, 28089, 65535, 37578, 27958, 65535, 37703, 27833, 65535, 37834, 27702, 65535, 37965, 27571, 65535, 38090, 27446, 65535, 38221, 27315, 65535, 38345, 27191, 65535, 38476, 27060, 65535, 38601, 26935, 65535, 38732, 26804, 65535, 38863, 26673, 65535, 38987, 26549, 65535, 39118, 26418, 65535, 39243, 26293, 65535, 39374, 26162, 65535, 39499, 26037, 65535, 39630, 25906, 65535, 39761, 25775, 65535, 39885, 25651, 65535, 40016, 25520, 65535, 40141, 25395, 65535, 40272, 25264, 65535, 40396, 25140, 65535, 40527, 25009, 65535, 40659, 24877, 65535, 40783, 24753, 65535, 40914, 24622, 65535, 41039, 24497, 65535, 41170, 24366, 65535, 41294, 24242, 65535, 41425, 24111, 65535, 41556, 23980, 65535, 41681, 23855, 65535, 41812, 23724, 65535, 41936, 23600, 65535, 42068, 23468, 65535, 42192, 23344, 65535, 42323, 23213, 65535, 42448, 23088, 65535, 42579, 22957, 65535, 42710, 22826, 65535, 42834, 22702, 65535, 42965, 22571, 65535, 43090, 22446, 65535, 43221, 22315, 65535, 43346, 22190, 65535, 43477, 22059, 65535, 43608, 21928, 65535, 43732, 21804, 65535, 43863, 21673, 65535, 43988, 21548, 65535, 44119, 21417, 65535, 44243, 21293, 65535, 44374, 21162, 65535, 44505, 21031, 65535, 44630, 20906, 65535, 44761, 20775, 65535, 44886, 20650, 65535, 45017, 20519, 65535, 45141, 20395, 65535, 45272, 20264, 65535, 45403, 20133, 65535, 45528, 20008, 65535, 45659, 19877, 65535, 45783, 19753, 65535, 45915, 19621, 65535, 46039, 19497, 65535, 46170, 19366, 65535, 46301, 19235, 65535, 46426, 19110, 65535, 46557, 18979, 65535, 46681, 18855, 65535, 46812, 18724, 65535, 46937, 18599, 65535, 47068, 18468, 65535, 47199, 18337, 65535, 47324, 18212, 65535, 47455, 18081, 65535, 47579, 17957, 65535, 47710, 17826, 65535, 47835, 17701, 65535, 47966, 17570, 65535, 48097, 17439, 65535, 48221, 17315, 65535, 48352, 17184, 65535, 48477, 17059, 65535, 48608, 16928, 65535, 48733, 16803, 65535, 48864, 16672, 65535, 48995, 16541, 65535, 49119, 16417, 65535, 49250, 16286, 65535, 49375, 16161, 65535, 49506, 16030, 65535, 49630, 15906, 65535, 49761, 15775, 65535, 49893, 15643, 65535, 50017, 15519, 65535, 50148, 15388, 65535, 50273, 15263, 65535, 50404, 15132, 65535, 50528, 15008, 65535, 50659, 14877, 65535, 50790, 14746, 65535, 50915, 14621, 65535, 51046, 14490, 65535, 51171, 14365, 65535, 51302, 14234, 65535, 51426, 14110, 65535, 51557, 13979, 65535, 51682, 13854, 65535, 51813, 13723, 65535, 51944, 13592, 65535, 52068, 13468, 65535, 52199, 13337, 65535, 52324, 13212, 65535, 52455, 13081, 65535, 52580, 12956, 65535, 52711, 12825, 65535, 52842, 12694, 65535, 52966, 12570, 65535, 53097, 12439, 65535, 53222, 12314, 65535, 53353, 12183, 65535, 53477, 12059, 65535, 53608, 11928, 65535, 53740, 11796, 65535, 53864, 11672, 65535, 53995, 11541, 65535, 54120, 11416, 65535, 54251, 11285, 65535, 54375, 11161, 65535, 54506, 11030, 65535, 54637, 10899, 65535, 54762, 10774, 65535, 54893, 10643, 65535, 55017, 10519, 65535, 55149, 10387, 65535, 55273, 10263, 65535, 55404, 10132, 65535, 55535, 10001, 65535, 55660, 9876, 65535, 55791, 9745, 65535, 55915, 9621, 65535, 56046, 9490, 65535, 56171, 9365, 65535, 56302, 9234, 65535, 56433, 9103, 65535, 56558, 8978, 65535, 56689, 8847, 65535, 56813, 8723, 65535, 56944, 8592, 65535, 57069, 8467, 65535, 57200, 8336, 65535, 57331, 8205, 65535, 57455, 8081, 65535, 57586, 7950, 65535, 57711, 7825, 65535, 57842, 7694, 65535, 57967, 7569, 65535, 58098, 7438, 65535, 58229, 7307, 65535, 58353, 7183, 65535, 58484, 7052, 65535, 58609, 6927, 65535, 58740, 6796, 65535, 58864, 6672, 65535, 58996, 6540, 65535, 59127, 6409, 65535, 59251, 6285, 65535, 59382, 6154, 65535, 59507, 6029, 65535, 59638, 5898, 65535, 59762, 5774, 65535, 59893, 5643, 65535, 60024, 5512, 65535, 60149, 5387, 65535, 60280, 5256, 65535, 60405, 5131, 65535, 60536, 5000, 65535, 60660, 4876, 65535, 60791, 4745, 65535, 60916, 4620, 65535, 61047, 4489, 65535, 61178, 4358, 65535, 61302, 4234, 65535, 61433, 4103, 65535, 61558, 3978, 65535, 61689, 3847, 65535, 61814, 3722, 65535, 61945, 3591, 65535, 62076, 3460, 65535, 62200, 3336, 65535, 62331, 3205, 65535, 62456, 3080, 65535, 62587, 2949, 65535, 62711, 2825, 65535, 62842, 2694, 65535, 62974, 2562, 65535, 63098, 2438, 65535, 63229, 2307, 65535, 63354, 2182, 65535, 63485, 2051, 65535, 63609, 1927, 65535, 63740, 1796, 65535, 63871, 1665, 65535, 63996, 1540, 65535, 64127, 1409, 65535, 64251, 1285, 65535, 64383, 1153, 65535, 64507, 1029, 65535, 64638, 898, 65535, 64769, 767, 65535, 64894, 642, 65535, 65025, 511, 65535, 65149, 387, 65535, 65280, 256, 65535, 65405, 131, 65535, 65535, 0};

static unsigned short summer_colormap[] = {0, 32768, 26214, 131, 32834, 26214, 256, 32899, 26214, 387, 32958, 26214, 511, 33024, 26214, 642, 33089, 26214, 767, 33155, 26214, 898, 33214, 26214, 1029, 33279, 26214, 1153, 33345, 26214, 1285, 33410, 26214, 1409, 33476, 26214, 1540, 33535, 26214, 1665, 33600, 26214, 1796, 33666, 26214, 1927, 33731, 26214, 2051, 33797, 26214, 2182, 33856, 26214, 2307, 33921, 26214, 2438, 33987, 26214, 2562, 34053, 26214, 2694, 34111, 26214, 2825, 34177, 26214, 2949, 34243, 26214, 3080, 34308, 26214, 3205, 34374, 26214, 3336, 34433, 26214, 3460, 34498, 26214, 3591, 34564, 26214, 3722, 34629, 26214, 3847, 34695, 26214, 3978, 34754, 26214, 4103, 34819, 26214, 4234, 34885, 26214, 4358, 34950, 26214, 4489, 35009, 26214, 4620, 35075, 26214, 4745, 35140, 26214, 4876, 35206, 26214, 5000, 35271, 26214, 5131, 35330, 26214, 5256, 35396, 26214, 5387, 35462, 26214, 5512, 35527, 26214, 5643, 35593, 26214, 5774, 35652, 26214, 5898, 35717, 26214, 6029, 35783, 26214, 6154, 35848, 26214, 6285, 35907, 26214, 6409, 35973, 26214, 6540, 36038, 26214, 6672, 36104, 26214, 6796, 36169, 26214, 6927, 36228, 26214, 7052, 36294, 26214, 7183, 36359, 26214, 7307, 36425, 26214, 7438, 36490, 26214, 7569, 36549, 26214, 7694, 36615, 26214, 7825, 36680, 26214, 7950, 36746, 26214, 8081, 36805, 26214, 8205, 36871, 26214, 8336, 36936, 26214, 8467, 37002, 26214, 8592, 37067, 26214, 8723, 37126, 26214, 8847, 37192, 26214, 8978, 37257, 26214, 9103, 37323, 26214, 9234, 37388, 26214, 9365, 37447, 26214, 9490, 37513, 26214, 9621, 37578, 26214, 9745, 37644, 26214, 9876, 37703, 26214, 10001, 37768, 26214, 10132, 37834, 26214, 10263, 37899, 26214, 10387, 37965, 26214, 10519, 38024, 26214, 10643, 38090, 26214, 10774, 38155, 26214, 10899, 38221, 26214, 11030, 38280, 26214, 11161, 38345, 26214, 11285, 38411, 26214, 11416, 38476, 26214, 11541, 38542, 26214, 11672, 38601, 26214, 11796, 38666, 26214, 11928, 38732, 26214, 12059, 38797, 26214, 12183, 38863, 26214, 12314, 38922, 26214, 12439, 38987, 26214, 12570, 39053, 26214, 12694, 39118, 26214, 12825, 39177, 26214, 12956, 39243, 26214, 13081, 39308, 26214, 13212, 39374, 26214, 13337, 39440, 26214, 13468, 39499, 26214, 13592, 39564, 26214, 13723, 39630, 26214, 13854, 39695, 26214, 13979, 39761, 26214, 14110, 39820, 26214, 14234, 39885, 26214, 14365, 39951, 26214, 14490, 40016, 26214, 14621, 40075, 26214, 14746, 40141, 26214, 14877, 40206, 26214, 15008, 40272, 26214, 15132, 40337, 26214, 15263, 40396, 26214, 15388, 40462, 26214, 15519, 40527, 26214, 15643, 40593, 26214, 15775, 40659, 26214, 15906, 40718, 26214, 16030, 40783, 26214, 16161, 40849, 26214, 16286, 40914, 26214, 16417, 40973, 26214, 16541, 41039, 26214, 16672, 41104, 26214, 16803, 41170, 26214, 16928, 41235, 26214, 17059, 41294, 26214, 17184, 41360, 26214, 17315, 41425, 26214, 17439, 41491, 26214, 17570, 41556, 26214, 17701, 41615, 26214, 17826, 41681, 26214, 17957, 41746, 26214, 18081, 41812, 26214, 18212, 41871, 26214, 18337, 41936, 26214, 18468, 42002, 26214, 18599, 42068, 26214, 18724, 42133, 26214, 18855, 42192, 26214, 18979, 42258, 26214, 19110, 42323, 26214, 19235, 42389, 26214, 19366, 42448, 26214, 19497, 42513, 26214, 19621, 42579, 26214, 19753, 42644, 26214, 19877, 42710, 26214, 20008, 42769, 26214, 20133, 42834, 26214, 20264, 42900, 26214, 20395, 42965, 26214, 20519, 43031, 26214, 20650, 43090, 26214, 20775, 43155, 26214, 20906, 43221, 26214, 21031, 43287, 26214, 21162, 43346, 26214, 21293, 43411, 26214, 21417, 43477, 26214, 21548, 43542, 26214, 21673, 43608, 26214, 21804, 43667, 26214, 21928, 43732, 26214, 22059, 43798, 26214, 22190, 43863, 26214, 22315, 43929, 26214, 22446, 43988, 26214, 22571, 44053, 26214, 22702, 44119, 26214, 22826, 44184, 26214, 22957, 44243, 26214, 23088, 44309, 26214, 23213, 44374, 26214, 23344, 44440, 26214, 23468, 44505, 26214, 23600, 44564, 26214, 23724, 44630, 26214, 23855, 44696, 26214, 23980, 44761, 26214, 24111, 44827, 26214, 24242, 44886, 26214, 24366, 44951, 26214, 24497, 45017, 26214, 24622, 45082, 26214, 24753, 45141, 26214, 24877, 45207, 26214, 25009, 45272, 26214, 25140, 45338, 26214, 25264, 45403, 26214, 25395, 45462, 26214, 25520, 45528, 26214, 25651, 45593, 26214, 25775, 45659, 26214, 25906, 45724, 26214, 26037, 45783, 26214, 26162, 45849, 26214, 26293, 45915, 26214, 26418, 45980, 26214, 26549, 46039, 26214, 26673, 46105, 26214, 26804, 46170, 26214, 26935, 46236, 26214, 27060, 46301, 26214, 27191, 46360, 26214, 27315, 46426, 26214, 27446, 46491, 26214, 27571, 46557, 26214, 27702, 46622, 26214, 27833, 46681, 26214, 27958, 46747, 26214, 28089, 46812, 26214, 28213, 46878, 26214, 28344, 46937, 26214, 28469, 47002, 26214, 28600, 47068, 26214, 28731, 47133, 26214, 28856, 47199, 26214, 28987, 47258, 26214, 29111, 47324, 26214, 29242, 47389, 26214, 29367, 47455, 26214, 29498, 47514, 26214, 29629, 47579, 26214, 29753, 47645, 26214, 29884, 47710, 26214, 30009, 47776, 26214, 30140, 47835, 26214, 30265, 47900, 26214, 30396, 47966, 26214, 30527, 48031, 26214, 30651, 48097, 26214, 30782, 48156, 26214, 30907, 48221, 26214, 31038, 48287, 26214, 31162, 48352, 26214, 31293, 48411, 26214, 31425, 48477, 26214, 31549, 48543, 26214, 31680, 48608, 26214, 31805, 48674, 26214, 31936, 48733, 26214, 32060, 48798, 26214, 32191, 48864, 26214, 32322, 48929, 26214, 32447, 48995, 26214, 32578, 49054, 26214, 32702, 49119, 26214, 32834, 49185, 26214, 32958, 49250, 26214, 33089, 49309, 26214, 33214, 49375, 26214, 33345, 49440, 26214, 33476, 49506, 26214, 33600, 49571, 26214, 33731, 49630, 26214, 33856, 49696, 26214, 33987, 49761, 26214, 34111, 49827, 26214, 34243, 49893, 26214, 34374, 49952, 26214, 34498, 50017, 26214, 34629, 50083, 26214, 34754, 50148, 26214, 34885, 50207, 26214, 35009, 50273, 26214, 35140, 50338, 26214, 35271, 50404, 26214, 35396, 50469, 26214, 35527, 50528, 26214, 35652, 50594, 26214, 35783, 50659, 26214, 35907, 50725, 26214, 36038, 50790, 26214, 36169, 50849, 26214, 36294, 50915, 26214, 36425, 50980, 26214, 36549, 51046, 26214, 36680, 51105, 26214, 36805, 51171, 26214, 36936, 51236, 26214, 37067, 51302, 26214, 37192, 51367, 26214, 37323, 51426, 26214, 37447, 51492, 26214, 37578, 51557, 26214, 37703, 51623, 26214, 37834, 51682, 26214, 37965, 51747, 26214, 38090, 51813, 26214, 38221, 51878, 26214, 38345, 51944, 26214, 38476, 52003, 26214, 38601, 52068, 26214, 38732, 52134, 26214, 38863, 52199, 26214, 38987, 52265, 26214, 39118, 52324, 26214, 39243, 52389, 26214, 39374, 52455, 26214, 39499, 52521, 26214, 39630, 52580, 26214, 39761, 52645, 26214, 39885, 52711, 26214, 40016, 52776, 26214, 40141, 52842, 26214, 40272, 52901, 26214, 40396, 52966, 26214, 40527, 53032, 26214, 40659, 53097, 26214, 40783, 53163, 26214, 40914, 53222, 26214, 41039, 53287, 26214, 41170, 53353, 26214, 41294, 53418, 26214, 41425, 53477, 26214, 41556, 53543, 26214, 41681, 53608, 26214, 41812, 53674, 26214, 41936, 53740, 26214, 42068, 53799, 26214, 42192, 53864, 26214, 42323, 53930, 26214, 42448, 53995, 26214, 42579, 54061, 26214, 42710, 54120, 26214, 42834, 54185, 26214, 42965, 54251, 26214, 43090, 54316, 26214, 43221, 54375, 26214, 43346, 54441, 26214, 43477, 54506, 26214, 43608, 54572, 26214, 43732, 54637, 26214, 43863, 54696, 26214, 43988, 54762, 26214, 44119, 54827, 26214, 44243, 54893, 26214, 44374, 54958, 26214, 44505, 55017, 26214, 44630, 55083, 26214, 44761, 55149, 26214, 44886, 55214, 26214, 45017, 55273, 26214, 45141, 55339, 26214, 45272, 55404, 26214, 45403, 55470, 26214, 45528, 55535, 26214, 45659, 55594, 26214, 45783, 55660, 26214, 45915, 55725, 26214, 46039, 55791, 26214, 46170, 55856, 26214, 46301, 55915, 26214, 46426, 55981, 26214, 46557, 56046, 26214, 46681, 56112, 26214, 46812, 56171, 26214, 46937, 56236, 26214, 47068, 56302, 26214, 47199, 56368, 26214, 47324, 56433, 26214, 47455, 56492, 26214, 47579, 56558, 26214, 47710, 56623, 26214, 47835, 56689, 26214, 47966, 56748, 26214, 48097, 56813, 26214, 48221, 56879, 26214, 48352, 56944, 26214, 48477, 57010, 26214, 48608, 57069, 26214, 48733, 57134, 26214, 48864, 57200, 26214, 48995, 57265, 26214, 49119, 57331, 26214, 49250, 57390, 26214, 49375, 57455, 26214, 49506, 57521, 26214, 49630, 57586, 26214, 49761, 57645, 26214, 49893, 57711, 26214, 50017, 57777, 26214, 50148, 57842, 26214, 50273, 57908, 26214, 50404, 57967, 26214, 50528, 58032, 26214, 50659, 58098, 26214, 50790, 58163, 26214, 50915, 58229, 26214, 51046, 58288, 26214, 51171, 58353, 26214, 51302, 58419, 26214, 51426, 58484, 26214, 51557, 58543, 26214, 51682, 58609, 26214, 51813, 58674, 26214, 51944, 58740, 26214, 52068, 58805, 26214, 52199, 58864, 26214, 52324, 58930, 26214, 52455, 58996, 26214, 52580, 59061, 26214, 52711, 59127, 26214, 52842, 59186, 26214, 52966, 59251, 26214, 53097, 59317, 26214, 53222, 59382, 26214, 53353, 59441, 26214, 53477, 59507, 26214, 53608, 59572, 26214, 53740, 59638, 26214, 53864, 59703, 26214, 53995, 59762, 26214, 54120, 59828, 26214, 54251, 59893, 26214, 54375, 59959, 26214, 54506, 60024, 26214, 54637, 60083, 26214, 54762, 60149, 26214, 54893, 60214, 26214, 55017, 60280, 26214, 55149, 60339, 26214, 55273, 60405, 26214, 55404, 60470, 26214, 55535, 60536, 26214, 55660, 60601, 26214, 55791, 60660, 26214, 55915, 60726, 26214, 56046, 60791, 26214, 56171, 60857, 26214, 56302, 60916, 26214, 56433, 60981, 26214, 56558, 61047, 26214, 56689, 61112, 26214, 56813, 61178, 26214, 56944, 61237, 26214, 57069, 61302, 26214, 57200, 61368, 26214, 57331, 61433, 26214, 57455, 61499, 26214, 57586, 61558, 26214, 57711, 61624, 26214, 57842, 61689, 26214, 57967, 61755, 26214, 58098, 61814, 26214, 58229, 61879, 26214, 58353, 61945, 26214, 58484, 62010, 26214, 58609, 62076, 26214, 58740, 62135, 26214, 58864, 62200, 26214, 58996, 62266, 26214, 59127, 62331, 26214, 59251, 62397, 26214, 59382, 62456, 26214, 59507, 62521, 26214, 59638, 62587, 26214, 59762, 62652, 26214, 59893, 62711, 26214, 60024, 62777, 26214, 60149, 62842, 26214, 60280, 62908, 26214, 60405, 62974, 26214, 60536, 63033, 26214, 60660, 63098, 26214, 60791, 63164, 26214, 60916, 63229, 26214, 61047, 63295, 26214, 61178, 63354, 26214, 61302, 63419, 26214, 61433, 63485, 26214, 61558, 63550, 26214, 61689, 63609, 26214, 61814, 63675, 26214, 61945, 63740, 26214, 62076, 63806, 26214, 62200, 63871, 26214, 62331, 63930, 26214, 62456, 63996, 26214, 62587, 64061, 26214, 62711, 64127, 26214, 62842, 64193, 26214, 62974, 64251, 26214, 63098, 64317, 26214, 63229, 64383, 26214, 63354, 64448, 26214, 63485, 64507, 26214, 63609, 64573, 26214, 63740, 64638, 26214, 63871, 64704, 26214, 63996, 64769, 26214, 64127, 64828, 26214, 64251, 64894, 26214, 64383, 64959, 26214, 64507, 65025, 26214, 64638, 65090, 26214, 64769, 65149, 26214, 64894, 65215, 26214, 65025, 65280, 26214, 65149, 65346, 26214, 65280, 65405, 26214, 65405, 65470, 26214, 65535, 65535, 26214};

static unsigned short colorcube_colormap[] = {10925, 10925, 0, 10925, 21843, 0, 10925, 32768, 0, 10925, 43693, 0, 10925, 54611, 0, 10925, 65535, 0, 21843, 10925, 0, 21843, 21843, 0, 21843, 32768, 0, 21843, 43693, 0, 21843, 54611, 0, 21843, 65535, 0, 32768, 10925, 0, 32768, 21843, 0, 32768, 32768, 0, 32768, 43693, 0, 32768, 54611, 0, 32768, 65535, 0, 43693, 10925, 0, 43693, 21843, 0, 43693, 32768, 0, 43693, 43693, 0, 43693, 54611, 0, 43693, 65535, 0, 54611, 10925, 0, 54611, 21843, 0, 54611, 32768, 0, 54611, 43693, 0, 54611, 54611, 0, 54611, 65535, 0, 65535, 10925, 0, 65535, 21843, 0, 65535, 32768, 0, 65535, 43693, 0, 65535, 54611, 0, 65535, 65535, 0, 0, 10925, 10925, 0, 21843, 10925, 0, 32768, 10925, 0, 43693, 10925, 0, 54611, 10925, 0, 65535, 10925, 10925, 0, 10925, 10925, 21843, 10925, 10925, 32768, 10925, 10925, 43693, 10925, 10925, 54611, 10925, 10925, 65535, 10925, 21843, 0, 10925, 21843, 10925, 10925, 21843, 21843, 10925, 21843, 32768, 10925, 21843, 43693, 10925, 21843, 54611, 10925, 21843, 65535, 10925, 32768, 0, 10925, 32768, 10925, 10925, 32768, 21843, 10925, 32768, 32768, 10925, 32768, 43693, 10925, 32768, 54611, 10925, 32768, 65535, 10925, 43693, 0, 10925, 43693, 10925, 10925, 43693, 21843, 10925, 43693, 32768, 10925, 43693, 43693, 10925, 43693, 54611, 10925, 43693, 65535, 10925, 54611, 0, 10925, 54611, 10925, 10925, 54611, 21843, 10925, 54611, 32768, 10925, 54611, 43693, 10925, 54611, 54611, 10925, 54611, 65535, 10925, 65535, 0, 10925, 65535, 10925, 10925, 65535, 21843, 10925, 65535, 32768, 10925, 65535, 43693, 10925, 65535, 54611, 10925, 65535, 65535, 10925, 0, 10925, 21843, 0, 21843, 21843, 0, 32768, 21843, 0, 43693, 21843, 0, 54611, 21843, 0, 65535, 21843, 10925, 0, 21843, 10925, 10925, 21843, 10925, 21843, 21843, 10925, 32768, 21843, 10925, 43693, 21843, 10925, 54611, 21843, 10925, 65535, 21843, 21843, 0, 21843, 21843, 10925, 21843, 21843, 32768, 21843, 21843, 43693, 21843, 21843, 54611, 21843, 21843, 65535, 21843, 32768, 0, 21843, 32768, 10925, 21843, 32768, 21843, 21843, 32768, 32768, 21843, 32768, 43693, 21843, 32768, 54611, 21843, 32768, 65535, 21843, 43693, 0, 21843, 43693, 10925, 21843, 43693, 21843, 21843, 43693, 32768, 21843, 43693, 43693, 21843, 43693, 54611, 21843, 43693, 65535, 21843, 54611, 0, 21843, 54611, 10925, 21843, 54611, 21843, 21843, 54611, 32768, 21843, 54611, 43693, 21843, 54611, 54611, 21843, 54611, 65535, 21843, 65535, 0, 21843, 65535, 10925, 21843, 65535, 21843, 21843, 65535, 32768, 21843, 65535, 43693, 21843, 65535, 54611, 21843, 65535, 65535, 21843, 0, 10925, 32768, 0, 21843, 32768, 0, 32768, 32768, 0, 43693, 32768, 0, 54611, 32768, 0, 65535, 32768, 10925, 0, 32768, 10925, 10925, 32768, 10925, 21843, 32768, 10925, 32768, 32768, 10925, 43693, 32768, 10925, 54611, 32768, 10925, 65535, 32768, 21843, 0, 32768, 21843, 10925, 32768, 21843, 21843, 32768, 21843, 32768, 32768, 21843, 43693, 32768, 21843, 54611, 32768, 21843, 65535, 32768, 32768, 0, 32768, 32768, 10925, 32768, 32768, 21843, 32768, 32768, 43693, 32768, 32768, 54611, 32768, 32768, 65535, 32768, 43693, 0, 32768, 43693, 10925, 32768, 43693, 21843, 32768, 43693, 32768, 32768, 43693, 43693, 32768, 43693, 54611, 32768, 43693, 65535, 32768, 54611, 0, 32768, 54611, 10925, 32768, 54611, 21843, 32768, 54611, 32768, 32768, 54611, 43693, 32768, 54611, 54611, 32768, 54611, 65535, 32768, 65535, 0, 32768, 65535, 10925, 32768, 65535, 21843, 32768, 65535, 32768, 32768, 65535, 43693, 32768, 65535, 54611, 32768, 65535, 65535, 32768, 0, 10925, 43693, 0, 21843, 43693, 0, 32768, 43693, 0, 43693, 43693, 0, 54611, 43693, 0, 65535, 43693, 10925, 0, 43693, 10925, 10925, 43693, 10925, 21843, 43693, 10925, 32768, 43693, 10925, 43693, 43693, 10925, 54611, 43693, 10925, 65535, 43693, 21843, 0, 43693, 21843, 10925, 43693, 21843, 21843, 43693, 21843, 32768, 43693, 21843, 43693, 43693, 21843, 54611, 43693, 21843, 65535, 43693, 32768, 0, 43693, 32768, 10925, 43693, 32768, 21843, 43693, 32768, 32768, 43693, 32768, 43693, 43693, 32768, 54611, 43693, 32768, 65535, 43693, 43693, 0, 43693, 43693, 10925, 43693, 43693, 21843, 43693, 43693, 32768, 43693, 43693, 54611, 43693, 43693, 65535, 43693, 54611, 0, 43693, 54611, 10925, 43693, 54611, 21843, 43693, 54611, 32768, 43693, 54611, 43693, 43693, 54611, 54611, 43693, 54611, 65535, 43693, 65535, 0, 43693, 65535, 10925, 43693, 65535, 21843, 43693, 65535, 32768, 43693, 65535, 43693, 43693, 65535, 54611, 43693, 65535, 65535, 43693, 0, 10925, 54611, 0, 21843, 54611, 0, 32768, 54611, 0, 43693, 54611, 0, 54611, 54611, 0, 65535, 54611, 10925, 0, 54611, 10925, 10925, 54611, 10925, 21843, 54611, 10925, 32768, 54611, 10925, 43693, 54611, 10925, 54611, 54611, 10925, 65535, 54611, 21843, 0, 54611, 21843, 10925, 54611, 21843, 21843, 54611, 21843, 32768, 54611, 21843, 43693, 54611, 21843, 54611, 54611, 21843, 65535, 54611, 32768, 0, 54611, 32768, 10925, 54611, 32768, 21843, 54611, 32768, 32768, 54611, 32768, 43693, 54611, 32768, 54611, 54611, 32768, 65535, 54611, 43693, 0, 54611, 43693, 10925, 54611, 43693, 21843, 54611, 43693, 32768, 54611, 43693, 43693, 54611, 43693, 54611, 54611, 43693, 65535, 54611, 54611, 0, 54611, 54611, 10925, 54611, 54611, 21843, 54611, 54611, 32768, 54611, 54611, 43693, 54611, 54611, 65535, 54611, 65535, 0, 54611, 65535, 10925, 54611, 65535, 21843, 54611, 65535, 32768, 54611, 65535, 43693, 54611, 65535, 54611, 54611, 65535, 65535, 54611, 0, 10925, 65535, 0, 21843, 65535, 0, 32768, 65535, 0, 43693, 65535, 0, 54611, 65535, 0, 65535, 65535, 10925, 0, 65535, 10925, 10925, 65535, 10925, 21843, 65535, 10925, 32768, 65535, 10925, 43693, 65535, 10925, 54611, 65535, 10925, 65535, 65535, 21843, 0, 65535, 21843, 10925, 65535, 21843, 21843, 65535, 21843, 32768, 65535, 21843, 43693, 65535, 21843, 54611, 65535, 21843, 65535, 65535, 32768, 0, 65535, 32768, 10925, 65535, 32768, 21843, 65535, 32768, 32768, 65535, 32768, 43693, 65535, 32768, 54611, 65535, 32768, 65535, 65535, 43693, 0, 65535, 43693, 10925, 65535, 43693, 21843, 65535, 43693, 32768, 65535, 43693, 43693, 65535, 43693, 54611, 65535, 43693, 65535, 65535, 54611, 0, 65535, 54611, 10925, 65535, 54611, 21843, 65535, 54611, 32768, 65535, 54611, 43693, 65535, 54611, 54611, 65535, 54611, 65535, 65535, 65535, 0, 65535, 65535, 10925, 65535, 65535, 21843, 65535, 65535, 32768, 65535, 65535, 43693, 65535, 65535, 54611, 65535, 1363, 0, 0, 2733, 0, 0, 4096, 0, 0, 5459, 0, 0, 6829, 0, 0, 8192, 0, 0, 9555, 0, 0, 10925, 0, 0, 12288, 0, 0, 13651, 0, 0, 15021, 0, 0, 16384, 0, 0, 17747, 0, 0, 19117, 0, 0, 20480, 0, 0, 21843, 0, 0, 23213, 0, 0, 24576, 0, 0, 25939, 0, 0, 27309, 0, 0, 28672, 0, 0, 30035, 0, 0, 31405, 0, 0, 32768, 0, 0, 34131, 0, 0, 35501, 0, 0, 36864, 0, 0, 38227, 0, 0, 39597, 0, 0, 40960, 0, 0, 42323, 0, 0, 43693, 0, 0, 45056, 0, 0, 46419, 0, 0, 47789, 0, 0, 49152, 0, 0, 50515, 0, 0, 51885, 0, 0, 53248, 0, 0, 54611, 0, 0, 55981, 0, 0, 57344, 0, 0, 58707, 0, 0, 60077, 0, 0, 61440, 0, 0, 62803, 0, 0, 64173, 0, 0, 65535, 0, 0, 0, 1363, 0, 0, 2733, 0, 0, 4096, 0, 0, 5459, 0, 0, 6829, 0, 0, 8192, 0, 0, 9555, 0, 0, 10925, 0, 0, 12288, 0, 0, 13651, 0, 0, 15021, 0, 0, 16384, 0, 0, 17747, 0, 0, 19117, 0, 0, 20480, 0, 0, 21843, 0, 0, 23213, 0, 0, 24576, 0, 0, 25939, 0, 0, 27309, 0, 0, 28672, 0, 0, 30035, 0, 0, 31405, 0, 0, 32768, 0, 0, 34131, 0, 0, 35501, 0, 0, 36864, 0, 0, 38227, 0, 0, 39597, 0, 0, 40960, 0, 0, 42323, 0, 0, 43693, 0, 0, 45056, 0, 0, 46419, 0, 0, 47789, 0, 0, 49152, 0, 0, 50515, 0, 0, 51885, 0, 0, 53248, 0, 0, 54611, 0, 0, 55981, 0, 0, 57344, 0, 0, 58707, 0, 0, 60077, 0, 0, 61440, 0, 0, 62803, 0, 0, 64173, 0, 0, 65535, 0, 0, 0, 1363, 0, 0, 2733, 0, 0, 4096, 0, 0, 5459, 0, 0, 6829, 0, 0, 8192, 0, 0, 9555, 0, 0, 10925, 0, 0, 12288, 0, 0, 13651, 0, 0, 15021, 0, 0, 16384, 0, 0, 17747, 0, 0, 19117, 0, 0, 20480, 0, 0, 21843, 0, 0, 23213, 0, 0, 24576, 0, 0, 25939, 0, 0, 27309, 0, 0, 28672, 0, 0, 30035, 0, 0, 31405, 0, 0, 32768, 0, 0, 34131, 0, 0, 35501, 0, 0, 36864, 0, 0, 38227, 0, 0, 39597, 0, 0, 40960, 0, 0, 42323, 0, 0, 43693, 0, 0, 45056, 0, 0, 46419, 0, 0, 47789, 0, 0, 49152, 0, 0, 50515, 0, 0, 51885, 0, 0, 53248, 0, 0, 54611, 0, 0, 55981, 0, 0, 57344, 0, 0, 58707, 0, 0, 60077, 0, 0, 61440, 0, 0, 62803, 0, 0, 64173, 0, 0, 65535, 0, 0, 0, 1337, 1337, 1337, 2674, 2674, 2674, 4011, 4011, 4011, 5348, 5348, 5348, 6685, 6685, 6685, 8022, 8022, 8022, 9365, 9365, 9365, 10702, 10702, 10702, 12039, 12039, 12039, 13376, 13376, 13376, 14713, 14713, 14713, 16050, 16050, 16050, 17387, 17387, 17387, 18724, 18724, 18724, 20061, 20061, 20061, 21398, 21398, 21398, 22734, 22734, 22734, 24071, 24071, 24071, 25415, 25415, 25415, 26752, 26752, 26752, 28089, 28089, 28089, 29426, 29426, 29426, 30763, 30763, 30763, 32100, 32100, 32100, 33436, 33436, 33436, 34773, 34773, 34773, 36110, 36110, 36110, 37447, 37447, 37447, 38784, 38784, 38784, 40121, 40121, 40121, 41465, 41465, 41465, 42802, 42802, 42802, 44138, 44138, 44138, 45475, 45475, 45475, 46812, 46812, 46812, 48149, 48149, 48149, 49486, 49486, 49486, 50823, 50823, 50823, 52160, 52160, 52160, 53497, 53497, 53497, 54834, 54834, 54834, 56171, 56171, 56171, 57514, 57514, 57514, 58851, 58851, 58851, 60188, 60188, 60188, 61525, 61525, 61525, 62862, 62862, 62862, 64199, 64199, 64199, 65535, 65535, 65535};

static unsigned short flag_colormap[] = {65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0, 65535, 0, 0, 65535, 65535, 65535, 0, 0, 65535, 0, 0, 0};

static unsigned short lines_colormap[] = {0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535, 0, 32768, 0, 65535, 0, 0, 0, 49152, 49152, 49152, 0, 49152, 49152, 49152, 0, 16384, 16384, 16384, 0, 0, 65535};

#endif

unsigned short *snd_colormap(int n)
{
  switch (n)
    {
    case GRAY_COLORMAP: return(gray_colormap); break;
    case HSV_COLORMAP: return(hsv_colormap); break;
    case HOT_COLORMAP: return(hot_colormap); break;
    case COOL_COLORMAP: return(cool_colormap); break;
    case BONE_COLORMAP: return(bone_colormap); break;
    case COPPER_COLORMAP: return(copper_colormap); break;
    case PINK_COLORMAP: return(pink_colormap); break;
    case JET_COLORMAP: return(jet_colormap); break;
    case PRISM_COLORMAP: return(prism_colormap); break;
    case AUTUMN_COLORMAP: return(autumn_colormap); break;
    case WINTER_COLORMAP: return(winter_colormap); break;
    case SPRING_COLORMAP: return(spring_colormap); break;
    case SUMMER_COLORMAP: return(summer_colormap); break;
    case COLORCUBE_COLORMAP: return(colorcube_colormap); break;
    case FLAG_COLORMAP: return(flag_colormap); break;
    case LINES_COLORMAP: return(lines_colormap); break;
    default: return(gray_colormap); break;
    }
}

void get_current_color(int colormap, int j, unsigned short *r, unsigned short *g, unsigned short *b)
{
  /* used only by printer to translate to Postscript rgb colors */
  switch (colormap)
    {
    case GRAY_COLORMAP:      (*r) = gray_colormap[j * 3];      (*g) = gray_colormap[j * 3 + 1];      (*b) = gray_colormap[j * 3 + 2];      break;
    case HSV_COLORMAP:       (*r) = hsv_colormap[j * 3];       (*g) = hsv_colormap[j * 3 + 1];       (*b) = hsv_colormap[j * 3 + 2];       break;
    case HOT_COLORMAP:       (*r) = hot_colormap[j * 3];       (*g) = hot_colormap[j * 3 + 1];       (*b) = hot_colormap[j * 3 + 2];       break;
    case COOL_COLORMAP:      (*r) = cool_colormap[j * 3];      (*g) = cool_colormap[j * 3 + 1];      (*b) = cool_colormap[j * 3 + 2];      break;
    case BONE_COLORMAP:      (*r) = bone_colormap[j * 3];      (*g) = bone_colormap[j * 3 + 1];      (*b) = bone_colormap[j * 3 + 2];      break;
    case COPPER_COLORMAP:    (*r) = copper_colormap[j * 3];    (*g) = copper_colormap[j * 3 + 1];    (*b) = copper_colormap[j * 3 + 2];    break;
    case PINK_COLORMAP:      (*r) = pink_colormap[j * 3];      (*g) = pink_colormap[j * 3 + 1];      (*b) = pink_colormap[j * 3 + 2];      break;
    case JET_COLORMAP:       (*r) = jet_colormap[j * 3];       (*g) = jet_colormap[j * 3 + 1];       (*b) = jet_colormap[j * 3 + 2];       break;
    case PRISM_COLORMAP:     (*r) = prism_colormap[j * 3];     (*g) = prism_colormap[j * 3 + 1];     (*b) = prism_colormap[j * 3 + 2];     break;
    case AUTUMN_COLORMAP:    (*r) = autumn_colormap[j * 3];    (*g) = autumn_colormap[j * 3 + 1];    (*b) = autumn_colormap[j * 3 + 2];    break;
    case WINTER_COLORMAP:    (*r) = winter_colormap[j * 3];    (*g) = winter_colormap[j * 3 + 1];    (*b) = winter_colormap[j * 3 + 2];    break;
    case SPRING_COLORMAP:    (*r) = spring_colormap[j * 3];    (*g) = spring_colormap[j * 3 + 1];    (*b) = spring_colormap[j * 3 + 2];    break;
    case SUMMER_COLORMAP:    (*r) = summer_colormap[j * 3];    (*g) = summer_colormap[j * 3 + 1];    (*b) = summer_colormap[j * 3 + 2];    break;
    case COLORCUBE_COLORMAP: (*r) = colorcube_colormap[j * 3]; (*g) = colorcube_colormap[j * 3 + 1]; (*b) = colorcube_colormap[j * 3 + 2]; break;
    case FLAG_COLORMAP:      (*r) = flag_colormap[j * 3];      (*g) = flag_colormap[j * 3 + 1];      (*b) = flag_colormap[j * 3 + 2];      break;
    case LINES_COLORMAP:     (*r) = lines_colormap[j * 3];     (*g) = lines_colormap[j * 3 + 1];     (*b) = lines_colormap[j * 3 + 2];     break;
    default:                 (*r) = gray_colormap[j * 3];      (*g) = gray_colormap[j * 3 + 1];      (*b) = gray_colormap[j * 3 + 2];      break;
    }
}

