#! /usr/bin/perl
###############################################################################
#
# $Id: Spam.pl,v 1.5 1998/01/09 00:53:22 bcwhite Exp $
#
# Spam.pm
#
# Written by:     Behan Webster <behanw@pobox.com>
# Serverified by: Brian White <bcwhite@pobox.com>
#


%fileinfo;



###########################################################################
# Read in pattern files
#
sub readPatternFiles {
	my ($patterns, @files) = @_;

	my @pat;
	if(!$patterns) {
		$patterns = \@pat;
		$ret = 1;
	}

	foreach $file (@files) {
		next unless -r $file;

		my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
		   $atime,$mtime,$ctime,$blksize,$blocks)
			= stat($file);

		if ($mtime > $fileinfo{$file}->{mtime}) {
			my @localpats;

#			print STDERR "Loading from '$file'...\n";

			open(FILE, "<$file") || next;
			while( <FILE> ) {
				chomp;					# Delete trailing linefeed
				s/#.*$//;				# Delete comments
				next if /^\s*$/;		# Get rid of empty lines
				push(@localpats, $_);	# Add to list of patterns
			}
			close(FILE);

			$fileinfo{$file} = {
				mtime		=> $mtime,
				patterns	=> \@localpats,
			};
		}

		push @$patterns,@{$fileinfo{$file}->{patterns}};
	}

	if($ret) {
		return @pat;
	}
}


###########################################################################
# Write pattern files
#
sub writePatternFiles {
	my $file = shift;

	#
	# Open file (write to STDOUT if $file is empty or "-"
	#
	if($file =~ /^-?$/) {
		open(FILE, ">&STDOUT");
	} else {
		open(FILE, ">$file") || die "$file: $!\n";
	}

	#
	# Write file
	#
	print FILE join("\n", @_)."\n";
	close(FILE) if $file !~ /^-?$/;

	#
	# Update cache
	#
	my $field = {
		mtime		=> time(),
		patterns	=> \@_,
	};
	$fileinfo{$_} = \$field;
}


###########################################################################
# Search for items that match a list of patterns
#
sub search {
	my($patterns, $search) = @_;
	my($regex,@found);

	foreach $regex (@$patterns) {
#		print "REGEX: $regex\n";
#		$regex =~ s|/|\\/|g;
		@found =  grep(/\b\Q$regex\E\b/i,@$search);
		return @found if @found;
	}

	return (wantarray ? () : undef);
}


1;
