/* Copyright (c) 2001  David Muse
   See the file COPYING for more information */

#include <config.h>

#include "perlincludes.h"

#ifndef na
	#define na PL_na
#endif

#ifndef sv_undef
	#define sv_undef PL_sv_undef
#endif

typedef class sqlrcursor sqlrcursor;

MODULE = SQLRelay::Cursor		PACKAGE = SQLRelay::Cursor
REQUIRE: 1.925

sqlrcursor *
sqlrcursor::new(sqlrc)
		sqlrconnection *sqlrc
	CODE:
		RETVAL=new sqlrcursor(sqlrc);
		RETVAL->copyReferences();
	OUTPUT:
		RETVAL

void
sqlrcursor::DESTROY()

void
sqlrcursor::setResultSetBufferSize(rows)
		uint64_t rows

uint64_t
sqlrcursor::getResultSetBufferSize()

void
sqlrcursor::dontGetColumnInfo()

void
sqlrcursor::getColumnInfo()

void
sqlrcursor::mixedCaseColumnNames()

void
sqlrcursor::upperCaseColumnNames()

void
sqlrcursor::lowerCaseColumnNames()

void
sqlrcursor::cacheToFile(filename)
		const char *filename

void
sqlrcursor::setCacheTtl(ttl)
		uint32_t ttl

const char *
sqlrcursor::getCacheFileName()

void
sqlrcursor::cacheOff()

bool
sqlrcursor::sendQuery(query)
		const char *query

bool
sqlrcursor::sendQueryWithLength(query,length)
		const char *query
		uint32_t length
	CODE:
		RETVAL=THIS->sendQuery(query,length);
	OUTPUT:
		RETVAL

bool
sqlrcursor::sendFileQuery(path,file)
		const char *path
		const char *file

void
sqlrcursor::prepareQuery(query)
		const char *query

void
sqlrcursor::prepareQueryWithLength(query,length)
		const char *query
		uint32_t length
	CODE:
		THIS->prepareQuery(query,length);
		

bool
sqlrcursor::prepareFileQuery(path,file)
		const char *path
		const char *file

bool
sqlrcursor::substitution(variable,...)
		const char *variable
	CODE:
		RETVAL=1;
		if (SvIOK(ST(2))) {
			THIS->substitution(variable,(int64_t)SvIV(ST(2)));
		} else if (SvNOK(ST(2))) {
			THIS->substitution(variable,(double)SvNV(ST(2)),
						(uint32_t)SvIV(ST(3)),
						(uint32_t)SvIV(ST(4)));
		} else if (SvPOK(ST(2))) {
			THIS->substitution(variable,SvPV(ST(2),na));
		} else if (ST(2)==&sv_undef) {
			THIS->substitution(variable,(const char *)NULL);
		} else {
			RETVAL=0;
		}
	OUTPUT:
		RETVAL

void
sqlrcursor::clearBinds()

uint16_t
sqlrcursor::countBindVariables()

bool
sqlrcursor::inputBind(variable,...)
		const char *variable
	CODE:
		RETVAL=1;
		if (SvIOK(ST(2))) {
			THIS->inputBind(variable,(int64_t)SvIV(ST(2)));
		} else if (SvNOK(ST(2))) {
			THIS->inputBind(variable,(double)SvNV(ST(2)),
						(uint32_t)SvIV(ST(3)),
						(uint32_t)SvIV(ST(4)));
		} else if (SvPOK(ST(2))) {
			THIS->inputBind(variable,SvPV(ST(2),na));
		} else if (ST(2)==&sv_undef) {
			THIS->inputBind(variable,(const char *)NULL);
		} else {
			RETVAL=0;
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::inputBindBlob(variable,value,size)
		const char *variable
		const char *value
		uint32_t size
	CODE:
		RETVAL=0;
		if (SvPOK(ST(2))) {
			THIS->inputBindBlob(variable,value,size);
			RETVAL=1;
		} else if (ST(2)==&sv_undef) {
			THIS->inputBindBlob(variable,NULL,0);
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::inputBindClob(variable,value,size)
		const char *variable
		const char *value
		uint32_t size
	CODE:
		RETVAL=0;
		if (SvPOK(ST(2))) {
			THIS->inputBindClob(variable,value,size);
			RETVAL=1;
		} else if (ST(2)==&sv_undef) {
			THIS->inputBindClob(variable,NULL,0);
		}
	OUTPUT:
		RETVAL

void
sqlrcursor::validateBinds()

bool
sqlrcursor::executeQuery()

bool
sqlrcursor::fetchFromBindCursor()

void
sqlrcursor::defineOutputBindString(variable,length)
		const char *variable
		uint32_t length

void
sqlrcursor::defineOutputBindInteger(variable)
		const char *variable

void
sqlrcursor::defineOutputBindDouble(variable)
		const char *variable

void
sqlrcursor::defineOutputBindBlob(variable)
		const char *variable

void
sqlrcursor::defineOutputBindClob(variable)
		const char *variable

void
sqlrcursor::defineOutputBindCursor(variable)
		const char *variable

const char *
sqlrcursor::getOutputBindString(variable)
		const char *variable
	CODE:
		const char	*value=THIS->getOutputBindString(variable);
		uint32_t	length=THIS->getOutputBindLength(variable);
		ST(0)=sv_newmortal();
		if (value) {
			sv_setpvn(ST(0),value,length);
		} else {
			ST(0)=&sv_undef;
		}

const char *
sqlrcursor::getOutputBindBlob(variable)
		const char *variable
	CODE:
		const char	*value=THIS->getOutputBindBlob(variable);
		uint32_t	length=THIS->getOutputBindLength(variable);
		ST(0)=sv_newmortal();
		if (value) {
			sv_setpvn(ST(0),value,length);
		} else {
			ST(0)=&sv_undef;
		}

const char *
sqlrcursor::getOutputBindClob(variable)
		const char *variable
	CODE:
		const char	*value=THIS->getOutputBindClob(variable);
		uint32_t	length=THIS->getOutputBindLength(variable);
		ST(0)=sv_newmortal();
		if (value) {
			sv_setpvn(ST(0),value,length);
		} else {
			ST(0)=&sv_undef;
		}

int64_t
sqlrcursor::getOutputBindInteger(variable)
		const char *variable
	CODE:
		int64_t	value=THIS->getOutputBindInteger(variable);
		ST(0)=sv_newmortal();
		sv_setiv(ST(0),value);

double
sqlrcursor::getOutputBindDouble(variable)
		const char *variable
	CODE:
		double	value=THIS->getOutputBindDouble(variable);
		ST(0)=sv_newmortal();
		sv_setnv(ST(0),value);

uint32_t
sqlrcursor::getOutputBindLength(variable)
		const char *variable

sqlrcursor *
sqlrcursor::getOutputBindCursor(variable)
		const char *variable
	PREINIT:
		// on some platforms, this needs to be a
		// char * rather than const char *
		char *	CLASS = "SQLRelay::Cursor";
	CODE:
		RETVAL=THIS->getOutputBindCursor(variable);
		RETVAL->copyReferences();
	OUTPUT:
		RETVAL

bool
sqlrcursor::openCachedResultSet(filename)
	const char	*filename

uint32_t
sqlrcursor::colCount()

uint64_t
sqlrcursor::rowCount()

uint64_t
sqlrcursor::totalRows()

uint64_t
sqlrcursor::affectedRows()

uint64_t
sqlrcursor::firstRowIndex()

bool
sqlrcursor::endOfResultSet()

const char *
sqlrcursor::errorMessage()

void
sqlrcursor::getNullsAsEmptyStrings()

void
sqlrcursor::getNullsAsUndefined()
	CODE:
		THIS->getNullsAsNulls();

bool
sqlrcursor::validRow(row)
		uint64_t	row
	CODE:
		RETVAL=1;
		if (!THIS->getRow(row)) {
			RETVAL=0;
		}
	OUTPUT:
		RETVAL

const char *
sqlrcursor::getField(row,...)
		uint64_t	row
	CODE:
		const char	*field=NULL;
		uint32_t	length=0;
		ST(0)=sv_newmortal();
		if (SvIOK(ST(2)) || SvNOK(ST(2))) {
			field=THIS->getField(row,(uint32_t)SvIV(ST(2)));
			length=THIS->getFieldLength(row,(uint32_t)SvIV(ST(2)));
		} else if (SvPOK(ST(2))) {
			field=THIS->getField(row,SvPV(ST(2),na));
			length=THIS->getFieldLength(row,SvPV(ST(2),na));
		} 
		if (field) {
			sv_setpvn(ST(0),field,length);
		} else {
			ST(0)=&sv_undef;
		}

int64_t
sqlrcursor::getFieldAsInteger(row,...)
		uint64_t	row
	CODE:
		int64_t	field=0;
		ST(0)=sv_newmortal();
		if (SvIOK(ST(2)) || SvNOK(ST(2))) {
			field=THIS->getFieldAsInteger(row,
						(uint32_t)SvIV(ST(2)));
		} else if (SvPOK(ST(2))) {
			field=THIS->getFieldAsInteger(row,SvPV(ST(2),na));
		} 
		sv_setiv(ST(0),field);

double
sqlrcursor::getFieldAsDouble(row,...)
		uint64_t	row
	CODE:
		double	field=0.0;
		ST(0)=sv_newmortal();
		if (SvIOK(ST(2)) || SvNOK(ST(2))) {
			field=THIS->getFieldAsDouble(row,(uint32_t)SvIV(ST(2)));
		} else if (SvPOK(ST(2))) {
			field=THIS->getFieldAsDouble(row,SvPV(ST(2),na));
		} 
		sv_setnv(ST(0),field);

uint32_t
sqlrcursor::getFieldLength(row,...)
		uint64_t	row
	CODE:
		RETVAL=0;
		if (SvIOK(ST(2)) || SvNOK(ST(2))) {
			RETVAL=THIS->getFieldLength(row,(uint32_t)SvIV(ST(2)));
		} else if (SvPOK(ST(2))) {
			RETVAL=THIS->getFieldLength(row,SvPV(ST(2),na));
		}
	OUTPUT:
		RETVAL

const char * const *
sqlrcursor::getColumnNames()
	PPCODE:
		uint32_t	index=0;
		const char * const *namesptr=THIS->getColumnNames();
		EXTEND(SP,THIS->colCount());
		if (namesptr) {
			for (index=0; index<THIS->colCount(); index++) {
				// On some platforms newSVpv takes a char *
				// argument rather than a const char *
				// argument.
				PUSHs(sv_2mortal(
					newSVpv((char *)namesptr[index],0)));
			}
		}

const char *
sqlrcursor::getColumnName(col)
		uint32_t col

const char *
sqlrcursor::getColumnType(...)
	CODE:
		RETVAL=NULL;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnType((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnType(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

uint32_t
sqlrcursor::getColumnLength(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnLength((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnLength(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

uint32_t
sqlrcursor::getColumnPrecision(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnPrecision((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnPrecision(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

uint32_t
sqlrcursor::getColumnScale(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnScale((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnScale(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::getColumnIsNullable(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnIsNullable((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnIsNullable(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::getColumnIsPrimaryKey(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnIsPrimaryKey((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnIsPrimaryKey(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::getColumnIsUnique(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnIsUnique((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnIsUnique(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::getColumnIsPartOfKey(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnIsPartOfKey((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnIsPartOfKey(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::getColumnIsUnsigned(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnIsUnsigned((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnIsUnsigned(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::getColumnIsZeroFilled(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnIsZeroFilled((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnIsZeroFilled(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::getColumnIsBinary(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnIsBinary((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnIsBinary(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

bool
sqlrcursor::getColumnIsAutoIncrement(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getColumnIsAutoIncrement((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getColumnIsAutoIncrement(SvPV(ST(1),na));
		}
	OUTPUT:

uint32_t
sqlrcursor::getLongest(...)
	CODE:
		RETVAL=0;
		if (SvIOK(ST(1)) || SvNOK(ST(1))) {
			RETVAL=THIS->getLongest((uint32_t)SvIV(ST(1)));
		} else if (SvPOK(ST(1))) {
			RETVAL=THIS->getLongest(SvPV(ST(1),na));
		}
	OUTPUT:
		RETVAL

uint16_t
sqlrcursor::getResultSetId()

void
sqlrcursor::suspendResultSet()

bool
sqlrcursor::resumeResultSet(id)
		uint16_t id

bool
sqlrcursor::resumeCachedResultSet(id,filename)
		uint16_t id
		const char *filename
