/*
 * Copyright (C) 1996-2019 The Squid Software Foundation and contributors
 *
 * Squid software is distributed under GPLv2+ license and includes
 * contributions from numerous individuals and organizations.
 * Please see the COPYING and CONTRIBUTORS files for details.
 */

#include "squid.h"
#include "DiskIO/AIO/AIODiskIOModule.h"
#include "DiskIO/AIO/AIODiskIOStrategy.h"
#include "Store.h"

AIODiskIOModule::AIODiskIOModule()
{
    ModuleAdd(*this);
}

AIODiskIOModule &
AIODiskIOModule::GetInstance()
{
    return Instance;
}

void
AIODiskIOModule::init()
{}

void
AIODiskIOModule::gracefulShutdown()
{}

DiskIOStrategy *
AIODiskIOModule::createStrategy()
{
    return new AIODiskIOStrategy();
}

AIODiskIOModule AIODiskIOModule::Instance;

char const *
AIODiskIOModule::type () const
{
    return "AIO";
}

