<?php
/**
 * sqspell_options.php 
 * --------------------
 * Main wrapper for the options interface.
 *
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * $Id: sqspell_options.php,v 1.6 2002/02/02 02:17:05 philippe_mingo Exp $
 *
 * @author Konstantin Riabitsev <icon@duke.edu> ($Author: philippe_mingo $)
 * @version $Date: 2002/02/02 02:17:05 $
 */

/**
 * Set a couple of constants and defaults. Don't change these, 
 * the configurable stuff is in sqspell_config.php
 */
$SQSPELL_DIR='squirrelspell';
$SQSPELL_CRYPTO=FALSE;

/**
 * Load some necessary stuff from squirrelmail. 
 */
chdir('..');
require_once('../src/validate.php');
require_once('../src/load_prefs.php');
require_once('../functions/strings.php');
require_once('../functions/page_header.php');
require_once("$SQSPELL_DIR/sqspell_config.php");
require_once("$SQSPELL_DIR/sqspell_functions.php");

/**
 * $MOD is the name of the module to invoke.
 * If $MOD is unspecified, assign "init" to it. Else check for
 * security breach attempts.
 */
if (!isset($MOD) || !$MOD){
  $MOD = 'options_main';
} else {
  sqspell_ckMOD($MOD);
}

/**
 * Load the stuff already. 
 */
require_once("$SQSPELL_DIR/modules/$MOD.mod");
?>
