#include "header.h"


static short buffer [BUFFER_LEN];
SNDFILE *sndfile;
int subformat;
extern int channels;
extern struct timeval playmaxstamp[MAX_CHANNELS];

int init_play_file(char *filename){
    SF_INFO sfinfo;
    int i;

    play_abort();
    
    memset (&sfinfo, 0, sizeof (sfinfo));

    if (strlen(filename)==0) {
        error("No file specified");
        return -1;
    }
    
    printf ("Playing %s\n", filename);
    if (! (sndfile = sf_open (filename, SFM_READ, &sfinfo))){   
        error("Can't play %s - %s", filename, sf_strerror (NULL));
        return -1;
    };

    if (sfinfo.channels < 1 || sfinfo.channels > 2){   
        error ("Channels = %d.", sfinfo.channels);
        return -1;
    };
    
    if (subformat == SF_FORMAT_FLOAT || subformat == SF_FORMAT_DOUBLE){   
        error("Float point files are not supported");
        return -1;
    }

    dbg("sfinfo: format=0x%x channels=%d speed=%d   frames=%d\n", sfinfo.format, sfinfo.channels, sfinfo.samplerate, sfinfo.frames);
    dsp->format=sf2dsp(&sfinfo);
    dbg("converted format=0x%x\n", dsp->format);
    dsp->channels=sfinfo.channels; /* have a look at play_func if you change this */
    channels=dsp->channels;
    if (channels>MAX_CHANNELS) channels=MAX_CHANNELS;
    dsp->speed=sfinfo.samplerate;   
    if (open_dsp(dsp, 0)<0) {
        error("Can't open DSP %s for playing", dsp->filename);
        return -1;
    };
    dbg("play opened: format=%x channels=%d speed=%d\n", dsp->format, dsp->channels, dsp->speed);

    subformat = sfinfo.format & SF_FORMAT_SUBMASK;
    set_handlers(dsp->fd, NULL, play_func, NULL, NULL);
    
    for (i=0;i<MAX_CHANNELS;i++) playmax[i]=0;
    return 0; 
}  

int init_rec_file(char *filename){
    int fd;SF_INFO sfinfo;

    play_abort();
    
    memset (&sfinfo, 0, sizeof (sfinfo));

    sfinfo.format     = cfg->format;
    sfinfo.channels   = cfg->channels;
    channels=sfinfo.channels;
    sfinfo.samplerate = cfg->samplerate;
    
    if (!sfinfo.format)     sfinfo.format=SF_FORMAT_WAV | SF_FORMAT_PCM_16;
    if (!sfinfo.channels)   sfinfo.channels=1;
    if (!sfinfo.samplerate) sfinfo.samplerate=22050;
    

    fmkdir_p(filename,0775);

    if ((fd=open(filename, O_WRONLY|O_CREAT|O_TRUNC, 0666))<0){
        error ("Error writing file (1) %s: %s",filename, strerror (errno));
        return -1;
    };

    dbg("check:%d\n", sf_format_check(&sfinfo));
    
    if (! (sndfile = sf_open_fd (fd, SFM_WRITE, &sfinfo, 1))){   
        error ("Error writing file (2) %s: %s",filename, sf_strerror (NULL));
        return -1;
    };
    
    if (subformat == SF_FORMAT_FLOAT || subformat == SF_FORMAT_DOUBLE){   
        error("Float point files are not supported");
        return -1;
    }

    dbg("sfinfo: format=%x channels=%d speed=%d   frames=%d\n", sfinfo.format, sfinfo.channels, sfinfo.samplerate, sfinfo.frames);
    dsp->format=sf2dsp(&sfinfo);
/*    dbg("converted format=%x\n", dsp->format);*/
    dsp->channels=sfinfo.channels; 
    dsp->speed=sfinfo.samplerate;   
    if (open_dsp(dsp, 1)<0){
        error("Can't open DSP %s for recording", dsp->filename);
        return -1;
    };
    dbg("rec opened: format=%x channels=%d speed=%d\n", dsp->format, dsp->channels, dsp->speed);

    subformat = sfinfo.format & SF_FORMAT_SUBMASK;
    CONDGFREE(cfg->filename);
    cfg->filename=g_strdup(filename);
    set_handlers(dsp->fd, rec_func, NULL, NULL, NULL);
    return 0; 
}  

void play_func(void *dummy){
    int written, readcount,i,j;
/*    dbg("play_func\n");*/
    readcount = sf_read_short (sndfile, buffer, BUFFER_LEN);
    if (readcount <=0) {
        dbg("readcount=%d\n", readcount);
        play_close();
        send_reply();
        return;
    }

    for (j=0;j<dsp->channels;j++){
        int dirty=0;
        for (i=0;i<readcount;i+=dsp->channels){
            short sample=buffer[i*dsp->channels+j];
            if (sample<0) sample=-sample;
            if (sample>playmax[j]) {
                playmax[j]=sample;
                dirty=1;
            }
            /*if (dirty)*/ gettimeofday(&playmaxstamp[j],NULL);
        }
    }
        
    written  = write (dsp->fd, buffer, readcount * sizeof (short));
    /*dbg("written=%d  readcount*%d=%d  errno=%d\n",
                written, sizeof(short), readcount*sizeof(short), errno);*/
    if (written < readcount * sizeof(short)){
        error("Can't write to dsp: %d/%d \n",written, readcount*sizeof(short));
        play_close();
        send_reply();
        return;
    }
}

void rec_func(void *dummy){
    int i,j;
/*    dbg("rec_func\n");*/

    int readed, writecount=0;
    readed  = read(dsp->fd, buffer, BUFFER_LEN);
	if (readed<0) return;
  /*  dbg("readed=%d  readed/%d=%d  errno=%d\n",
                readed, sizeof(short), readed/sizeof(short), errno);*/
    if (readed==0){
        if (readed > writecount * sizeof(short)){
            dbg("done\n");
            play_close();
        }
        return;
    }

    for (j=0;j<dsp->channels;j++){
        int dirty=0;
        playmax[j]=0;
        for (i=0;i<readed/(sizeof(short)*dsp->channels);i+=dsp->channels){
            short sample=buffer[i*dsp->channels+j];
           // dbg("%d ", sample);
            if (sample<0) sample=-sample;
            if (sample>playmax[j]) {
                playmax[j]=sample;
                dirty=1;
            }
        }
        /*if (dirty)*/ gettimeofday(&playmaxstamp[j],NULL);
            
        //dbg("playmax[%d]=%6d\n", j, playmax[j]);
    }

        
    writecount = sf_write_short (sndfile, buffer, readed/sizeof(short));
    if (writecount <=0) {
        dbg(" writecount=%d\n", writecount);
        play_close();
        return;
    }
    
}

void play_close(){  /* == rec_close */
    gchar *tmpfile;
    dbg("play_close\n");

    if (sndfile) { 
        sf_close (sndfile);
    
        if (!cfg->template || !cfg->filename) goto x;
        tmpfile=convert_esc(cfg->template, CE_NONE);
        dbg("cfg->template='%s' cfg->callsign='%s' \n", cfg->template, cfg->callsign);
        dbg("tmpfile='%s'  cfg->filename='%s'\n", tmpfile, cfg->filename);
        if (strcmp(tmpfile, cfg->filename)){
            rename(cfg->filename, tmpfile);
        }
        g_free(tmpfile);
        sndfile = NULL;
    }
x:;    
    close_dsp(dsp);
}

void play_abort(){  /* == rec_abort */
    dbg("play_abort\n");
    reset_dsp(dsp);
    play_close();
}

