/* $Id: fstty.c,v 201.0 2002/02/14 09:29:14 sgifford Exp $ */

#include "stdebug.h"

#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <string.h>

/* Run stty on the given file descriptor with the given arguments */
int
fstty(int fd, char *stty_args)
{
  int child_status;
  int pid;
  char *stty_cmd;
        
  stty_cmd = malloc(strlen(stty_args)+1+strlen("stty "));
  if (!stty_cmd)
    reterr(-1,"Couldn't malloc for stty_cmd:");
  strcpy(stty_cmd,"stty ");
  strcat(stty_cmd,stty_args);
                
  if ((pid=fork()) == 0)
  {
    /* Child */
    if (dup2(fd,STDIN_FILENO) < 0)
      die("Couldn't dup2(%d,STDIN_FILENO=%d):",fd,STDIN_FILENO);
    if (execlp("sh","sh","-c",stty_cmd,NULL) < 0)
      die("Couldn't exec stty command:");
    /* Should never reach here. */
    exit(-1);
  }
  else if (pid == -1)
  {
    reterr(-1,"Couldn't fork:");
  }
                
  /* Parent */

  free(stty_cmd);

  if (wait(&child_status) <= 0)
    reterr(-1,"Error waiting for forked stty process:");
  if (!(WIFEXITED(child_status) && WEXITSTATUS(child_status) == 0) )
    reterr(-1,"stty %s failed\n",stty_args);

  return 0;
}
