
/* $Id: stdebug.h,v 201.0 2002/02/14 09:29:14 sgifford Exp $ */

#ifndef STDEBUG_H
#define STDEBUG_H

#include <stdarg.h>

int dumpbuf_cont(const char *buf, int size);
int dumpbuf_start(const char *buf, int size);
int dumpbuf_end(void);
int dumpbuf(const char *buf, int size);
int setdebuglevel(int newlevel);
int debuglevel(int testlevel);
int debugf(int minlevel, const char *format, ...);
void die(const char *format, ...);
void warn(const char *format, ...);
void errdump(const char *format, ...);
int errorf(const char *format, ...);
int reterr(int ret, const char *format, ...);
int vreterr(int ret, const char *format, va_list a);
void clearerrors(void);

#endif /* STDEBUG_H */
