import Visconte;

/**
 * <p>class OWLItemFactory - This factory creates new OWLItems</p>
 */

/**
 * <p>Construct a OWLClass</p>
 * 
 * @param ontology - the ontology object
 * @param ID id - the id of the class to construct
 * @param ID parent_id - the id of the parent class
 * @param label - the label mapping (["en":"label"])
 * @param equivalent_Class - the ids of classes that are equal to this (no effect currently)
 * @param different_From - the ids of classes that are different to this (no effect currently)
 * @return Visconte.Onto.Item.OWLItem - the constructed class 
 */
    public Visconte.Onto.Item.OWLItem construct_Class(Visconte.Onto.Ontology ontology, ID id, ID parent_id, mapping label, array equivalent_Class, array different_From) 
    {        
	    Visconte.Onto.Item.OWLItem owl_class;
	    array eq_Classes =({});
	    array diff_Classes =({});;
	    
	    //Test the existence of the ids
	    
	    
	    if(!ontology->item_exists(parent_id->ref))
		    parent_id=0;
	    
	    foreach(equivalent_Class,ID class_id)
	    {
		    if(ontology->item_exists(class_id->ref))
		    {
			    eq_Classes+=({class_id->ref});
		    }
	    }
	    
	    foreach(different_From,ID class_id)
	    {
		    if(ontology->item_exists(class_id->ref))
		    {
			    diff_Classes+=({class_id->ref});
		    }
	    }
	   
	   //test if there already exists a class with this id
	   if(ontology->item_exists(id->ref))
	   {
		   owl_class = ontology->get_Class(id->ref);
	   }
	   else
	   {
		   array properties = ({ })   ;
		   array range_properties = ({ })   ;
		   array childs= ({ })   ;
		   array individuals= ({ })   ;
		   owl_class = Visconte.Onto.Item.OWLClass(ontology,id->ref,parent_id->ref,label, properties, range_properties, childs, individuals,eq_Classes,diff_Classes);
	   }
	   
	   if(!owl_class)
		    throw( ({ "", backtrace(),1123,id->ref}) );
	   else
		   return owl_class;
    } 


    
    
/**
 * <p>Construct a propery (Both Object and DatatypeProperty</p>
 * 
 * @param ontology - the ontology object
 * @param ID id - the id of the class to construct
 * @param label - the label mapping (["en":"label"])
 * @param restriction - property is transitive etc. (no effect currently)
 * @param ID domain - the id of the class that act as domain
 * @param ID domain - the id of the class that act as range or a XSD-Value (like xsd:String etc.)
 * @return Visconte.Onto.Item.OWLProperty - the constructed property
 */
    public Visconte.Onto.Item.OWLProperty construct_Property(Visconte.Onto.Ontology ontology, ID id, mapping label, mapping restriction, ID domain_id, ID range_id) 
    {        
	    
	    Visconte.Onto.Item.OWLClass domain, range;
	    Visconte.Onto.Item.OWLProperty property;
	    int is_Datatype=0;
	    
	    
	   
	     //test if the range is not a datatype
	    
	    if(range_id->has_ns("xsd"))
	    {
		    is_Datatype=1;
	    }
	    
	    
	    //test for domain existence
	    if(!ontology->item_exists(domain_id->ref))
		    throw( ({ "", backtrace(),1135,id->ref}) );
	    
	    if(!is_Datatype && !ontology->item_exists(range_id->ref))
		    throw( ({ "", backtrace(),1137,id->ref}) );
	    
	    //is there already a property with this id
	     if(ontology->item_exists(id->ref))
	     {
			    return ontology->get_Item(id->ref);
	     } 
	   
	    if(!is_Datatype)
	    {
			    if(ontology->item_exists(domain_id->ref))
				     domain = ontology->get_Class(domain_id->ref);
			    else
				    domain=0;
			    if(ontology->item_exists(range_id->ref))
				     range = ontology->get_Class(range_id->ref);
			    else
				    range=0;
			     
			    Visconte.Onto.Item.OWLObjectProperty property = Visconte.Onto.Item.OWLObjectProperty(ontology,id->ref,restriction,label,domain,range);
			    if(!property)
				throw( ({ "", backtrace(),1131,id->ref}) );
			    else
				return property;
		
	    }
	    else
	    {
			    if(ontology->item_exists(domain_id->ref))
				     domain = ontology->get_Class(domain_id->ref);
			    else
				    domain=0;
			   
			    Visconte.Onto.Item.OWLDatatypeProperty property =  Visconte.Onto.Item.OWLDatatypeProperty(ontology,id->ref,restriction,label,domain,range_id->ref);
			    if(!property)
				throw( ({ "", backtrace(),1133,id->ref}) );
			    else
				return property;
	    }
	    
	    throw( ({ "", backtrace(),1103,id->ref}) );
    }
    
    
/**
 * <p>Construct an Individual</p>
 * 
 * @param ontology - the ontology object
 * @param ID id - the id of the individual to construct
 * @param ID class_id - the id of the template class
 * @param label - the label mapping (["en":"label"])
 * @param property_values - MulitvalueList that stores the assigend properties
 * @return Visconte.Onto.Item.OWLIndividual - the constructe individual
 */
    public Visconte.Onto.Item.OWLIndividual construct_Individual(Visconte.Onto.Ontology ontology, ID id, ID class_id, mapping label, Visconte.MVList property_values)
    {
	      
	      if(!ontology->item_exists(class_id->ref))
	      {
		      throw( ({ "", backtrace(),1141,id->ref}) );
	      }
	       
	      if(ontology->item_exists(id->ref))
	      {
		     return ontology->get_Item(id->ref);
	      }
	      else
	      {
		      Visconte.Onto.Item.OWLClass model_class = ontology->get_Class(class_id->ref);
		      
		      Visconte.Onto.OWLContainer all_properties = Visconte.Onto.OWLContainer();
		      do
		      {
			      Visconte.Onto.OWLContainer properties = model_class->get_domain_properties();
			      while(properties->has_items())
			      {
				      all_properties->add(properties->next());
			      }
			      model_class = model_class->get_parent();
				     
		      }
		      while(model_class!=0);
		      Visconte.Onto.Item.OWLIndividual individual = Visconte.Onto.Item.OWLIndividual(ontology, id->ref, class_id->ref,label,all_properties,property_values );
		      if(!individual)
			throw( ({ "", backtrace(),1143,id->ref}) );
		      else
			return individual;
	      }
	      
	      throw( ({ "", backtrace(),1103,id->ref}) );

		      
		      
	    
    }

