inherit "/classes/Object";
#include <macros.h>
#include <database.h>
#include <classes.h>
#include <events.h>
#include <attributes.h>

/**
 * <p>class StorageHandler - Class for accessing the underlying filessystem</p>
 */
 
 
class Steam
{

/**
 * <p>Saves the ontology</p>
 * 
 * 
 * @param filename the name of the file
 * @param content the content of the file
 * @return success
 */
    public int save(string file, string content) {  
	    if(!file)
		    return 0;	       

	    if(exist(file))
	    {
		    object ob = find_object(file);
		    ob->set_content(content);
	    }
	    else
	    {
		    object factory =  _Server->get_factory(CLASS_DOCUMENT);
		    object ob = factory->execute( ([ "name" : basename(file), "mimetype": "text/xml" ]) );
		    ob->set_content(content);
		    ob->move(OBJ(dirname(file)));
	    }
	return 1;
    } 
    
/**
 * <p>backup an old ontology</p>
 * 
 * 
 * @param filename the name of the file
 * @param content the content of the file
 * @param version the version of the file
 * @return success
 */
    public int backup(string filename, string content, int version) {    
	    
	string container_name = basename(filename)+".history";	
	object container = find_object(dirname(filename)+"/"+container_name);
	if(container==0)
	{
		object factory = _Server->get_factory(CLASS_CONTAINER);
		container = factory->execute
		    		( ([ "name" : container_name]) );
		container->move(OBJ(dirname(filename)));
	}
	string version_name = (string)version;
	if(version<10)
		version_name="0"+version_name;
	
	filename = dirname(filename)+"/"+container_name+"/"+version_name+"_"+basename(filename);			
	
      return save(filename,content);
    } 


/**
 * <p>fetchback an old ontology</p>
 * 
 * 
 * @param filename the name of the file
 * @param content the content of the file
 * @return success
 */
    public string fetchback(string filename, int version) {    
	    
	string container_name = basename(filename)+".history";	
	object container = find_object(dirname(filename)+"/"+container_name);
	if(container)
	{
		string version_name = (string)version;
		if(version<10)
			version_name="0"+version_name;
	
		filename = dirname(filename)+"/"+container_name+"/"+version_name+"_"+basename(filename);
		return open(filename);
	}
	else
		return 0;
				
	
      
    } 
/**
 * <p>Opens a file with the given name and returns its content as string.</p>
 * 
 * 
 * @param file the name of the file 
 * @return the content
 */
    public string open(string file) 
    {      
        
	if(exist(file))
	{
		object ob = find_object(file);
		return ob->get_content();
	}
	else
		return "";
    } 

/**
 * <p>Tests if a file exists already</p>
 * 
 * 
 * @param file the filename
 * @return exists
 */
    public int exist(string file) {    
	   
	    if(find_object(file))
		    return 1;
	    else 
		    return 0;

    } 
    
    
    
int get_object_id()
{
    return this_user()->get_object_id();
}

object this()
{
    return this_user();
}

int get_object_class()
{
    return this_user()->get_object_class();
}
}

class FileSystem
{
/**
 * <p>class StorageHandler is an interface, which handles the file input output on different systems. 
 * This Interface should be implemented by a custom class, which fits to the underlying system</p>
 */

/**
 * <p>Saves the ontology</p>
 * 
 * 
 * @param filename the name of the file
 * @param content the content of the file
 * @return success
 */
    public int save(string filename, string content) {        
        return 0;
    } 
    
/**
 * <p>backup an old ontology</p>
 * 
 * 
 * @param filename the name of the file
 * @param content the content of the file
 * @return success
 */
    public int backup(string filename, string content) {        
        return 0;
    } 

/**
 * <p>Opens a file with the given name and returns its content as string.</p>
 * 
 * 
 * @param file the name of the file 
 * @return the content
 */
    public string open(string file) {        
        
        return "";
    } 

/**
 * <p>Tests if a file exists already</p>
 * 
 * 
 * @param file the filename
 * @return exists
 */
    public int exist(string file) {        
        return 0;
    } 	
}
