/*
 * Storm Package Manager
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
#define _XOPEN_SOURCE
#include <unistd.h>
#include <string.h>
#include <pwd.h>
#include <shadow.h>
#include <sys/stat.h>

#include "../libstormpkg/libstormpkg_app_include.h"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "stormpkg.h"
#include "depend.h"
#include "sources.h"
#include "main.h"

//static int main_window_visible = 0;

void
on_exit_activate()
{
    gtk_exit(0);
}


void
on_install_toolbar_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   mark_selected_packages(pkgCache::State::Install);//want_install);
}


void
on_remove_toolbar_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   mark_selected_packages(pkgCache::State::DeInstall);//want_deinstall);
}

void
on_purge_toolbar_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
   mark_selected_packages(pkgCache::State::Purge);//want_purge);
}

void
on_hold_toolbar_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
   mark_selected_packages(pkgCache::State::Hold);//want_hold);
}



void
on_filter_toolbar_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
//   gtk_widget_hide(filter_window);
   gtk_widget_show(filter_window);
   gdk_window_raise(filter_window->window);
   gtk_widget_grab_focus(lookup_widget(filter_window,"filter_textentry"));
}


void
on_update_toolbar_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
   update_packages();
}


void
on_apply_toolbar_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
   populate_changes_list();
   gtk_widget_show(apply_changes_window);
}


void
on_filter_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   static GtkWidget *filter_textentry = NULL;
   static GtkToggleButton *case_sensitive_checkbutton = NULL;
   static GtkToggleButton *names_radiobutton = NULL;
   static GtkToggleButton *descriptions_radiobutton = NULL;
   static GtkToggleButton *both_radiobutton = NULL;
   static GtkToggleButton *uninstalled_radiobutton = NULL;
   static GtkToggleButton *installed_radiobutton = NULL;
   static GtkToggleButton *all_radiobutton = NULL;
   gint where_mask,packages_mask;
   gboolean case_sensitive;

   if (!filter_textentry)
      filter_textentry = lookup_widget(filter_window,"filter_textentry");

   if (!case_sensitive_checkbutton)
      case_sensitive_checkbutton = GTK_TOGGLE_BUTTON(lookup_widget(filter_window,"case_sensitive_checkbutton"));

   if (!names_radiobutton)
      names_radiobutton = GTK_TOGGLE_BUTTON(lookup_widget(filter_window,"names_radiobutton"));

   if (!descriptions_radiobutton)
      descriptions_radiobutton = GTK_TOGGLE_BUTTON(lookup_widget(filter_window,"descriptions_radiobutton"));

   if (!both_radiobutton)
      both_radiobutton = GTK_TOGGLE_BUTTON(lookup_widget(filter_window,"both_radiobutton"));

   if (!uninstalled_radiobutton)
      uninstalled_radiobutton = GTK_TOGGLE_BUTTON(lookup_widget(filter_window,"uninstalled_radiobutton"));

   if (!installed_radiobutton)
      installed_radiobutton = GTK_TOGGLE_BUTTON(lookup_widget(filter_window,"installed_radiobutton"));

   if (!all_radiobutton)
      all_radiobutton = GTK_TOGGLE_BUTTON(lookup_widget(filter_window,"all_radiobutton"));

   case_sensitive = gtk_toggle_button_get_active(case_sensitive_checkbutton);

   where_mask = (gtk_toggle_button_get_active(names_radiobutton) == TRUE) ? SEARCH_NAMES : 0;
   where_mask|= (gtk_toggle_button_get_active(descriptions_radiobutton) == TRUE) ? SEARCH_DESCRIPTIONS : 0;
   where_mask|= (gtk_toggle_button_get_active(both_radiobutton) == TRUE) ? (SEARCH_NAMES | SEARCH_DESCRIPTIONS): 0;

   packages_mask = (gtk_toggle_button_get_active(uninstalled_radiobutton) == TRUE) ? PACKAGES_UNINSTALLED : 0;
   packages_mask|= (gtk_toggle_button_get_active(installed_radiobutton) == TRUE) ? PACKAGES_INSTALLED : 0;
   packages_mask|= (gtk_toggle_button_get_active(all_radiobutton) == TRUE) ? (PACKAGES_UNINSTALLED | PACKAGES_INSTALLED) : 0;

   populate_package_tree_search(gtk_entry_get_text(GTK_ENTRY(filter_textentry)),case_sensitive,where_mask,packages_mask);
   gtk_widget_show(main_window);
   gray_buttons(1);
   gray_buttons(0);
}


void
on_filter_textentry_activate         (GtkEditable     *editable,
                                        gpointer         user_data)
{
   static GtkWidget *filter_button = NULL;

   if (!filter_button)
      filter_button = lookup_widget(filter_window,"filter_button");

   on_filter_button_clicked(GTK_BUTTON(filter_button),NULL);	/* Fake click */
}



gboolean case_sensitive=FALSE;

void
on_find_toolbar_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
   static GtkWidget *find_textentry = NULL;

   if (!find_textentry)
      find_textentry = lookup_widget(main_window,"find_textentry");

   find_next(gtk_entry_get_text(GTK_ENTRY(find_textentry)),case_sensitive);
}


void
on_c_s_f_activate()
{
    if  (case_sensitive==FALSE) case_sensitive=TRUE;
    else    case_sensitive=FALSE;
}


void
on_find_textentry_activate             (GtkEditable     *editable,
                                        gpointer         user_data)
{
   static GtkWidget *find_button = NULL;

   if (!find_button)
      find_button = lookup_widget(main_window,"find_button");

   on_find_toolbar_button_clicked(GTK_BUTTON(find_button),NULL);	/* Fake click */
}


void
on_package_tree_tree_select_row        (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
   struct package_node *package_node;

   package_node = (struct package_node *)gtk_ctree_node_get_row_data(ctree,GTK_CTREE_NODE(node));
   link_selected_package(main_window,package_node);
}


void
on_package_tree_tree_unselect_row      (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
   struct package_node *package_node;

   package_node = (struct package_node *)gtk_ctree_node_get_row_data(ctree,GTK_CTREE_NODE(node));
   unlink_selected_package(package_node, 1);
}


void
on_package_tree_select_row             (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   struct package_node *package_node;

   if (event)
      if (event->type == GDK_2BUTTON_PRESS){	/* Doubleclick */
         package_node = (struct package_node *)gtk_clist_get_row_data(clist,row);
         if (package_node)
            package_tree_row_double_clicked_event(package_node);
      }
}


void
on_package_tree_unselect_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   /* Nothing */

}



const gchar *titles[6]={N_("Package Name"),
                        N_("Status"),
                        N_("Size"),
                        N_("Installed\nVersion"),
                        N_("Newest\nVersion"),
                        N_("Description")};

void
set_column_title(GtkCList *clist, gint c, const gchar *title){
    GtkLabel* label;
    label=(GtkLabel*)gtk_clist_get_column_widget(clist, c);
    gtk_label_set_justify(label, GTK_JUSTIFY_CENTER);
    gtk_label_set_text(label, title);
    }

void
on_package_tree_click_column           (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
   /* TODO FIXME: Sorting? */
    static gint c=-1;
    static GtkSortType st=GTK_SORT_ASCENDING;

    gchar title[40];

    if  (c==column){
        if  (st==GTK_SORT_ASCENDING){
            st=GTK_SORT_DESCENDING;
            strcpy(title, _(titles[c]));
            strcat(title, " (-)");
            set_column_title(clist, c, title);
            }
        else {
            st=GTK_SORT_ASCENDING;
            strcpy(title, _(titles[c]));
            strcat(title, " (+)");
            set_column_title(clist, c, title);
            }
        }
    else{
        if  (c!=-1)
            set_column_title(clist, c, _(titles[c]));

        c=column;
        strcpy(title, _(titles[c]));
        strcat(title, " (+)");
        set_column_title(clist, c, title);
        st=GTK_SORT_ASCENDING;
        }
    gtk_clist_set_sort_type(clist, st);
    gtk_clist_set_sort_column(clist, column);
    gtk_clist_sort(clist);
}


void
on_s_p_activate()
{
   static int f=1;                //when initial, set the stat will cause a single,
   if (f) {                       //so i should disable first time.
      f=0;
      return;
      }
   populate_package_tree_toggle_show_parameters(SHOW_PRIORITIES);
}


void
on_s_s_activate()
{
   static int f=1;              //when initial, set the stat will cause a single,
   if (f) {                     //so i should disable first time.
      f=0;
      return;
      }
   populate_package_tree_toggle_show_parameters(SHOW_SECTIONS);
}


void
on_dependency_clist_select_row         (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   struct package_node *package_node;

   if (event)
      if (event->type == GDK_2BUTTON_PRESS){	/* Doubleclick */
         package_node = (struct package_node *)gtk_clist_get_row_data(clist,row);
         if (package_node)
            package_list_row_double_clicked_event(package_node);
         return;
      }

   package_node = (struct package_node *)gtk_clist_get_row_data(clist,row);
   link_selected_package(dependency_window,package_node);
}


void
on_dependency_clist_unselect_row       (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   struct package_node *package_node;

   package_node = (struct package_node *)gtk_clist_get_row_data(clist,row);
   unlink_selected_package(package_node, 0);
}

const gchar *dtitles[6]={N_("Old\nStatus"),
                         N_("New\nStatus"),
                         N_("Priority"),
                         N_("Section"),
                         N_("Package Name"),
                         N_("Description")};

void
on_dependency_clist_click_column       (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
   /* FIXME fixme implement sorting */
    static gint dc=-1;
    static GtkSortType dst=GTK_SORT_ASCENDING;
    gchar dtitle[40];

    if  (dc==column){
        if  (dst==GTK_SORT_ASCENDING){
            dst=GTK_SORT_DESCENDING;
            strcpy(dtitle, _(dtitles[dc]));
            strcat(dtitle, " (-)");
            set_column_title(clist, dc, dtitle);
            }
        else {
            dst=GTK_SORT_ASCENDING;
            strcpy(dtitle, _(dtitles[dc]));
            strcat(dtitle, " (+)");
            set_column_title(clist, dc, dtitle);
            }
        }
    else{
        if  (dc!=-1)
            set_column_title(clist, dc, dtitles[dc]);

        dc=column;
        strcpy(dtitle, _(dtitles[dc]));
        strcat(dtitle, " (+)");
        set_column_title(clist, dc, dtitle);
        dst=GTK_SORT_ASCENDING;
        }
    gtk_clist_set_sort_type(clist, dst);
    gtk_clist_set_sort_column(clist, column);
    gtk_clist_sort(clist);
}


void
on_dr_install_toolbar_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
   mark_selected_dependency_resolver_packages(pkgCache::State::Install);//want_install);
}


void
on_dr_remove_toolbar_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
   mark_selected_dependency_resolver_packages(pkgCache::State::DeInstall);//want_deinstall);
}


void
on_dr_purge_toolbar_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
   mark_selected_dependency_resolver_packages(pkgCache::State::Purge);//want_purge);
}

void
on_dr_hold_toolbar_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
   mark_selected_dependency_resolver_packages(pkgCache::State::Hold);//want_hold);
}

void
on_dr_continue_toolbar_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
   free_dependency_nodes_and_optionally_copy_selections_out_to_main_nodes(TRUE);
   check_dependencies_and_interactively_resolve(&dependencies_input_anchor,dp_must);
}

void
on_dr_cancel_toolbar_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   close_dependency_window_and_optionally_copy_selections(FALSE);
}


void
on_close_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide(gtk_widget_get_toplevel(GTK_WIDGET(button)));
//   if (main_window_visible == 0)
//      gtk_exit(0);
}


void
on_update_activate()
{
   update_packages();
}

extern int gquit, gclean;

void
on_apply_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
   static GtkCheckButton *apply_and_quit_checkbutton = NULL;
   static GtkCheckButton *clean_deb_checkbutton = NULL;

   if (!apply_and_quit_checkbutton)
      apply_and_quit_checkbutton = GTK_CHECK_BUTTON(lookup_widget(apply_changes_window,"apply_and_quit_checkbutton"));
   if (!clean_deb_checkbutton)
      clean_deb_checkbutton = GTK_CHECK_BUTTON(lookup_widget(apply_changes_window,"clean_deb_checkbutton"));

   gclean=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(clean_deb_checkbutton)) == TRUE?1:0;
   gquit=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(apply_and_quit_checkbutton)) == TRUE?1:0;

   apply_changes_and_possibly_quit();
}

void
on_apply_cancel_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide(apply_changes_window);
}


gboolean
on_main_window_destroy_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   gtk_exit(0);
   /* NOTREACHED */
   return TRUE;
}


gboolean
on_dependency_window_destroy_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   /* Fake cancel button clicked */
   on_dr_cancel_toolbar_button_clicked(NULL,NULL);
   return TRUE;
}


gboolean
on_filter_window_destroy_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   gtk_widget_hide(gtk_widget_get_toplevel(GTK_WIDGET(widget)));
//   if (main_window_visible == 0)
//      gtk_exit(0);
   return TRUE;
}



gboolean
on_apply_changes_window_destroy_event  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   /* Fake cancel button clicked */
   on_apply_cancel_button_clicked(NULL,NULL);
   return TRUE;
}


void
on_about_activate()
{
   gtk_widget_show(create_about_window());
}



void
on_sources_activate()
{
   interactively_edit_sources_list();
}


void
on_help_activate()
{
    gtk_widget_show(help_window);
    gdk_window_raise(help_window->window);
}


void
on_sources_clist_select_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   struct source_line *source_line;

   if (event)
      if (event->type == GDK_2BUTTON_PRESS){	/* Doubleclick */
         source_line = (struct source_line *)gtk_clist_get_row_data(clist,row);
         if (source_line)
            sources_list_row_double_clicked_event(source_line);
         return;
      }

   source_line = (struct source_line *)gtk_clist_get_row_data(clist,row);
   if (source_line)
      link_selected_sources_line(source_line);
}


void
on_sources_clist_unselect_row          (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   struct source_line *source_line;

   source_line = (struct source_line *)gtk_clist_get_row_data(clist,row);
   if (source_line)
      unlink_selected_sources_line(source_line);
}


void
on_sources_clist_click_column          (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{

}


void
on_add_source_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
   add_sources_line();
}


void
on_update_source_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
   update_selected_sources_line();
}


void
on_remove_selected_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
   remove_selected_sources_line();
}


void
on_sources_ok_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
   ok_edit_sources_list();
}


void
on_sources_cancel_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
   cancel_edit_sources_list();
}


gboolean
on_sources_window_destroy_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   /* Fake cancel button clicked */
   on_sources_cancel_button_clicked(NULL,NULL);
   return TRUE;
}


gboolean
on_msg_ok_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_hide(msg_dlg);
    if  (msg_dlg_exit)
      gtk_exit(0);
   return TRUE;

}


void
on_help_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_hide(help_window);
}

