/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "DiffSummarizeLvi.h"
#include "svn/DiffSummarize.h"


static char* getSummarizeCode( svn::DiffSummarizeKind kind )
{
  switch( kind )
  {
  case svn::DiffSummarize_Normal:   return " ";
  case svn::DiffSummarize_Added:    return _("A");
  case svn::DiffSummarize_Modified: return _("M");
  case svn::DiffSummarize_Deleted:  return _("D");
  default:                          return _("?");
  }
}

static char* getNodCode( svn::NodeKind kind )
{
  switch( kind )
  {
  case svn::Node_Dir: return _("F");
  default:            return " ";
  }
}


DiffSummarizeLvi::DiffSummarizeLvi( QListView* parent, svn::DiffSummarizePtr summarize )
: super(parent), _summarize(summarize)
{
}

DiffSummarizeLvi::~DiffSummarizeLvi()
{
}

QString DiffSummarizeLvi::text( int column ) const
{
  switch( column )
  {
  case 0:
    {
      return getSummarizeCode(_summarize->getKind());
    }
  case 1:
    {
      return _summarize->hasPropChanges() ? _q("M") : "" ;
    }
  case 2:
    {
      return getNodCode(_summarize->getNodeKind());
    }
  case 3:
    {
      return QString::fromUtf8(_summarize->getName());
    }
  default:
    {
      return "";
    }
  }
}

QString DiffSummarizeLvi::key( int column, bool ascending ) const
{
  return text( column );
}

int DiffSummarizeLvi::compare( QListViewItem * i, int column, bool ascending ) const
{
  return super::compare(i,column,ascending);
}

svn::DiffSummarizePtr DiffSummarizeLvi::getDiffSummarize() const
{
  return _summarize;
}
