/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPERTIESDIALOG_H
#define _SC_PROPERTIESDIALOG_H

// sc
#include "util/String.h"
#include "svn/WcStatusTypes.h"
class WcModel;

// qt
#include <qdialog.h>
class QPushButton;
class QListView;
class QTextEdit;
class QComboBox;
class QCheckBox;
class QListViewItem;


class PropertiesDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  PropertiesDialog( WcModel* model, QWidget *parent = 0, const char *name=0 );
  virtual ~PropertiesDialog();

  void setSource( svn::WcStatusPtr status );

public slots:
  void pressed( QListViewItem* lvi );
  void newPropChanged(const QString& );
  void add();
  void del();
  void set();

private:
  void proplist();
  void addProperty( const QString& propName, const QString& propValue );

private:
  WcModel*         _model;

  svn::WcStatusPtr _status;
  sc::String       _source;

  QListView*       _props;
  QComboBox*       _newProp;
  QPushButton*     _add;
  QPushButton*     _del;

  QTextEdit*       _propValue;
  QCheckBox*       _recursive;
  QPushButton*     _set;

  QPushButton*     _close;
};

#endif // _SC_PROPERTIESDIALOG_H
