/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGINGEVENT_H
#define _SC_LOGGINGEVENT_H

// sc
#include "CustomEvents.h"
#include "LogData.h"

// qt
#include <qevent.h>

/**
 * Event class for logging.
 */
class LoggingEvent : public QCustomEvent
{
public:
  LoggingEvent( const LogData* data )
  : QCustomEvent(ScLoggingEvent), _data(data)
  {
  }

  bool isStart() const
  {
    return _data->isStart();
  }

  bool isStop() const
  {
    return _data->isStop();
  }

  bool isRunning() const
  {
    return _data->isRunning();
  }

  bool isTime() const
  {
    return _data->isTime();
  }

  bool isError() const
  {
    return _data->isError();
  }

  long getId() const
  {
    return _data->getId();
  }

  unsigned long getType() const
  {
    return _data->getType();
  }

  const LogData* getData() const
  {
    return _data;
  }

private:
  const LogData* _data;
};

#endif //  _SC_LOGGINGEVENT_H
