/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _LINETOKENIZER_TEST_H
#define _LINETOKENIZER_TEST_H

#include <cppunit/TestCase.h>

class LineTokenizerTest : public CppUnit::TestCase
{
public:
  LineTokenizerTest(); 
  virtual ~LineTokenizerTest();

  static CppUnit::Test *suite();

  void setUp();
  void tearDown();

  // Tests
  void testNoLine();
  void testEmptyLine();
  void testEmptyLines();
  void testSingleLine();
  void testSingleLineNoFinalLF();
  void testMultipleLines();
  void testMultipleLinesNoFinalLF();

  void testTokenStream();
  void testTokenStreamError();
  void testTokenStreamNoFinalLF();

  void testWriteStream();

private:
};

#endif // _LINETOKENIZER_TEST_H
