/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.BundlePermission;

final class BundlePermissionCollection
extends PermissionCollection {
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof BundlePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BundlePermission bp = (BundlePermission)permission;
        String name = bp.getName();
        BundlePermission existing = (BundlePermission)this.permissions.get(name);
        if (existing != null) {
            int newMask;
            int oldMask = existing.getMask();
            if (oldMask != (newMask = bp.getMask())) {
                this.permissions.put(name, new BundlePermission(name, oldMask | newMask));
            }
        } else {
            this.permissions.put(name, permission);
        }
        if (!this.all_allowed && name.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int last;
        BundlePermission x;
        if (!(permission instanceof BundlePermission)) {
            return false;
        }
        BundlePermission bp = (BundlePermission)permission;
        int desired = bp.getMask();
        int effective = 0;
        if (this.all_allowed && (x = (BundlePermission)this.permissions.get("*")) != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        String name = bp.getName();
        x = (BundlePermission)this.permissions.get(name);
        if (x != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf(".", offset)) != -1) {
            x = (BundlePermission)this.permissions.get(name = String.valueOf(name.substring(0, last + 1)) + "*");
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

