/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import org.eclipse.draw2d.graph.Edge;

public class EdgeList
extends ArrayList {
    public Edge getEdge(int index) {
        return (Edge)super.get(index);
    }

    public int getSourceIndex(int i) {
        return this.getEdge((int)i).source.index;
    }

    public int getTargetIndex(int i) {
        return this.getEdge((int)i).target.index;
    }

    public int getSlack() {
        int slack = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.size()) {
            slack = Math.min(slack, this.getEdge(i).getSlack());
            ++i;
        }
        return slack;
    }

    public int getWeight() {
        int w = 0;
        int i = 0;
        while (i < this.size()) {
            w += this.getEdge((int)i).weight;
            ++i;
        }
        return w;
    }

    public int calculateRank() {
        int rank = 0;
        int i = 0;
        while (i < this.size()) {
            Edge e = this.getEdge(i);
            rank = Math.max(rank, e.delta + e.source.rank);
            ++i;
        }
        return rank;
    }

    public boolean isCompletelyFlagged() {
        int i = 0;
        while (i < this.size()) {
            if (!this.getEdge((int)i).flag) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void resetFlags() {
        int i = 0;
        while (i < this.size()) {
            this.getEdge((int)i).flag = false;
            ++i;
        }
    }

    public void setFlags(boolean value) {
        int i = 0;
        while (i < this.size()) {
            this.getEdge((int)i).flag = value;
            ++i;
        }
    }
}

