/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell parent) {
        this(parent, 0);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int response;
        boolean success;
        byte[] buffer = Converter.wcsToMbcs(null, this.title, true);
        int handle = OS.gtk_color_selection_dialog_new((byte[])buffer);
        if (this.parent != null) {
            OS.gtk_window_set_transient_for((int)handle, (int)this.parent.topHandle());
        }
        GtkColorSelectionDialog dialog = new GtkColorSelectionDialog();
        OS.memmove((GtkColorSelectionDialog)dialog, (int)handle);
        GdkColor color = new GdkColor();
        if (this.rgb != null) {
            color.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
            color.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
            color.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
            OS.gtk_color_selection_set_current_color((int)dialog.colorsel, (GdkColor)color);
        }
        boolean bl = success = (response = OS.gtk_dialog_run((int)handle)) == -5;
        if (success) {
            OS.gtk_color_selection_get_current_color((int)dialog.colorsel, (GdkColor)color);
            int red = color.red >> 8 & 0xFF;
            int green = color.green >> 8 & 0xFF;
            int blue = color.blue >> 8 & 0xFF;
            this.rgb = new RGB(red, green, blue);
        }
        OS.gtk_widget_destroy((int)handle);
        if (!success) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

