/*
 * synaptiks -- a touchpad control tool
 *
 *
 * Copyright (C) 2009, 2010 Sebastian Wiesner <basti.wiesner@gmx.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include "mousedevicesview.h"
#include "mousedevicesmodel.h"
#include <KConfigDialogManager>


using namespace synaptiks;


MouseDevicesView::MouseDevicesView(QWidget *parent): QListView(parent) {
    MouseDevicesModel *model = new MouseDevicesModel(this);
    this->setModel(model);
    this->connect(
        model, SIGNAL(checkedDevicesChanged(const QStringList &)),
        SIGNAL(checkedDevicesChanged(const QStringList &)));
    // register the mouse devices view class with KConfig XT
    KConfigDialogManager::changedMap()->insert(
        "synaptiks::MouseDevicesView",
        SIGNAL(checkedDevicesChanged(const QStringList&)));
    KConfigDialogManager::propertyMap()->insert(
        "synaptiks::MouseDevicesView", "checkedDevices");

}

void MouseDevicesView::setCheckedDevices(const QStringList &devices) {
    qobject_cast<MouseDevicesModel *>(this->model())->
        setCheckedDevices(devices);
}

QStringList MouseDevicesView::checkedDevices() {
    return qobject_cast<MouseDevicesModel *>(this->model())->
        checkedDevices();
}

void MouseDevicesView::setTouchpadsIgnored(bool ignored) {
    qobject_cast<MouseDevicesModel *>(this->model())->
        setTouchpadsIgnored(ignored);
}

bool MouseDevicesView::touchpadsIgnored() const {
    return qobject_cast<MouseDevicesModel *>(this->model())->
        touchpadsIgnored();
}


#include "moc_mousedevicesview.cpp"
