from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_add_class = _Mock()

_check = _Mock()

_fill_form = _Mock()

_fill_multiple = _Mock()

_fill_single = _Mock()

_find_elements_for_name = _Mock()

_find_form = _Mock()

_find_form_ids = _Mock()

_form_name_xpath = _Mock()

_forms_xpath = _Mock()

_input_xpath = _Mock()

_insert_error = _Mock()

_label_for_xpath = _Mock()

_name_xpath = _Mock()

_nons = _Mock()

_options_xpath = _Mock()

_select = _Mock()

_takes_multiple = _Mock()

_transform_result = _Mock()

copy = _Mock()

default_error_creator = _Mock()

defs = _Mock()

fill_form = _Mock()

fill_form_html = _Mock()

fromstring = _Mock()

insert_errors = _Mock()

insert_errors_html = _Mock()

tostring = _Mock()

XHTML_NAMESPACE = 'http://www.w3.org/1999/xhtml'

_tag = 'x:textarea'

class DefaultErrorCreator(_Mock):
  pass
  block_inside = True
  default_message = 'Invalid'
  error_block_class = 'error-block'
  error_container_tag = 'div'
  error_message_class = 'error-message'
  insert_before = True

class ElementBase(_Mock):
  pass


class FormNotFound(_Mock):
  pass


class XPath(_Mock):
  pass


