#!/usr/bin/guile \
-e main -s
!#

;; Copyright (C) 2020 Tommi Höynälänmaa

;; Distributed under GNU Lesser General Public License v3.

(import (th-scheme-utilities stdutils))

(define (compute-deps l-sx)
  (let ((l-deps '()))
    (do ((l-sx-cur l-sx (cdr l-sx-cur))) ((null? l-sx-cur))
      (let ((sx-head (car l-sx-cur)))
	(if (and (list? sx-head)
		 (not-null? sx-head)
		 (eq? (car sx-head) 'import))
	    (let ((l-tail (cdr sx-head)))
	      (do ((l-sx-cur2 l-tail (cdr l-sx-cur2))) ((null? l-sx-cur2))
		(let ((l-sx-cur3 (car l-sx-cur2)))
		  (if (and (list? l-sx-cur3)
			   (= (length l-sx-cur3) 3)
			   (eq? (car l-sx-cur3) 'theme-d)
			   (eq? (cadr l-sx-cur3) 'translator))
		      (let ((s-dep (caddr l-sx-cur3)))
			(set! l-deps (append l-deps (list s-dep)))))))))))
    l-deps))

(define (print-output-deps str-name l-deps)
  (display (string-append str-name ".go :"))
  (for-each
   (lambda (s-dep)
     (display " \\\n  ")
     (display (string-append (symbol->string s-dep) ".go")))
   l-deps)
  (newline)
  (newline))

(define (main args)
  (let* ((str-name (cadr args))
	 (str-source (string-append str-name ".scm.in"))
	 (ip (open-input-file str-source))
	 (l-sx (read-file ip)))
    (close-input-port ip)
    (let ((l-deps (compute-deps l-sx)))
      (print-output-deps str-name l-deps))))
