/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2014 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PROCGSLSVDOCC_SEEN
#define PROCGSLSVDOCC_SEEN

double
ProcGSLSVDvanNu(const Cds *cds1, const Cds *cds2, double **rotmat,
                    double **Rmat, double **Umat, double **VTmat, double *sigma,
                    double *norm1, double *norm2, double *innprod);

double
ProcGSLSVDNu(const Cds *cds1, const Cds *cds2, double **rotmat,
                 const double *weights,
                 double **Rmat, double **Umat, double **VTmat, double *sigma);

double
ProcGSLSVDCovNu(Cds *cds1, Cds *cds2, double **rotmat,
                    const double **covmat,
                    double **Rmat, double **Umat, double **VTmat,
                    double *sigma);

double
ProcGSLSVDvanNu2(const double **cds1, const double **cds2, const int *nu, 
                 const int len, double **rotmat,
                 double **Rmat, double **Umat, double **VTmat, double *sigma,
                 double *norm1, double *norm2, double *innprod);

#endif
