/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef SEARCH_H_INCLUDED
#define SEARCH_H_INCLUDED

#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/checkbutton.h>
#include <gtk--/entry.h>
#include <gtk--/radiobutton.h>

#include "thoughttracker.h"
#include "linklist.h"

class TTApplication;

class TTSearchWidget : public Gtk::VBox {
  public:
    TTSearchWidget(TTApplication *application);
    virtual ~TTSearchWidget() {};

    /* tool bar button functionalities */
    virtual void btn_search();
    virtual void btn_show();
    virtual void btn_link();
    virtual void btn_add();
    virtual void btn_del();
    virtual void btn_clear();
    virtual void btn_active();
    virtual void btn_set_active();

    /* updates the widget's buttons */
    virtual void update_buttons();

    /* clears the widget's input fields */
    virtual void clear();

    /* updates the search list's display of the specified record, if
       appropriate */
    virtual void update_list_for(dbid_t);

    /* prepares widget state for it to be displayed */
    virtual void prepare_for_display() {
      update_buttons();
      w.text->grab_focus();
    };

  private:
    TTApplication *app;
    struct {  // relevant widgets
      Gtk::Entry *text;
      TTLinkList *list;
      Gtk::Entry *active;
      struct {
        Gtk::Widget *show, *del, *link;
        Gtk::Button *active, *set_active;
        Gtk::RadioButton *c_all, *l_and;
        Gtk::CheckButton *t_hub, *t_ent, *t_lnk, *t_iso;
      } b;  // buttons
    } w;
    Gtk::RadioButton_Helpers::Group contents, logic;
    dbid_t selected;  // selected entry's ID

    /* make [Return] on the search string entry cause an immediate search */
    gint handle_ss_return(GdkEventKey *event) {
      if (event->keyval == 0xff0d) btn_search();  // save #include <keysymdef.h>
      return 0;
    }

    /* make [Return] on the search results list show the selected entry */
    gint handle_srl_return(GdkEventKey *event) {
      if (event->keyval == 0xff0d && selected >= 0) btn_show();
      return 0;
    }

    /* reacts to the selection of a result list row */
    void handle_select_entry(gint, gint, GdkEvent*);

    /* likewise */
    void handle_unselect_entry(gint, gint, GdkEvent*);

    /* these react to entry type restriction options when unset */
    void handle_t_hub();
    void handle_t_ent();
    void handle_t_lnk();
    void handle_t_iso();
};

#endif  /* SEARCH_H_INCLUDED */

