#!/usr/bin/perl
#
while (<STDIN>) {

	if ( /sshd.*?: Failed password for (.*?) from ([\d\.\w]+) /) {
		$faileduser{$1}++;
		$failedlocation{$2}++;
		$failedlocuser{$2}{$1}++;
	}
	if ( /sshd.*?: Accepted password for (.*?) from ([\d\.\w]+) /) {
		$okuser{$1}++;
		$oklocation{$2}++;
		$oklocuser{$2}{$1}++;
	}
}

print "Bad login attempts per user\n";
print "---------------------------\n";
foreach $user ( sort { $faileduser{$a} <=> $faileduser {$b} } keys %faileduser ) {
	print "$faileduser{$user} wrong attempts from $user\n";
	if ( defined ($okuser{$user}) ) {
		print "\twith $okuser{$user} ok attempts\n";
	} else {
		print "\twith no ok attempts\n";
	}

}

print "Bad login attempts per location\n";
print "-------------------------------\n";
foreach $loc ( sort { $failedlocation{$a} <=> $failedlocation {$b} } keys %failedlocation ) {
	print "$failedlocation{$loc} wrong attempts with source $loc\n";
	if ( defined ( $oklocation{$loc} ) ) {
		print "\twith $oklocation{$loc} ok attempts\n";
	} else {
		print "\twith no ok attempts\n";
	}

}

print "Detailed user/location attempts\n";
print "-------------------------------\n";
foreach $loc ( sort { $failedlocation{$a} <=> $failedlocation {$b} } keys %failedlocation ) {
	print "Connections from $loc\n";
	foreach $user ( keys %{$failedlocuser{$loc}} ) {
		print "\t$failedlocuser{$loc}{$user} wrong attempts for $user\n";
	}
	foreach $user ( keys %{$oklocuser{$loc}} ) {
		print "\t$oklocuser{$loc}{$user} correct attempts for $user\n";
	}
}

exit 0;
