#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>

#include "entry_cb.h"
#include "entry_dbox.h"
#include "support.h"

#include "tilibs.h"
#include "struct.h"

static gint ret_val = 0;

/* Create the dialog box entry and wait */
char* dlgbox_entry(const char *title, 
		   const char *message, 
		   const char *content)
{
  GtkWidget *dbox = NULL;
  gpointer data;
  gchar *ret = NULL;
  gchar *s = NULL;
  GtkWidget *entry = NULL;

  ret_val = 0;
  dbox = create_entry_dbox();

  data = gtk_object_get_data(GTK_OBJECT(dbox), "entry_dbox");
  gtk_window_set_title (GTK_WINDOW(data), title);

  data = gtk_object_get_data(GTK_OBJECT(dbox), "frame1");
  gtk_frame_set_label(GTK_FRAME(data), message);

  data = gtk_object_get_data(GTK_OBJECT(dbox), "entry1");
  entry = GTK_WIDGET(data);
  gtk_entry_set_text(GTK_ENTRY(data), content);

  gtk_widget_show_all(dbox);

  while(!ret_val)
    {
      while( gtk_events_pending() ) { gtk_main_iteration(); }
    }

  switch(ret_val)
    {
    case 1:
      s = gtk_editable_get_chars(GTK_EDITABLE(entry), 0, -1);
      ret = g_strdup(s);
      break;
    case 2:
      ret=NULL;
      break;
    default:
      ret=NULL;
      break;
    }
  g_free(s);
  gtk_widget_destroy(dbox);
  
  return ret;  
}

void
entry_ok_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  ret_val = 1;
}


void
entry_cancel_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  ret_val = 2;
}

/* */
