/*  tilp - a linking program for TI graphing calculators
 *  Copyright (C) 1999-2002  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  This file includes libticables & libticalcs headers.
*/

#ifndef TILIBS_H
#define TILIBS_H

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_TILP_TYPEDEFS_H
# include <tilp/cabl_int.h>
# include <tilp/calc_int.h>
# include <tilp/defsxx.h>
# include <tilp/cabl_err.h> // to use ERR_RCV_BYT_TIMEOUT
# include <tilp/calc_err.h> // to use ERR_VOID_FUNCTION
# include <tilp/verbose.h>
#elif defined(__WIN32__)
# include "cabl_int.h"
# include "calc_int.h"
# include "defsxx.h"
# include "cabl_err.h"
# include "calc_err.h"
# include "const.h"
#elif defined(__MACOSX__)
# include <libticables/cabl_err.h>
# include <libticalcs/calc_err.h>
# include <libticalcs/calc_int.h>
#else
# include "cabl/cabl_int.h"
# include "calc/calc_int.h"
# include "calc/defsxx.h"
# include "calc/calc_err.h"
#endif

#ifdef HAVE_LIBTIFFEP
# if defined(__LINUX__)
#  include <tiffep/tiffep.h>
#  include <tiffep/tiffep_err.h>
# elif defined(__WIN32__)
#  include "tiffep.h"
#  include "tiffep_err.h"
# endif
#endif

#if defined(HAVE_LIBTIFFEP) && defined(ALLOW_TIFFEP_SERVER)
# define HAVE_TIFFEP
#endif

#endif
