/*
 * Copyright (C) 2004-2006 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "manage-presets-window.h"

/* for _() macro */
#include <libgnome/gnome-i18n.h>
#include "add-preset-dialog.h"
#include "layout-utils.h"
#include "presets-manager.h"

static void
on_preset_added (GtkWidget *presets_manager, gchar *preset_name, guint preset_duration, gpointer user_data)
{
	GlooPresets *gloo_presets;
	GtkTreeRowReference *new_row_ref;

	gloo_presets = (GlooPresets *)user_data;

	g_assert (gloo_presets != NULL);

	new_row_ref = gloo_presets_add_preset (gloo_presets,
										   preset_name,
										   preset_duration);
	presets_manager_select_row (presets_manager, new_row_ref);
}

static void
on_preset_edited (GtkWidget *presets_manager, GtkTreeRowReference *row_ref, gchar *preset_name, guint preset_duration, gpointer user_data)
{
	GlooPresets *gloo_presets;

	gloo_presets = (GlooPresets *)user_data;

	g_assert (gloo_presets != NULL);
	
	gloo_presets_update_preset (gloo_presets,
								row_ref,
								preset_name,
								preset_duration);
	
	presets_manager_select_row (presets_manager, row_ref);
}

static void
on_preset_deleted (GtkWidget *presets_manager, GtkTreeRowReference *row_ref, gpointer user_data)
{
	GlooPresets *gloo_presets;

	gloo_presets = (GlooPresets *)user_data;

	g_assert (gloo_presets != NULL);
	
	gloo_presets_remove_preset (gloo_presets,
								row_ref);
}

static void
on_manage_presets_response (GtkDialog *dialog, gint response, gpointer user_data)
{
	switch (response) {
		case GTK_RESPONSE_CLOSE:
			gtk_widget_hide (GTK_WIDGET (dialog));
			break;

		case GTK_RESPONSE_DELETE_EVENT:
			g_print ("manage presets dialog delete event\n");
			break;

		default:
			g_assert_not_reached ();
	}
}

GtkWidget *
manage_presets_window_new (GlooPresets *gloo_presets)
{
	GtkWidget *manage_presets_window;
	GtkWidget *vbox;
	GtkWidget *presets_group;
	GtkWidget *label;
	GtkWidget *presets_manager_widget;
	
	manage_presets_window = gtk_dialog_new_with_buttons (_("Manage Presets"),
														 NULL,
														 GTK_DIALOG_DESTROY_WITH_PARENT,
														 GTK_STOCK_CLOSE,
														 GTK_RESPONSE_CLOSE, NULL);

	g_object_set (G_OBJECT (manage_presets_window),
				"has-separator", FALSE,
				"border-width", 0,
				NULL);

	
	vbox = gtk_vbox_new (FALSE, 18);
	g_object_set (G_OBJECT (vbox), "border-width", 12, NULL);

	gtk_widget_ensure_style (manage_presets_window);
	g_object_set (G_OBJECT (GTK_DIALOG (manage_presets_window)->vbox), "border-width", 0, NULL);
	g_object_set (G_OBJECT (GTK_DIALOG (manage_presets_window)->action_area), "border-width", 12, NULL);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (manage_presets_window)->vbox), vbox, TRUE, TRUE, 0);
	gtk_widget_show (vbox);
	
	g_assert (gloo_presets != NULL);
	presets_manager_widget = presets_manager_new (GTK_TREE_MODEL (gloo_presets));
	label = gtk_label_new (_("<span weight=\"bold\">_Timer Presets</span>"));
	g_object_set (G_OBJECT (label),
				"use-markup", TRUE,
				"use-underline", TRUE,
				"mnemonic-widget", presets_manager_get_tree_view (presets_manager_widget),
				"xalign", 0.0,
				NULL);
	presets_group = create_group_box (label);
	
	presets_manager_set_preset_handlers (presets_manager_widget,
										 on_preset_added, gloo_presets,
										 on_preset_edited, gloo_presets,
										 on_preset_deleted, gloo_presets);
	
	group_box_add_row_full (presets_group, presets_manager_widget, TRUE, TRUE);
	gtk_box_pack_start (GTK_BOX (vbox), presets_group, TRUE, TRUE, 0);
	gtk_widget_show (label);
	gtk_widget_show (presets_manager_widget);
	gtk_widget_show (presets_group);
	
	g_signal_connect (G_OBJECT (manage_presets_window), "response", G_CALLBACK (on_manage_presets_response), NULL);
	g_signal_connect (G_OBJECT (manage_presets_window), "delete-event", G_CALLBACK (gtk_widget_hide_on_delete), NULL);

	return manage_presets_window;
}

void
manage_presets_window_open (GtkDialog *manage_presets_window)
{
	g_assert (manage_presets_window);
	gtk_window_present (GTK_WINDOW (manage_presets_window));
}
