#!/bin/sh

# genxipx.sh --- a shell script for producing XIPX parameter files.
# 
# 1996/06/24 first version
#

AWK=gawk

DATE="2001/12/31"
VERSION="1.1"

PARAMFILE="xipaprm.def"

FILES="xipx10 xipxsl10 xipxb10 xipxbs10 xipxss10 xipxsi10 xipxsb10"

for FNAME in $FILES
do
  case "$FNAME" in
    xipx10)   NUM=3;FID="XIPX";  FSIZE="10";FDESC="Roman 10" ;;
    xipxsl10) NUM=4;FID="XIPXSL";FSIZE="10";FDESC="Slanted Roman 10" ;;
    xipxb10)  NUM=5;FID="XIPXB"; FSIZE="10";FDESC="Bold Roman 10" ;;
    xipxbs10) NUM=6;FID="XIPXBS";FSIZE="10";FDESC="Bold Slanted Roman 10" ;;
    xipxss10) NUM=7;FID="XIPXSS";FSIZE="10";FDESC="Sans Serif 10" ;;
    xipxsi10) NUM=8;FID="XIPXSI";FSIZE="10";FDESC="Sans Serif Slanted 10" ;;
    xipxsb10) NUM=9;FID="XIPXSB";FSIZE="10";FDESC="Sans Serif Bold 10" ;;
  esac

  echo "% $FNAME.mf: XIPX $FDESC point parameter file" > $FNAME.mf
  echo "%   Version $VERSION $DATE FUKUI Rei" >> $FNAME.mf
  echo '% This file is based on:' >> $FNAME.mf
  echo '%   Computer Modern font series by D. E. Knuth and' >> $FNAME.mf
  echo '%   TSIPA by KOBAYASHI Hajime, FUKUI Rei and SHIRAKAWA Shun.' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'if unknown cmbase: input cmbase fi' >> $FNAME.mf
  echo 'if unknown tipabase: input tipabase fi' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo "font_identifier:=\"$FID\"; font_size ${FSIZE}pt#;" >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'Times_Compat:=true;' >> $FNAME.mf
  echo 'if Times_Compat: input tipatr fi' >> $FNAME.mf
  echo '' >> $FNAME.mf
  $AWK "{if (\$1 == \"p\") {
     if (\$$NUM == \"0\") print \$2 \"#:=\" \$$NUM \"pt#;\";\
     else print \$2 \"#:=\" \$$NUM \"/36pt#;\";\
   }\
   else if (\$1 == \"P\") print \$2 \"#:=\" \$$NUM \"pt#;\";\
   else if (\$1 == \"n\") print \$2 \":=\"  \$$NUM \";\";}" $PARAMFILE |\
  sed 's/SQ/sqrt/' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'generate tipx    % switch to the driver file' >> $FNAME.mf
done

exit 0
