/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Sep 23 14:01:58 MEST 1999
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/




#include "main.h"
#include "info.h"
#include "optionen.h"
#include "auswahl.h"

#include <wx/fontdlg.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


// Icon

#if defined(__WXGTK__) || defined(__WXMOTIF__)
    #include "logo.xpm"
#endif


BEGIN_EVENT_TABLE(Hauptfenster, wxFrame)
  EVT_MENU(Hilfe_Info,  Hauptfenster::OnHilfe_Info)
  EVT_MENU(D_Beenden, Hauptfenster::OnD_Beenden)
  EVT_MENU(D_LektionBeenden, Hauptfenster::OnD_LBeenden)
  EVT_MENU(D_LPause, Hauptfenster::OnD_LektionPause)
  EVT_MENU(D_KBeginnen, Hauptfenster::OnD_KursBeginnen)
  EVT_MENU(D_KLaden, Hauptfenster::OnD_KursLaden)
  EVT_MENU(D_KAbbrechen, Hauptfenster::OnD_KursAbbrechen)
  EVT_MENU(D_LektionLaden, Hauptfenster::OnLektionLaden)
  EVT_MENU(O_Einstellungen, Hauptfenster::OnO_Einstellungen)
  EVT_MENU(O_Schriftwaehlen, Hauptfenster::OnO_Schriftwaehlen)
  EVT_SIZE(Hauptfenster::OnSize)

END_EVENT_TABLE()


IMPLEMENT_APP(tipptrainer)

  //***************************************************************************
  //*     tipptrainer:OnInit() Programmstart
  //***************************************************************************
bool tipptrainer::OnInit()
{
  SetVendorName("Pingos");
  SetAppName("Tipptrainer");
  wxConfigBase *pConfig = wxConfigBase::Get();
  // Internationalisierung
  wxString language = pConfig->Read("/Sprache/Sprache", "deutsch");
  wxString langid = pConfig->Read("/Sprache/SprachID", "de");
  m_locale.AddCatalogLookupPathPrefix(DATADIR);
  // m_local.Init(language, langid, "C");
  // hab ich gendert, da es irgendwie zu Problemen mit der
  // Darstellung von Umlauten kam. Wenn statt "C" ein "" darsteht,
  // werden bei mir die Umlaute korrekt angezeigt.
  m_locale.Init(language, langid, "");
  m_locale.AddCatalog("tipptrainer");
  Hauptfenster *h = new Hauptfenster(); 
  h->Show(TRUE);
  SetTopWindow(h);
  return TRUE;
};

int tipptrainer::OnExit()
{
  delete wxConfigBase::Set((wxConfigBase *) NULL);
  return 0;
}

//*****************************************************************************
//* Hauptfenster::Hauptfenster(..) Konstruktor des Hauptfensters
//*
//*
//*****************************************************************************

Hauptfenster::Hauptfenster()
  :  wxFrame((wxFrame *) NULL, -1, "PingoS Tipptrainer 0.1")
{
  SetIcon(wxICON(logo));
  wxString t;
  t << "PingoS Tipptrainer " << VERSION;
  SetTitle(t);
  // Konfigdatei lesen
  wxConfigBase *pConfig = wxConfigBase::Get();
  int x = pConfig->Read("/Hauptfenster/x", 50),
    y = pConfig->Read("/Hauptfenster/y", 50),
    w = pConfig->Read("/Hauptfenster/w", 750),
    h = pConfig->Read("/Hauptfenster/h", 500);
  Move(x, y);
  SetSize(w, h);

  // ****************************************** 
  // *Menus erzeugen
  // ******************************************
  MainMenu = new wxMenuBar;
  HilfeMenu = new wxMenu;
  DateiMenu = new wxMenu;
  //BearbeitenMenu = new wxMenu;
  OptionenMenu = new wxMenu;
  
  DateiMenu->Append(D_LektionLaden, _("Lektion &laden..."));
  DateiMenu->Append(D_LektionBeenden, _("Lektion &abbrechen"));
  // Es ist noch keine Lektion geladen, daher Menpunkt disablen
  DateiMenu->Enable(D_LektionBeenden, FALSE);
  DateiMenu->AppendSeparator();
  DateiMenu->Append(D_LPause, _("Lektion &unterbrechen..."));
  // dito
  DateiMenu->Enable(D_LPause, FALSE);
  DateiMenu->AppendSeparator();
  DateiMenu->Append(D_KBeginnen, _("Kurs &beginnen..."));
  DateiMenu->Append(D_KLaden, _("&Kurs laden..."));
  DateiMenu->Append(D_KAbbrechen, _("Kurs abbrechen"));
  //dito
  DateiMenu->Enable(D_KAbbrechen, FALSE);
  DateiMenu->AppendSeparator();
  DateiMenu->Append(D_Beenden, _("Be&enden\tAlt+X"), _("Beendet das Programm"));
  
  //BearbeitenMenu->Append(0, _("&Kopieren\tStrg+C"), _("Kopieren"));
  
  OptionenMenu->Append(O_Einstellungen, _("&Einstellungen..."));
  OptionenMenu->Append(O_Schriftwaehlen, _("&Schrift auswhlen..."));
  HilfeMenu->Append(Hilfe_Info, _("In&fo.."), _("Zeige Info Fenster"));
  
  MainMenu->Append(DateiMenu, _("&Datei"));
  //MainMenu->Append(BearbeitenMenu, _("&Bearbeiten"));
  MainMenu->Append(OptionenMenu, _("&Optionen"));
  MainMenu->Append(HilfeMenu, _("&Hilfe"));
  
  // Menubar dem Hauptfenster zuweisen
  SetMenuBar(MainMenu);
  // Statusbar erzeugen
  CreateStatusBar(4);
  int i[4]={-1, 100, 110, 100};
  SetStatusWidths(4, i);
  // Statusbartext setzten
  SetStatusText(_("Willkommen im TippTrainer, dem ultimativen Maschinenschreiblernprogramm! "));
  SetStatusText("", 1);
  SetStatusText(_("Richtig/Falsch"),2);
  SetStatusText(_("Zeit"),3);
  // Toolbar
  CreateToolBar( wxTB_HORIZONTAL | wxTB_FLAT , -1);
  // SplitterWindow erzeugen
  sw = new wxSplitterWindow(this, 1);
  output  = new wxOutputControl(sw);
  input = new wxInputControl(sw);
  wxSize s = this->GetClientSize();
  sw->SplitHorizontally(output, input, pConfig->Read("/Hauptfenster/s", (s.y /2)));
  // Lektion erzeugen bzw. Laden
  Show(TRUE);
  input->SetFocus();
  Auswahldialog* ad;
  ad = new Auswahldialog(this, -1, "PingoS Tipptrainer", wxDefaultPosition, wxSize(400, 240));
  ad->Centre();
  m_lektion = 0;
  m_kurs = 0;
  switch (ad->ShowModal())
    {
    case LL:
      m_lektion = new Lektion(this, 0);
      if (m_lektion->GetGeladen()==false)
	{
	  delete m_lektion;
	  m_lektion = 0;
	}
      else
	{
	  DateiMenu->Enable(D_KAbbrechen, FALSE);
	  DateiMenu->Enable(D_KBeginnen, FALSE);
	  DateiMenu->Enable(D_KLaden, FALSE);
	}
      break;
    case KL:
      try
	{
	  m_kurs = new Kurs(this, false);
	  DateiMenu->Enable(D_KAbbrechen, TRUE);
	  DateiMenu->Enable(D_LektionLaden, FALSE);
	  DateiMenu->Enable(D_LektionBeenden, FALSE);
	}
      catch (Abbruch)
	{
	  m_kurs = 0;
	}
      break;
    case KB:
      try
	{
	  m_kurs = new Kurs(this);
	  DateiMenu->Enable(D_KAbbrechen, TRUE);
	  DateiMenu->Enable(D_LektionLaden, FALSE);
	  DateiMenu->Enable(D_LektionBeenden, FALSE);
	}
      catch(Abbruch)
	{
	  m_kurs = 0;
	}      
      break;
    };
  ad->Destroy();
}


//**********************************************************************************
//* Hauptfenster::~Hauptfenster() - Destruktor des Hauptfensters
//**********************************************************************************

Hauptfenster::~Hauptfenster()
{
  // Desktruktor
  wxConfigBase *pConfig = wxConfigBase::Get();
  // save the frame position
  int x, y, w, h, s;
  GetSize(&w, &h);
  GetPosition(&x, &y);
  s = sw->GetSashPosition();
  pConfig->Write("/Hauptfenster/x", (long) x);
  pConfig->Write("/Hauptfenster/y", (long) y);
  pConfig->Write("/Hauptfenster/w", (long) w);
  pConfig->Write("/Hauptfenster/h", (long) h);
  pConfig->Write("/Hauptfenster/s", (long) s);
  if (m_kurs !=0)
    {
      m_kurs->KursAbbrechen();
      delete m_kurs;
      m_kurs = 0;
    }
  else
    {
      if (m_lektion !=0)
	{
	  delete m_lektion;
	  m_lektion = 0;
	}
    }
}


//**********************************************************************************
//* Hauptfenster:OnHilfe_Info(..) - Informationen ber das Programm anzeigen
//**********************************************************************************
void Hauptfenster::OnHilfe_Info(wxCommandEvent& event)
{
	Info_Dialog* id;
	id = new Info_Dialog(this, -1, _("ber den Tipptrainer"), wxDefaultPosition, wxSize(530, 300));
	id->Centre();
	id->ShowModal();
	id->Destroy();
}

//***********************************************************************************
//* Hauptfenster::OnD_Beenden(..) - Programm ber Datei | Beenden beenden
//***********************************************************************************


void Hauptfenster::OnD_Beenden(wxCommandEvent& event)
{
  Close();
}

//***********************************************************************************
//* Hauptfenster::OnD_LBeenden(..) - Lektion ber Datei | Lektion abbrechen abbrechen
//***********************************************************************************

void Hauptfenster::OnD_LBeenden(wxCommandEvent& event)
{
  m_lektion->LektionAbbrechen();
  delete m_lektion;
  m_lektion = 0;
  DateiMenu->Enable(D_KBeginnen, TRUE);
  DateiMenu->Enable(D_KLaden, TRUE);  
}

//***********************************************************************************
//* Hauptfenster::OnD_LektionPause() - Lektion kurz unterbrechen
//***********************************************************************************

void Hauptfenster::OnD_LektionPause(wxCommandEvent& event)
{
  m_lektion->Pause();
}

//***********************************************************************************
//* Hauptfenster::OnSize(..) - Reaktion auf Grennderung
//***********************************************************************************

void Hauptfenster::OnSize(wxSizeEvent& event)
{
  event.Skip();
}

//***********************************************************************************
//* Hauptfenster::OnLektionLaden(wxCommandEvent& event) - neue Lektion laden
//***********************************************************************************

void Hauptfenster::OnLektionLaden(wxCommandEvent& event)
{
  DateiMenu->Enable(D_KBeginnen, FALSE);
  DateiMenu->Enable(D_KLaden, FALSE);
   if (m_lektion!=0)
    {
      // Es ist zwar noch ein Lektionsobjekt vorhanden, aber eine Lektion ist nicht mehr geladen.
      // Deshalb ist die nchste if Anweisung noch ntig, damit es auch funktioniert, wenn eine Lektion
      // beendet wurde, dann aber die Lektionsauswahl abgebrochen wurde.
      if (m_lektion->GetGeladen()==false)
	{
	  DateiMenu->Enable(D_KBeginnen, TRUE);
	  DateiMenu->Enable(D_KLaden, TRUE);
	  DateiMenu->Enable(D_LektionBeenden, FALSE);
	  DateiMenu->Enable(D_LPause, FALSE);
	  delete m_lektion;
	  m_lektion = 0;
	  m_lektion = new Lektion(this, 0);
	  if (m_lektion->GetGeladen()==false)
	    {
	      delete m_lektion;
	      m_lektion = 0;
	      DateiMenu->Enable(D_KBeginnen, TRUE);
	      DateiMenu->Enable(D_KLaden, TRUE);
	    }
	  return;
	}
      int answer = wxMessageBox(_("Es ist bereits eine Lektion geladen. Lektion abbrechen und neue Lektion laden ?"), 
			    "Abbrechen?", wxYES_NO, this);
      if (answer == wxYES)
	{
	  delete m_lektion;
	  m_lektion = 0;
	  m_lektion = new Lektion(this, 0);
	  if (m_lektion->GetGeladen()==false)
	    {
	      delete m_lektion;
	      m_lektion = 0;
	      DateiMenu->Enable(D_KBeginnen, TRUE);
	      DateiMenu->Enable(D_KLaden, TRUE);
	    }
	}
    }
  else
    {
      m_lektion = new Lektion(this, 0);
      if (m_lektion->GetGeladen()==false)
	{
	  delete m_lektion;
	  m_lektion = 0;
	  DateiMenu->Enable(D_KBeginnen, TRUE);
	  DateiMenu->Enable(D_KLaden, TRUE);
	}
    }


}

//*******************************************************
//* Hauptfenster::OnO_Einstellungen
//*******************************************************

void Hauptfenster::OnO_Einstellungen(wxCommandEvent& event)
{
  ODialog* od;
  od = new ODialog(this);
  od->Center();
  if (od->ShowModal()==GEAENDERT)
    {
      wxMessageBox(_("Damit Sie die neuen Spracheinstellungen benutzen knnen, mssen Sie das Programm neu starten"), 
      		    _("Achtung!"), wxOK, this);
    };
  
  od->Destroy();
}

//********************************************************
//* Hauptfenster::OnD_KursLaden
//********************************************************

void Hauptfenster::OnD_KursLaden(wxCommandEvent& event)
{
  if (m_kurs !=0)
    {
       int answer = wxMessageBox(_("Es ist bereits ein Kurs geladen. Soll der aktuelle Kurs abbgebrochen und ein neuer begonnen werden?"),
				_("Es ist bereits ein Kurs geladen"), wxYES_NO, this);
      if (answer==wxYES)
	{
	  m_kurs->KursAbbrechen();
	  delete m_kurs;
	  m_kurs = 0;
	  DateiMenu->Enable(D_KAbbrechen, FALSE);
	  DateiMenu->Enable(D_LektionLaden, TRUE);
	  DateiMenu->Enable(D_LektionBeenden, FALSE);
	}
    }
  try
    {
      m_kurs = new Kurs(this, false);
      DateiMenu->Enable(D_KAbbrechen, TRUE);
      DateiMenu->Enable(D_LektionLaden, FALSE);
      DateiMenu->Enable(D_LektionBeenden, FALSE);
    }
  catch(Abbruch)
    {
      m_kurs = 0;
      DateiMenu->Enable(D_KAbbrechen, FALSE);
      DateiMenu->Enable(D_LektionLaden, TRUE);
      DateiMenu->Enable(D_LektionBeenden, FALSE);
    }
}

//********************************************************
//* Hauptfenster::OnD_KursBeginnen
//********************************************************

void Hauptfenster::OnD_KursBeginnen(wxCommandEvent& event)
{
   if (m_kurs == 0)
    {
      try
	{
	  m_kurs = new Kurs(this);
	  DateiMenu->Enable(D_KAbbrechen, TRUE);
	  DateiMenu->Enable(D_LektionLaden, FALSE);
	  DateiMenu->Enable(D_LektionBeenden, FALSE);
	}
      catch(Abbruch)
	{
	  m_kurs = 0;
	  DateiMenu->Enable(D_KAbbrechen, FALSE);
	  DateiMenu->Enable(D_LektionLaden, TRUE);
	  DateiMenu->Enable(D_LektionBeenden, FALSE);
	}
      
      
    }
   else
     {
      int answer = wxMessageBox(_("Es ist bereits ein Kurs geladen. Soll der aktuelle Kurs abbgebrochen und ein neuer begonnen werden?"),
				_("Es ist bereits ein Kurs geladen"), wxYES_NO, this);
      if (answer==wxYES)
	{
	  m_kurs->KursAbbrechen();
	  delete m_kurs;
	  m_kurs = 0;
	  try
	    {
	      m_kurs = new Kurs(this);
	      DateiMenu->Enable(D_KAbbrechen, TRUE);
	      DateiMenu->Enable(D_LektionLaden, FALSE);
	      DateiMenu->Enable(D_LektionBeenden, FALSE);
	    }
	  catch( Abbruch )
	    {
	      m_kurs = 0;
	      DateiMenu->Enable(D_KAbbrechen, FALSE);
	      DateiMenu->Enable(D_LektionLaden, TRUE);
	      DateiMenu->Enable(D_LektionBeenden, FALSE);
	    }
	}
    }
  
}

//********************************************************
//* Hauptfenster::OnD_KursAbbrechen
//********************************************************

void Hauptfenster::OnD_KursAbbrechen(wxCommandEvent& event)
{
  m_kurs->KursAbbrechen();
 delete m_kurs;
 m_kurs = 0;
 DateiMenu->Enable(D_KAbbrechen, FALSE);
 DateiMenu->Enable(D_LektionLaden, TRUE);
 DateiMenu->Enable(D_LektionBeenden, FALSE);
}

void Hauptfenster::KursEnde()
{
  m_kurs->KursAbbrechen();
  delete m_kurs;
  m_kurs = 0;
  DateiMenu->Enable(D_KAbbrechen, FALSE);
  DateiMenu->Enable(D_LektionLaden, TRUE);
  DateiMenu->Enable(D_LektionBeenden, FALSE);
}

//*******************************************************
//*
//*******************************************************

bool Hauptfenster::SetLektion(Lektion* lektion)
{
  m_lektion = lektion;
  return true;
}

//*******************************************************
//* Schrift whlen
//*******************************************************

void  Hauptfenster::OnO_Schriftwaehlen(wxCommandEvent& event)
{
  wxFontData data;
  data.SetInitialFont(input->GetFont());
  wxFontDialog dialog(this, &data);
  GtkWidget* gtkctrl = dialog.GetConnectWidget();
  gtk_font_selection_dialog_set_font_name((GtkFontSelectionDialog*)gtkctrl, input->GetGTKFont());
  if ( dialog.ShowModal() == wxID_OK )
    {
      wxString fontname =  gtk_font_selection_dialog_get_font_name((GtkFontSelectionDialog*)gtkctrl);
      input->SetGTKFont(fontname);
      output->SetGTKFont(fontname);
    }
}
