# $Id: ibb.tcl,v 1.3 2005/04/06 23:55:13 aleksey Exp $

namespace eval ibb {}

set ::NS(ibb) http://jabber.org/protocol/ibb

proc ibb::connect {connid jid sid} {
    variable connection

    set_status [::msgcat::mc "Opening IBB connection"]

    jlib::send_iq set \
	[jlib::wrapper:createtag open \
	     -vars [list xmlns $::NS(ibb) \
			sid $sid \
			block-size 4096]] \
	-to $jid \
	-command [list [namespace current]::recv_connect_response \
		      $connid $jid $sid]
	 
    vwait [namespace current]::connection(status,$sid)
    return $connection(status,$sid)
}

proc ibb::recv_connect_response {connid jid sid res child} {
    variable connection

    if {$res != "OK"} {
	set connection(status,$key) [list 0 [error_to_string $child]]
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set connection(connid,$sid) $connid
    set connection(jid,$sid) $jid
    set connection(seq,$sid) 0
    set connection(status,$sid) 1
}

package require base64

proc ibb::send_data {sid data} {
    variable connection

    jlib::send_msg $connection(jid,$sid) \
	-xlist [list [jlib::wrapper:createtag data \
			  -vars [list xmlns $::NS(ibb) \
				     sid $sid \
				     seq $connection(seq,$sid)] \
			  -chdata [base64::encode $data]]] \
	-connection $connection(connid,$sid)

    set connection(seq,$sid) [expr {($connection(seq,$sid) + 1) % 65536}]

    return 1
}


proc ibb::close {sid} {
    variable connection

    jlib::send_iq set \
	[jlib::wrapper:createtag close \
	     -vars [list xmlns $::NS(ibb) \
			sid $sid]] \
	-to $connection(jid,$sid) \
	-connection $connection(connid,$sid)
}

proc ibb::iq_set_handler {connid from child} {
    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set sid [jlib::wrapper:getattr $vars sid]

    switch -- $tag {
	open {
	    # TODO
	}
	close {
	    si::closed $sid
	}
    }


    return [list result ""]
}

iq::register_handler set "" $::NS(ibb) [namespace current]::ibb::iq_set_handler

proc ibb::message_handler {connid from id type is_subject subject body \
				 err thread priority x} {
    foreach item $x {
	jlib::wrapper:splitxml $item tag vars isempty chdata children
	set xmlns [jlib::wrapper:getattr $vars xmlns]
	if {[string equal $xmlns $::NS(ibb)]} {
	    set sid [jlib::wrapper:getattr $vars sid]
	    # TODO: seq processing
	    set seq [jlib::wrapper:getattr $vars seq]
	    set data $chdata

	    if {[catch {set decoded [base64::decode $data]}]} {
		# TODO
		debugmsg si "IBB: WRONG DATA"
	    } else {
		debugmsg si "IBB: RECV DATA [list $data]"
		si::recv_data $sid $decoded
	    }
	    return stop
	}
    }
}

hook::add process_message_hook [namespace current]::ibb::message_handler 50


si::register_transport $::NS(ibb) $::NS(ibb) 75 \
    [namespace current]::ibb::connect \
    [namespace current]::ibb::send_data \
    [namespace current]::ibb::close


