	!
	! 12/31/96
	! A.B. Maccabe
	!
	! read 10 characters from the UART and send them back to the UART
	! -- no buffering, quit if we get an overrun
	!


	UARTSTATUS	= 0X140000 
	UARTCREG	= 0x140000
	UARTTXREG	= 0x140004
	UARTRXREG	= 0x140004

	NCHARS		= 30

	.data
ovr_msg:	.asciz	"Overrun error detected, quit\n"
	
	.text
	.global start
	
start:	
	set	UARTSTATUS, %l0

	! set the UART control register -- disable interrupts and set the
	! rx/tx rate fairly low
	set	0x40, %l2
	st	%l2, [%l0]

	set	NCHARS, %l2
	
top:
	! wait for a character to appear
poll_rcv:	
	ld	[%l0], %l1
	! check for overrun error
	andcc	%l1, 4, %g0
	be	chk_rcv
	nop

	! overrun -- print a message and exit
	set	ovr_msg, %o0
	ta	6
	ta	0

chk_rcv:
	! check for a received character
	andcc	%l1, 2, %g0
	be	top
	nop
		
	! get the character
	ld	[%l0 + 4], %l3

	! wait for transmit reg empty
poll_snd:
	ld	[%l0], %l1
	andcc	%l1, 1, %g0
	be	poll_snd
	nop

	! send the character to the UART
	st	%l3, [%l0+4]

	deccc	%l2
	bne	top
	nop

	ta	0
