// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include "Dictionary.h"

namespace Torch {

Dictionary::Dictionary()
{
}

Dictionary::Dictionary(char* filename, char** phonemes_, int n_phonemes_)
{
  n_phonemes = n_phonemes_;
  phonemes = phonemes_;

  // default value
  silence_word = -1;

  // first count the number of words
  FILE *f=fopen(filename,"r");
  if (!f)
    error("file %s cannot be open",filename);
  n_words = 0;
  int line_len = 300;
  char line[300];
  fgets(line,line_len,f);
  while (!feof(f)) {
    n_words++;
    fgets(line,line_len,f);
  }
  fclose(f);

  // then create structure
  word_length = (int*)xalloc(sizeof(int)*n_words);
  words = (int**)xalloc(sizeof(int*)*n_words);
  words_string = (char**)xalloc(sizeof(char*)*n_words);

  // and populate it
  f=fopen(filename,"r");
  if (!f)
    error("file %s cannot be open",filename);
  char* value[300];
  int i,n;
  fgets(line,line_len,f);
  n = 0;
  while (!feof(f)) {
    value[0] = strtok(line," \n\t");
    for (i=1;(value[i] = strtok(NULL," \n\t"));i++);
    word_length[n] = i-1;
    words[n] = (int*)xalloc(sizeof(int)*(i-1));
    words_string[n] = (char*)xalloc(sizeof(char)*(strlen(value[0])+1));
    strcpy(words_string[n],value[0]);
    for (int j=0;j<i-1;j++) {
      // find phone in phoneme list
      int phone_index = -1;
      for (int k=0;k<n_phonemes;k++) {
        if (!strcmp(value[j+1],phonemes[k])) {
          phone_index = k;
          break;
        }
      }
      if (phone_index == -1)
        error("phone %s is not in phoneme list",value[j+1]);
      words[n][j] = phone_index;
    }
    fgets(line,line_len,f);
    n++;
  }
  fclose(f);
}

int Dictionary::findWord(char* word)
{
  int index = -1;
  for (int i=0;i<n_words;i++) {
    if (!strcmp(word,words_string[i])) {
      index = i;
      break;
    }
  }
  return index;
}

int Dictionary::findPhoneme(char* phoneme)
{
  int index = -1;
  for (int i=0;i<n_phonemes;i++) {
    if (!strcmp(phoneme,phonemes[i])) {
      index = i;
      break;
    }
  }
  return index;
}

Dictionary::~Dictionary()
{
  for (int i=0;i<n_words;i++) {
    free(words[i]);
    free(words_string[i]);
  }
  free(word_length);
  free(words);
  free(words_string);
}


}

