// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MULTINOMIAL_INC
#define MULTINOMIAL_INC

#include "Distribution.h"

namespace Torch {

/** This class can be used to model Multinomial Distributions.
    They can be trained using either EM (with EMTrainer) or gradient descent
    (with GMTrainer).

    @author Samy Bengio (bengio@idiap.ch)
*/
class Multinomial : public Distribution
{
  public:
    /// the number of different values that can take this discrete distribution
    int n_values;
    /// the prior weight given to each value. kind of smoother
    real prior_weights;

    /// optional initialization parameters
    List* initial_params;
    /// optional initialization file
    char* initial_file;

    /// the pointers to the parameters
    real* log_weights;

    /// the pointers to the d_parameters
    real* dlog_weights;

    /// accumulators for EM
    real*  weights_acc;

    Multinomial(int n_values_,real prior_weights_);

    virtual void reset();
    virtual int numberOfParams();
    virtual void allocateMemory();
    virtual void freeMemory();

    virtual void eMIterInitialize();
    virtual void iterInitialize();

    virtual real frameLogProbability(real *observations, real *inputs, int t);

    virtual void sequenceInitialize(List* inputs);
    virtual void eMSequenceInitialize(List* inputs);
    virtual void frameEMAccPosteriors(real *observations, real log_posterior, real *inputs, int t);
    virtual void eMUpdate();

    virtual void frameBackward(real *observations, real *alpha, real *inputs, int t);
    virtual void frameExpectation(real *observations, real *inputs, int t);

    virtual ~Multinomial();
};


}

#endif
