// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef CLASS_MEASURER_INC
#define CLASS_MEASURER_INC

#include "Measurer.h"
#include "DataSet.h"
#include "ClassFormat.h"

namespace Torch {

/** Compute the classification error (in %)
    of the #inputs# with respect to the #targets# of #data#.

    The format of the class is given with a #ClassFormat#.

    #measure# = {<[real] error proportion>, <[real] current number of errors>}

    If the option "confusion matrix" is set, there is
    {<[n_classes**2 int] confusion matrix>, <[n_classes**2 int] current confusion matrix>}
    after that.

    Options:
    \begin{tabular}{lcll}
      "confusion matrix"  &  bool  &  compute the confusion matrix & [false]
    \end{tabular}

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class ClassMeasurer : public Measurer
{
  public:
    real *erreur;
    real *erreur_c;
    int **confusion;
    int **confusion_c;
    List *inputs;
    ClassFormat *class_format;
    bool calc_confusion;
    int n_classes;

    //-----

    ///
    ClassMeasurer(List *inputs_, DataSet *data_, ClassFormat *class_format_, FILE *file_);
    ///
    ClassMeasurer(List *inputs_, DataSet *data_, ClassFormat *class_format_, const char *filename);

    //-----

    virtual void init();
    virtual void reset();
    virtual void measureEx();
    virtual void measureIter();
    virtual void measureEnd();

    virtual ~ClassMeasurer();
};


}

#endif
