/* wmgeneral.c -- Routines which most of the WindowMaker programs use.
 *
 * Copyright (c) 1999-2001  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * wmgeneral was originally from wmapp by Martijn Pieterse (pieterse@xs4all.nl)
 * It has since had unused functions removed, slimmed down, several bugs fixed,
 * some new features added and generally tidied up.
 *
 * $Log:$
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include<stdio.h>
#include<string.h>
#include<X11/Xlib.h>
#include<X11/xpm.h>
#include<X11/extensions/shape.h>
#include"wmgeneral.h"


typedef struct {
	Pixmap		pixmap;
	Pixmap		mask;
	XpmAttributes	attributes;
} XpmIcon;


static Window root;
static int screen;
static Pixel back_pix, fore_pix;
static char *geometry = "";
static Window win,iconwin;
static GC NormalGC;
static XpmIcon wmgen;
static Pixmap pixmask;


/*
 * Create a Xpm image from a character array
 */
static void GetXPM(XpmIcon *wmgen, char *pixmap_bytes[])
{
	XWindowAttributes attributes;
	int err;

	/* For the colormap */
	XGetWindowAttributes(display, root, &attributes);

	wmgen->attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);

	err = XpmCreatePixmapFromData(display, root, pixmap_bytes,
		&(wmgen->pixmap), &(wmgen->mask), &(wmgen->attributes));
	
	if (err!=XpmSuccess) {
		fprintf(stderr, "Not enough free colorcells.\n");
		exit(1);
	}
}


/*
 * GetColor
 */
static Pixel GetColor(char *name)
{
	XColor color;
	XWindowAttributes attributes;

	XGetWindowAttributes(display, root, &attributes);

	color.pixel = 0;
	if (!XParseColor(display, attributes.colormap, name, &color)) {
		fprintf(stderr, "wm.app: can't parse %s.\n", name);
	} else if (!XAllocColor(display, attributes.colormap, &color)) {
		fprintf(stderr, "wm.app: can't allocate %s.\n", name);
	}

	return color.pixel;
}


/*
 * RedrawWindow																   *|
 */
void RedrawWindow(void)
{	
	XEvent dummy;

	while (XCheckTypedWindowEvent(display, win, Expose, &dummy));
	XCopyArea(display, wmgen.pixmap, iconwin, NormalGC, 
		0,0, wmgen.attributes.width, wmgen.attributes.height, 0,0);
	while (XCheckTypedWindowEvent(display, win, Expose, &dummy));
	XCopyArea(display, wmgen.pixmap, win, NormalGC,
		0,0, wmgen.attributes.width, wmgen.attributes.height, 0,0);

	return;
}


/*
 * copyXPMArea																   *|
 */
void copyXPMArea(int x, int y, int sx, int sy, int dx, int dy)
{
	XCopyArea(display, wmgen.pixmap, wmgen.pixmap, NormalGC,
		x, y, sx, sy, dx, dy);

	return;
}


/*
 * openXwindow																   *|
 */
void openXwindow(int argc, char *argv[], char *pixmap_bytes[],
	char *pixmask_bits, int pixmask_width, int pixmask_height)
{
	XClassHint classHint;
	XSizeHints sizehints;
	XWMHints wmhints;
	XTextProperty name;
	XGCValues gcv;
	char *display_name = NULL;
	char *wname = argv[0];
	unsigned long gcm;
	int dummy,i;
	int wmdock;


	dummy = 0;
	wmdock = 1;
	for (i=1; argv[i]; i++) {
		if (!strcmp(argv[i], "-display")) 
			display_name = argv[i+1];
		if (!strcmp(argv[i], "-geometry")) 
			geometry = argv[i+1];
		if ((!strcmp(argv[i], "-n")) || (!strcmp(argv[i], "--normal")))
			wmdock = 0;
	}

	if (!(display = XOpenDisplay(display_name))) {
		fprintf(stderr, "%s: can't open display %s\n", wname,
			XDisplayName(display_name));
		exit(1);
	}
	screen = DefaultScreen(display);
	root = RootWindow(display, screen);

	/* Convert XPM to XImage */
	GetXPM(&wmgen, pixmap_bytes);

	/* Create a window to hold the stuff */
	sizehints.flags = USSize | USPosition;
	sizehints.x = 0;
	sizehints.y = 0;

	back_pix = GetColor("white");
	fore_pix = GetColor("black");

	XWMGeometry(display, screen, geometry, NULL, 1, &sizehints,
		&sizehints.x, &sizehints.y, &sizehints.width,
		&sizehints.height, &dummy);

	sizehints.width = 64;
	sizehints.height = 64;
		
	win = XCreateSimpleWindow(display, root, sizehints.x, sizehints.y,
		sizehints.width, sizehints.height, 1, fore_pix, back_pix);
	
	iconwin = XCreateSimpleWindow(display, win, sizehints.x, sizehints.y,
		sizehints.width, sizehints.height, 1, fore_pix, back_pix);

	/* Activate hints */
	XSetWMNormalHints(display, win, &sizehints);
	classHint.res_name = wname;
	classHint.res_class = wname;
	XSetClassHint(display, win, &classHint);

	XSelectInput(display, win, ButtonPressMask | ExposureMask |
		ButtonReleaseMask | PointerMotionMask | StructureNotifyMask);
	XSelectInput(display, iconwin, ButtonPressMask | ExposureMask |
		ButtonReleaseMask | PointerMotionMask | StructureNotifyMask);

	if (XStringListToTextProperty(&wname, 1, &name) == 0) {
		fprintf(stderr, "%s: can't allocate window name\n", wname);
		exit(1);
	}

	XSetWMName(display, win, &name);

	/* Create GC for drawing */
	
	gcm = GCForeground | GCBackground | GCGraphicsExposures;
	gcv.foreground = fore_pix;
	gcv.background = back_pix;
	gcv.graphics_exposures = 0;
	NormalGC = XCreateGC(display, root, gcm, &gcv);

	/* ONLYSHAPE ON */

	pixmask = XCreateBitmapFromData(display, win, pixmask_bits,
		pixmask_width, pixmask_height);

	XShapeCombineMask(display, win, ShapeBounding, 0, 0, pixmask, ShapeSet);
	XShapeCombineMask(display, iconwin, ShapeBounding, 0, 0, pixmask,
		ShapeSet);

	/* ONLYSHAPE OFF */

	wmhints.initial_state = NormalState;
	wmhints.icon_window = iconwin;
	wmhints.window_group = win;
	wmhints.icon_x = sizehints.x;
	wmhints.icon_y = sizehints.y;
	wmhints.flags = IconWindowHint | WindowGroupHint;

	/* set some things up for WindowMaker windows */
	if (wmdock==1) {
		wmhints.initial_state = WithdrawnState;
		wmhints.flags |= StateHint | IconWindowHint | IconPositionHint
			| WindowGroupHint;
	}

	XSetWMHints(display, win, &wmhints);

	if (wmdock==1) {
		XSetCommand(display, win, argv, argc);
	}

	XMapWindow(display, win);

}
