/* ========================================================================== */
/* === umfpack_report_matrix ================================================ */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_report_matrix
(
    const char name [ ],
    int n,
    const int Ap [ ],
    const int Ai [ ],
    const double Ax [ ],
    const char form [ ],
    const double Control [UMFPACK_CONTROL]
) ;

long umfpack_l_report_matrix
(
    const char name [ ],
    long n,
    const long Ap [ ],
    const long Ai [ ],
    const double Ax [ ],
    const char form [ ],
    const double Control [UMFPACK_CONTROL]
) ;

/*
int Syntax:

    #include "umfpack.h"
    int n, *Ap, *Ai, status ;
    double *Ax, Control [UMFPACK_CONTROL] ;
    status = umfpack_report_matrix ("A", n, Ap, Ai, Ax, "column", Control) ;
or:
    status = umfpack_report_matrix ("A", n, Ap, Ai, Ax, "row", Control) ;

long Syntax:

    #include "umfpack.h"
    long n, *Ap, *Ai, status ;
    double *Ax, Control [UMFPACK_CONTROL] ;
    status = umfpack_l_report_matrix ("A", n, Ap, Ai, Ax, "column", Control) ;
or:
    status = umfpack_l_report_matrix ("A", n, Ap, Ai, Ax, "row", Control) ;

Purpose:

    Verifies and prints a row or column-oriented sparse matrix.

Returns:

    UMFPACK_OK if Control [UMFPACK_PRL] <= 2 (the input is not checked).

    Otherwise:

    UMFPACK_OK if the matrix is valid and non-singular.

    UMFPACK_ERROR_singular_matrix if the matrix is structurally singular but
	otherwise valid.  It has one or more rows or columns with no entries.
	This test is made without considering the numerical values, but by just
	looking at the pattern of the entries.  Thus, all structurally singular
	matrices are numerically singular, but not all numerically singular
	matrices are structurally singular.  The matrix may be operated on by
	the matrix manipulation routines (umfpack_transpose,
	umfpack_col_to_triplet) but it may not be analyzed by umfpack_*symbolic
	or factorized by umfpack_numeric).

    UMFPACK_ERROR_n_nonpositive if n <= 0.
    UMFPACK_ERROR_argument_missing if Ap and/or Ai are missing.
    UMFPACK_ERROR_nz_negative if Ap [n] < 0.
    UMFPACK_ERROR_Ap0_nonzero if Ap [0] is not zero.
    UMFPACK_ERROR_col_length_negative if Ap [j+1] < Ap [j] for any j in the
	range 0 to n-1.
    UMFPACK_ERROR_out_of_memory if out of memory.
    UMFPACK_ERROR_row_index_out_of_bounds if any row index in Ai is not in
	the range 0 to n-1.
    UMFPACK_ERROR_jumbled_matrix if the row indices in any column are not in
	ascending order, or contain duplicates.

Arguments:

    char name [ ] ;	Input argument, not modified.

	The name of the matrix.  This is optional; no name is printed if
	a (char *) NULL pointer is passed.

    Int n ;		Input argument, not modified.

	A is an n-by-n matrix.  Restriction: n > 0.

    Int Ap [n+1] ;	Input argument, not modified.

	Ap is an integer array of size n+1.  If the form argument is "column",
	then on input, it holds the "pointers" for the column form of the
	sparse matrix A.  The row indices of column j of the matrix A are held
	in Ai [(Ap [j]) ... (Ap [j+1]-1)].  If form is "row", then Ap holds the
	row pointers.  The column indices of row j of the matrix are held
	in Ai [(Ap [j]) ... (Ap [j+1]-1)].

	The first entry, Ap [0], must be zero, and Ap [j] <= Ap [j+1] must hold
	for all j in the range 0 to n-1.  The value nz = Ap [n] is thus the
	total number of entries in the pattern of the matrix A.
	Restriction:  Ap [0] == 0 and Ap [n] > 0.

    Int Ai [nz] ;	Input argument, not modified, of size nz = Ap [n].

	If form is "column", then the nonzero pattern (row indices) for column
	j is stored in Ai [(Ap [j]) ... (Ap [j+1]-1)].  Row indices must be in
	the range 0 to n-1 (the matrix is 0-based).

	If form is "row", then the nonzero pattern (column indices) for row
	j is stored in Ai [(Ap [j]) ... (Ap [j+1]-1)]. Column indices must be in
	the range 0 to n-1 (the matrix is 0-based).

    double Ax [nz] ;	Input argument, not modified, of size nz = Ap [n].

	The numerical values of the sparse matrix A.

	If form is "row", then the nonzero pattern (row indices) for column j
	is stored in Ai [(Ap [j]) ... (Ap [j+1]-1)], and the corresponding
	numerical values are stored in Ax [(Ap [j]) ... (Ap [j+1]-1)].

	If form is "column", then the nonzero pattern (column indices) for row j
	is stored in Ai [(Ap [j]) ... (Ap [j+1]-1)], and the corresponding
	numerical values are stored in Ax [(Ap [j]) ... (Ap [j+1]-1)].

	No numerical values are printed if Ax is a (double *) NULL pointer.

    char *form ;	Input argument, not modified.

	The matrix is in row-oriented form if form is "row".  Otherwise,
	the matrix is in column-oriented form.  The form argument may be
	(char *) NULL, in which case the matrix is in column-oriented form.

    double Control [UMFPACK_CONTROL] ;	Input argument, not modified.

	If a (double *) NULL pointer is passed, then the default control
	settings are used.  Otherwise, the settings are determined from the
	Control array.  See umfpack_defaults on how to fill the Control
	array with the default settings.  The following Control parameters
	are used:

	Control [UMFPACK_PRL]:  printing level.

	    2 or less: no output.  returns silently without checking anything.
	    3: fully check input, and print a short summary of its status
	    4: as 3, but print first few entries of the input
	    5: as 3, but print all of the input
	    Default: 1

*/

