/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_hseparator_h
#define _vdkb_hseparator_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkb_evsep.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBSeparator: public VDKBEvSeparator, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *delwidget;
  VDKBObjectInspector* inspector;
  int mode; // h_sep, v_sep
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidgetH(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static int MakeWidgetV(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBSeparator(char* name,VDKForm* owner, int mode = h_separator);
  virtual ~VDKBSeparator() {}
  virtual int Type() { return vdkbclass_sep; }
  virtual char* VDKName() { return "VDKSeparator"; }
  virtual int isA() { return vdkbclass_sep; }
  void PopMenu() { popmenu->Popup(); }
  // designer
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  DECLARE_SIGNAL_LIST(VDKBSeparator);
  DECLARE_EVENT_LIST(VDKBSeparator);
};
#endif
