/*
 * ===========================
 * VDK Builder
 * Version 1.2
 * Revision 0.1
 * May 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

#ifndef _vdkb_xentry_h
#define _vdkb_xentry_h
#if HAVE_CONFIG_H
#include <config.h>
#endif
#if USE_XDB
#include <vdk/vdk.h>
#include <vdkxdb/vdkxdb.h>
#include <vdkxdb/vdkxtable.h>
#include <vdkxdb/vdkxentry.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>


class VDKBGuiForm;
class VDKBParser;
class VDKBXEntry: public VDKXEntry, public VDKBObject
{

 protected:

  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector;
  VDKCheckButton* hidden,*editable;

  VDKCustomList* tablelist,*fieldlist;
  VDKCustomButton* assignButton;
  
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner,
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBXEntry(char* name,VDKForm* owner, char* def = NULL);
  virtual ~VDKBXEntry() {}
  virtual int Type() { return vdkbclass_xentry; }
  virtual char* VDKName() { return "VDKXEntry"; }
  virtual int isA() { return vdkbclass_xentry; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  void PopMenu() { popmenu->Popup(); }
  bool OverriddenButtonPressed(VDKObject* sender, GdkEvent* ev);
  // designer
  bool OnSetHidden(VDKObject*);
  bool OnSetEditable(VDKObject*);
  bool OnAssignButtonClicked(VDKObject*);
  bool OnTableListSelectRow(VDKObject*);
  bool OnTableListUnselectRow(VDKObject*);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  DECLARE_SIGNAL_LIST(VDKBXEntry);
  DECLARE_EVENT_LIST(VDKBXEntry);
};
#endif
#endif



