/*
 * This makes sure it's included
 * first in every file
 */
#include "autoconf.h"

typedef struct config {
	int restart;
	int chkpmon;
	int chkromsize;
	int chkkernsize;
	int restore_defaults;
	int xmodemload;
	char *ttyport;
	char *tmpdir;
} CONFIG;

#define DEBUG 0

/* 5s read/write timeout */
#define TIMEOUT        5	
#define UTIMEOUT       100000
#define RETRIES        10

/* Line control codes */
#define SOH            0x01  /* start of header */
#define ETX            0x3
#define ACK            0x06  /* Acknowledge */
#define NAK            0x15  /* Negative acknowledge */
#define CAN            0x18  /* Cancel */
#define EOT            0x04  /* end of text */
#define XM_EOF         0x1a  /* eof */
#define DC1            0x11
#define NAK            0x15
#define DC3            0x13
#define XON            DC1
#define XOFF           DC3

#define BUFSIZE        1024
#define SMBUFSIZE      128
#define LOGFILE        "./capture.log"
#define PORTLOG        1
#define NOPORTLOG      0

#define MAX_KERNEL_SIZE      0x200000
#define MAX_ROMDISK_SIZE     0xA00000
#define MAX_DOWNLOAD_SIZE    0x770000

#define SPLITFILE_OFFSET     0x600000

#define SECTOR_SIZE          0x20000
#define SECTOR_ALIGN(x) (x%SECTOR_SIZE) ? (x + (SECTOR_SIZE-(x%SECTOR_SIZE))) : x

#define TMPDIR         "/tmp"
