//<copyright>
//
// Copyright (c) 1992,93,94,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>
//
// Note: this implementation is based on InterViews code
// see copyright notice of original version below

//<file>
//
// File:        gecontext.h - glyph for 3D drawing
//
// Created:     10 Nov 92   Michael Pichler
//
// Changed:     25 Jul 95   Michael Pichler
//
// $Id: gecontext.h,v 1.4 1997/02/25 17:03:58 mpichler Exp $
//
//</file>

/*
 * Copyright (c) 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */



#ifndef harmony_scene_gecontext_h
#define harmony_scene_gecontext_h


#include <InterViews/monoglyph.h>
class Cursor;
class Display;
class Window;
class GLWindow;

// renamed from GLContext to GEContext (name conflict with InterViews)

class GEContext: public MonoGlyph
{
  public:
    enum { RequestOverlay = 0x1 };

    GEContext (Glyph*, int requests = 0);
    ~GEContext ();

    void allocate (Canvas*, const Allocation&, Extension&);  // told my actual geometry
    void draw (Canvas*, const Allocation&) const  { }        // draw myself

    void redraw (                       // damage canvas
      int shading                       //   hint whether shading will be performed
    );                                  //   pass 0 for wireframe drawings to speed up Mesa

    void unbind ();                     // delete GLX window

    Window* window ();

    void setCursor (Cursor*);           // set a cursor
    void resetCursor ();                // restore original cursor
    void pushCursor (Cursor*);
    void popCursor ();

    int overlaySupport ();                   // platform supports overlay planes
    void activateOverlay (int clear = 1);    // switch to overlay planes
    void deactivateOverlay ();               // switch back to normal bitplanes

    static const char* implementation ();    // implementation info (e.g.: "IrisGL", "OpenGL")
    enum { impl_slow = 0x1, impl_notextures = 0x2, impl_requiresTrueColor = 0x4 };
    static int implementationHints ();  // hints to implementation properties

    static int graphicsSupport (        // query for graphics support
      Display* dis = 0);                //   on specified or default display

  private:
    GLWindow* glwin_;
    Cursor* origcur_;

    int requestoverlay_;
};  // GEContext



#endif
