//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>



//<file>
//
//
// Name:        $RCSfile: numbereditor.h,v $
//
// Purpose:     Interface to class NumberEditor
//
// Created:     19 May 95   Bernhard Marschall
// Modified:    19 Sept 96  Thomas Starlinger
// Last:        $Date: 1996/10/08 08:27:27 $
//
// Description: Puts a number field with bound checking and up and
//              down steppers (even a slider if there's anough room)
//              to the users disposal.
//
// $Log: numbereditor.h,v $
// Revision 1.3  1996/10/08 08:27:27  bmarsch
// Renamed FieldObserver to FieldEditorObserver (there's already a
// FieldObserver in fslider.c)
//
// Revision 1.2  1996/09/20 13:45:37  bmarsch
// Corrected includes
//
// Revision 1.1  1996/09/20 13:29:57  bmarsch
// Initial revision
//
// Revision 1.3  1996/09/20 13:09:58  tstar
// Totally rewritten. To much to be documented here.
//
//
//</file>

#ifndef harmony_widgets_nubereditor_h
#define harmony_widgets_nubereditor_h

#include "adjvalue.h"
#include "libwidgets.h"
#include <InterViews/input.h>

class Action;
class WidgetKit;
class LayoutKit;
class FieldEditor31;
class FieldEditorObserver;


//<class>
//
// Name:                 NumberEditor
//
// Purpose:              FieldEditor coupled with Scrollbar
//
// Public Interface:
//
// Description:
//
// -  NumberEditor(...): Constructors.
//
// -  ~NumberEditor(): Destructor.
//
// Data functions (set/get current, upper and lower value)
//
// -    void setValue(float value):
// -    float getValue() const:
// -    void setUpper(float value):
// -    float getUpper() const:
// -    void setLower(float value):
// -    float getLower() const:
//
// -    AdjValue* adjvalue() const: Liefert den intern benutzten AdjValue zurueck.
//
// -    FieldEditor31* field() const: Liefert den intern benutzten FieldEditor.
//
// -    virtual InputHandler* focus_in(): What to do when getting the focus.
//
// -    void accept(): After a \r or \t was pressed the value is accepted
//                     and after bound checking took place the value is displayed
//                     in the FieldEditor.
//
// Private Interface:
//
// -    void init(int precision, const char* pattern): Initialize and assemble the
//                                                     NumberEditor
// -    void setField(): Set FieldEditor text.
//
// -    void accept(FieldEditor31*, char): Action taken when pressing \r or \t.
//
// -    Glyph* slider(DimensionName, AdjValue*, Coord): Create and assembles the
//             steppers and, if necessary, the slider.
//
//</class>


class NumberEditor : public InputHandler {
public:
  enum Position { NONE  =0x0001, 
		  ABOVE =0x0002, 
		  RIGHT =0x0004,
		  UNDER =0x0008,
		  LEFT  =0x0010
  }; // Clockwise.
    
  NumberEditor(
    float lower,                   // minimum value
    float upper,                   // maximum value
    float init,                    // initial value
    int pos=NONE,                  // Position of the "slider".
    Action *focus_in=nil,          // Action to call for focus in.
    Action *changed=nil,           // Action to call when changed.
    int precision = 0,             // number of decimals to print
    const char* pattern = nil,     // pattern to define width of field editor
    float small=-1,                // small stepper value
    float large=-1                 // large stepper value
  );

  NumberEditor(
    AdjValue*,                     // adjustable (provides min, max and init)
    int pos=NONE,                  // Position of the "slider".
    Action *focus_in=nil,          // Action to call for focus in.
    Action *changed=nil,           // Action to call when changed.
    int precision = 0,             // number of decimals to print
    const char* pattern = nil      // pattern to define width of field editor
  );
  virtual ~NumberEditor();

  void setValue(float value);
  float getValue() const     { return adj_->cur_lower(Dimension_X); }
  void setUpper(float value);
  float getUpper() const     { return adj_->cur_upper(Dimension_X); }
  void setLower(float value);
  float getLower() const     { return adj_->cur_lower(Dimension_X); }

  AdjValue* adjvalue() const   // returns adjustable used for scrollbar
  { return adj_; }
  FieldEditor31* field() const     // returns field editor
  { return field_; }

  virtual InputHandler* focus_in();

  // Accepts field value as new AdjValue.
  void accept() { accept(nil, nil); }

private:
  void init(int precision, const char* pattern);
  void setField();
  void accept(FieldEditor31*, char);

  int slPos_;

  Glyph* slider(DimensionName, AdjValue*, Coord);

  WidgetKit *kit_;
  LayoutKit *layout_;

  FieldEditor31* field_;
  AdjValue* adj_;
  int precision_;
  char format_[8];
  const boolean adjInside_;
  FieldEditorObserver* fobs_;

  Action *chAction_;
  Action *fiAction_;

  friend class FieldEditorObserver;
};

#endif /* harmony_widgets_nubereditor_h */
