/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.ArrayList;
import java.util.HashMap;
import org.odejava.collision.BulkContact;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNBodyGroupNodeType;
import org.web3d.vrml.nodes.VRMLNBodySensorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseContact;

public abstract class BaseCollisionSensor
extends BaseSensorNode
implements VRMLNBodySensorNodeType {
    protected static final int FIELD_COLLIDABLES = 3;
    protected static final int FIELD_ENABLED = 4;
    protected static final int FIELD_CONTACTS = 5;
    protected static final int FIELD_INTERSECTIONS = 6;
    protected static final int LAST_COLLECTION_INDEX = 6;
    private static final int NUM_FIELDS = 7;
    protected static final String COLLIDABLE_PROTO_MSG = "Collidables field proto value does not describe a CollisionCollection.";
    protected static final String COLLIDABLE_NODE_MSG = "Collidables field node value does not describe a CollisionCollection.";
    private static final String CONTACT_WRITE_MSG = "contacts is outputOnly and cannot be set";
    private static final String INTERSECTION_WRITE_MSG = "intersections is outputOnly and cannot be set";
    private static final int[] nodeFields = new int[]{0, 3};
    private static final VRMLFieldDeclaration[] fieldDecl = new VRMLFieldDeclaration[7];
    private static final HashMap fieldMap = new HashMap(21);
    protected VRMLNBodyGroupNodeType vfCollidables;
    protected VRMLProtoInstance pCollidables;
    protected VRMLNodeType[] vfContacts;
    protected int numContacts;
    protected VRMLNodeType[] vfIntersections;
    protected int numIntersections;
    private ArrayList contactPool = new ArrayList();

    public BaseCollisionSensor() {
        super("CollisionSensor");
        this.hasChanged = new boolean[7];
    }

    public BaseCollisionSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSensorNodeType)vRMLNodeType);
    }

    public void updateContacts(IntHashMap intHashMap, IntHashMap intHashMap2) {
        if (this.vfCollidables == null || !this.vfCollidables.isEnabled()) {
            return;
        }
        BulkContact bulkContact = this.vfCollidables.getContacts();
        int n = this.vfCollidables.numContacts();
        if (n == 0) {
            if (this.vfIsActive) {
                this.vfIsActive = false;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
            }
            this.numContacts = 0;
            this.numIntersections = 0;
        } else {
            int n2;
            this.contactPool.ensureCapacity(n);
            int n3 = this.contactPool.size();
            if (n3 < n) {
                for (n2 = n3; n2 < n; ++n2) {
                    this.contactPool.add(this.generateNewContact());
                }
            }
            if (this.vfContacts == null || this.vfContacts.length < n) {
                this.vfContacts = new VRMLNodeType[n];
                this.vfIntersections = new VRMLNodeType[n];
            }
            for (n2 = 0; n2 < n; ++n2) {
                BaseContact baseContact = (BaseContact)this.contactPool.get(n2);
                baseContact.setContact(bulkContact, n2, intHashMap, intHashMap2);
                this.vfContacts[n2] = baseContact;
            }
            this.numContacts = n;
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
            if (!this.vfIsActive) {
                this.vfIsActive = true;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pCollidables != null) {
            this.pCollidables.setupFinished();
        } else if (this.vfCollidables != null) {
            this.vfCollidables.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 87;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.nodeValue = this.pCollidables != null ? this.pCollidables : this.vfCollidables;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.vfContacts;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = this.numContacts;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.vfIntersections;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = this.numIntersections;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    if (this.pCollidables != null) {
                        vRMLNodeType.setValue(n2, this.pCollidables);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfCollidables);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfContacts, this.numContacts);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfIntersections, this.numIntersections);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 5: {
                throw new InvalidFieldAccessException(CONTACT_WRITE_MSG);
            }
            case 6: {
                throw new InvalidFieldAccessException(INTERSECTION_WRITE_MSG);
            }
            case 3: {
                this.setCollidables(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 5: {
                throw new InvalidFieldAccessException(CONTACT_WRITE_MSG);
            }
            case 6: {
                throw new InvalidFieldAccessException(INTERSECTION_WRITE_MSG);
            }
        }
        super.setValue(n, vRMLNodeTypeArray, n2);
    }

    protected void setCollidables(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNBodyGroupNodeType vRMLNBodyGroupNodeType;
        VRMLNodeType vRMLNodeType2 = this.pCollidables != null ? this.pCollidables : this.vfCollidables;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType3 != null && vRMLNodeType3 instanceof VRMLProtoInstance) {
                vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType3).getImplementationNode();
            }
            if (vRMLNodeType3 != null && !(vRMLNodeType3 instanceof VRMLNBodyGroupNodeType)) {
                throw new InvalidFieldValueException(COLLIDABLE_PROTO_MSG);
            }
            vRMLNBodyGroupNodeType = (VRMLNBodyGroupNodeType)vRMLNodeType3;
            this.pCollidables = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLNBodyGroupNodeType)) {
                throw new InvalidFieldValueException(COLLIDABLE_NODE_MSG);
            }
            this.pCollidables = null;
            vRMLNBodyGroupNodeType = (VRMLNBodyGroupNodeType)vRMLNodeType;
        }
        this.vfCollidables = vRMLNBodyGroupNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            this.stateManager.registerAddedNode(vRMLNBodyGroupNodeType);
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    protected abstract BaseContact generateNewContact();

    static {
        BaseCollisionSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCollisionSensor.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseCollisionSensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "collidables");
        BaseCollisionSensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseCollisionSensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "MFNode", "contacts");
        BaseCollisionSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFNode", "intersections");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("collidables", n);
        fieldMap.put("set_collidables", n);
        fieldMap.put("collidables_changed", n);
        fieldMap.put("contacts", new Integer(5));
        fieldMap.put("intersections", new Integer(6));
        fieldMap.put("isActive", new Integer(2));
    }
}

