// Closes the selected dashboard tab
function webdeveloper_closeDashboardTab()
{
    var tabBox           = document.getElementById("webdeveloper-dashboard-tab-box");
    var selectedIndex    = tabBox.selectedIndex;
    var selectedTabPanel = tabBox.selectedPanel;
    var selectedTab      = tabBox.selectedTab;
    var tabPanels        = document.getElementById("webdeveloper-dashboard-tab-panels");
    var tabs             = document.getElementById("webdeveloper-dashboard-tabs");

    // If the selected tab is set
    if(selectedTab)
    {
        tabs.removeChild(selectedTab);
    }
    else if(selectedIndex >= 0)
    {
        tabs.removeChild(tabs.childNodes[selectedIndex]);
    }
    else
    {
        var tabPanel           = null;
        var tabPanelChildNodes = tabPanels.childNodes;
        var tabPanelsLength    = tabPanelChildNodes.length;

        // Loop through the tab panel child nodes
        for(var i = 0; i < tabPanelsLength; i++)
        {
            tabPanel = tabPanelChildNodes.item(i);
    
            // If this is the selected tab panel
            if(tabPanel == selectedTabPanel)
            {
                tabs.removeChild(tabs.childNodes[i]);
                break;
            }
        }
    }

    // If the selected tab panel is set
    if(selectedTabPanel)
    {
        tabPanels.removeChild(selectedTabPanel);
    }
    else if(selectedIndex >= 0)
    {
        tabPanels.removeChild(tabPanels.childNodes[selectedIndex]);
    }

    // If there are no tab panels remaining
    if(tabPanels.childNodes.length == 0)
    {
        document.getElementById("webdeveloper-dashboard").hidden          = true;
        document.getElementById("webdeveloper-dashboard-splitter").hidden = true;
    }
    else
    {
        tabs.selectedIndex = 0;
    }
}

// Closes the given tab in the dashboard
function webdeveloper_closeInDashboard(title)
{
    var position    = 0;
    var tab         = null;
    var tabPanels   = document.getElementById("webdeveloper-dashboard-tab-panels");
    var tabs        = document.getElementById("webdeveloper-dashboard-tabs");
    var tabElements = tabs.childNodes;
    var tabsLength  = tabElements.length;

    // Loop through the tabs
    for(var i = 0; i < tabsLength; i++)
    {
        tab = tabElements.item(i);

        // If this is a tab
        if(tab.nodeName == "tab")
        {
            // If the tab has a matching label attribute
            if(tab.hasAttribute("label") && tab.getAttribute("label") == title)
            {
                break;
            }

            position++;
        }
    }

    // If a tab was matched
    if(position < tabsLength)
    {
        tabPanels.removeChild(tabPanels.childNodes[position]);
        tabs.removeItemAt(position);

        // If there are no tab panels remaining
        if(tabPanels.childNodes.length == 0)
        {
            document.getElementById("webdeveloper-dashboard").hidden          = true;
            document.getElementById("webdeveloper-dashboard-splitter").hidden = true;
        }
        else
        {
            tabs.selectedIndex = 0;
        }
    }
}

// Returns the document for given tab in the dashboard
function webdeveloper_getDocumentInDashboard(title)
{
    var position    = 0;
    var tab         = null;
    var tabPanels   = document.getElementById("webdeveloper-dashboard-tab-panels");
    var tabs        = document.getElementById("webdeveloper-dashboard-tabs");
    var tabElements = tabs.childNodes;
    var tabsLength  = tabElements.length;

    // Loop through the tabs
    for(var i = 0; i < tabsLength; i++)
    {
        tab = tabElements.item(i);

        // If this is a tab
        if(tab.nodeName == "tab")
        {
            // If the tab has a matching label attribute
            if(tab.hasAttribute("label") && tab.getAttribute("label") == title)
            {
                break;
            }

            position++;
        }
    }

    // If a tab was matched
    if(position < tabsLength)
    {
        return tabPanels.childNodes[position].childNodes[0].contentDocument;
    }

    return null;
}

// Is the given tab open in the dashboard
function webdeveloper_isOpenInDashboard(title)
{
    var tab        = null;
    var tabs       = document.getElementById("webdeveloper-dashboard-tabs").childNodes;
    var tabsLength = tabs.length;

    // Loop through the tabs
    for(var i = 0; i < tabsLength; i++)
    {
        tab = tabs.item(i);

        // If this is a tab and it has a matching label attribute
        if(tab.nodeName == "tab" && tab.hasAttribute("label") && tab.getAttribute("label") == title)
        {
            return true;
        }
    }

    return false;
}

// Opens the given URL in the dashboard
function webdeveloper_openInDashboard(title, url)
{
    var browser   = document.createElement("browser");
    var tab       = document.createElement("tab");
    var tabCount  = 0;
    var tabPanel  = document.createElement("tabpanel");
    var tabPanels = document.getElementById("webdeveloper-dashboard-tab-panels");
    var tabs      = document.getElementById("webdeveloper-dashboard-tabs");

    browser.setAttribute("flex", "1");
    browser.setAttribute("src", url);
    tabPanel.appendChild(browser);
    tab.setAttribute("label", title);

    tabPanels.appendChild(tabPanel);
    tabs.insertBefore(tab, document.getElementById("webdeveloper-dashboard-spacer"));

    tabCount           = tabPanels.childNodes.length - 1;
    tabs.selectedIndex = tabCount;

    // If this is the only tab
    if(tabCount == 0)
    {
        var dashboard = document.getElementById("webdeveloper-dashboard");

        // If the dashboard height is less than 100
        if(dashboard.height < 100)
        {
            dashboard.height = 100;
        }

        // If the dashboard width is less than 100
        if(dashboard.width < 100)
        {
            dashboard.width = 100;
        }

        dashboard.hidden                                                  = false;
        document.getElementById("webdeveloper-dashboard-splitter").hidden = false;
    }
}

// Positions the dashboard
function webdeveloper_positionDashboard()
{
    var currentPosition   = webdeveloper_getStringPreference("webdeveloper.dashboard.position", true);
    var dashboard         = document.getElementById("webdeveloper-dashboard");
    var dashboardSplitter = document.getElementById("webdeveloper-dashboard-splitter");

    dashboard.hidden         = true;
    dashboardSplitter.hidden = true;

    // If the current position is bottom
    if(currentPosition == "bottom")
    {
        webdeveloper_setStringPreference("webdeveloper.dashboard.position", "left");
        webdeveloper_setupDashboardPosition("left");
    }
    else if(currentPosition == "left")
    {
        webdeveloper_setStringPreference("webdeveloper.dashboard.position", "top");
        webdeveloper_setupDashboardPosition("top");
    }
    else if(currentPosition == "right")
    {
        webdeveloper_setStringPreference("webdeveloper.dashboard.position", "bottom");
        webdeveloper_setupDashboardPosition("bottom");
    }
    else if(currentPosition == "top")
    {
        webdeveloper_setStringPreference("webdeveloper.dashboard.position", "right");
        webdeveloper_setupDashboardPosition("right");
    }

    dashboard.hidden         = false;
    dashboardSplitter.hidden = false;
}

// Selects the given tab in the dashboard
function webdeveloper_selectInDashboard(title)
{
    var tab        = null;
    var tabs       = document.getElementById("webdeveloper-dashboard-tabs").childNodes;
    var tabsLength = tabs.length;

    // Loop through the tabs
    for(var i = 0; i < tabsLength; i++)
    {
        tab = tabs.item(i);

        // If this is a tab and it has a matching label attribute
        if(tab.nodeName == "tab" && tab.hasAttribute("label") && tab.getAttribute("label") == title)
        {
            tabs.selectedIndex = i;

            break;
        }
    }
}

// Sets up the dashboard position
function webdeveloper_setupDashboardPosition(position)
{
    var appContent        = document.getElementById("appcontent");
    var dashboard         = document.getElementById("webdeveloper-dashboard");
    var dashboardSplitter = document.getElementById("webdeveloper-dashboard-splitter");

    // If the current position is bottom
    if(position == "bottom")
    {
        appContent.appendChild(dashboardSplitter);
        appContent.appendChild(dashboard);
    }
    else if(position == "left")
    {
        var browser = appContent.parentNode;

        browser.insertBefore(dashboard, appContent);
        browser.insertBefore(dashboardSplitter, appContent);
    }
    else if(position == "right")
    {
        webdeveloper_insertAfter(dashboard, appContent);
        webdeveloper_insertAfter(dashboardSplitter, appContent);
    }
    else if(position == "top")
    {
        webdeveloper_insertAsFirstChild(appContent, dashboardSplitter);
        webdeveloper_insertAsFirstChild(appContent, dashboard);
    }

    // If the position is bottom or top
    if(position == "bottom" || position == "top")
    {
        dashboardSplitter.setAttribute("orient", "vertical");
    }
    else if((position == "left" || position == "right") && dashboardSplitter.hasAttribute("orient"))
    {
        dashboardSplitter.removeAttribute("orient");
    }
}