# sendmail-monitor.pl
# Monitor the sendmail server on this host

# Check the PID file to see if sendmail is running
sub get_sendmail_status
{
&foreign_require($_[1], "sendmail-lib.pl");
local %sconfig = &foreign_config($_[1]);
return { 'up' => -1 } if (!-r $sconfig{'sendmail_cf'});
if (open(PID, $sconfig{'sendmail_pid'}) && <PID> =~ /(\d+)/ && kill(0, $1)) {
	close(PID);
	local @st = stat($sconfig{'sendmail_pid'});
	return { 'up' => 1,
		 'desc' => &text('up_since', scalar(localtime($st[9]))) };
	}
else {
	return { 'up' => 0 };
	}
}

sub parse_sendmail_dialog
{
&depends_check($_[0], "sendmail");
}

1;

