#!/usr/local/bin/perl
# Show one DB

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
&can_edit_domain($d) || &error($text{'edit_ecannot'});

if ($in{'new'}) {
	&ui_print_header(&domain_in($d), $text{'database_title1'}, "");
	}
else {
	&ui_print_header(&domain_in($d), $text{'database_title2'}, "");
	}

print &ui_form_start("save_database.cgi", "post");
print &ui_hidden("dom", $in{'dom'}),"\n";
if (!$in{'new'}) {
	print &ui_hidden("name", $in{'name'}),"\n";
	print &ui_hidden("type", $in{'type'}),"\n";
	}
else {
	print &ui_hidden("new", 1),"\n";
	}
print &ui_table_start($text{'database_header'}, undef, 2);

print &ui_table_row($text{'database_name'},
    $in{'new'} ? &ui_textbox("name", undef, 30) : "<tt>$in{'name'}</tt>");

@types = ( );
push(@types, [ "mysql", $text{'databases_mysql'} ]) if ($d->{'mysql'});
push(@types, [ "postgres", $text{'databases_postgres'} ]) if ($d->{'postgres'});
print &ui_table_row($text{'database_type'},
    $in{'new'} ? &ui_select("type", $types[0]->[0], \@types)
	       : $text{'databases_'.$in{'type'}});

if (!$in{'new'}) {
	$szfunc = $in{'type'}."_size";
	($size, $tables) = &$szfunc($d, $in{'name'});
	if ($size ne "") {
		print &ui_table_row($text{'database_size'}, &nice_size($size));
		}
	if ($tables ne "") {
		print &ui_table_row($text{'database_tables'}, $tables);
		}
	}

print &ui_table_end();
if ($in{'new'}) {
	print &ui_form_end([ [ "create", $text{'create'} ] ]);
	}
else {
	print &ui_form_end([ [ "delete", $text{'database_delete'} ],
		     &master_admin() ? ( [ "disc", $text{'database_disc'} ] )
				     : ( ) ]);
	}

&ui_print_footer("list_databases.cgi?dom=$in{'dom'}", $text{'databases_return'},
		 "edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
		 "", $text{'index_return'});
