/* opencontextmenuop.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2007,2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "opencontextmenuop.hh"
#include "listermode.h"
#include "normalmode.h"
#include "worker_locale.h"
#include "worker.h"

const char *OpenContextMenuOp::name = "OpenContextMenuOp";

OpenContextMenuOp::OpenContextMenuOp() : FunctionProto()
{
}

OpenContextMenuOp::~OpenContextMenuOp()
{
}

OpenContextMenuOp *OpenContextMenuOp::duplicate() const
{
    OpenContextMenuOp *ta = new OpenContextMenuOp();
    return ta;
}

bool OpenContextMenuOp::isName(const char *str)
{
    if ( strcmp( str, name ) == 0 )
        return true;
    else
        return false;
}

const char *OpenContextMenuOp::getName()
{
    return name;
}

int OpenContextMenuOp::run( WPUContext *wpu, ActionMessage *msg )
{
    Lister *l1;
    ListerMode *lm1;
    NormalMode *nm1;
    
    l1 = msg->getWorker()->getActiveLister();
    if ( l1 == NULL )
        return 1;

    lm1 = l1->getActiveMode();
    if ( lm1 != NULL && lm1->isType( "NormalMode" ) == true ) {
        nm1 = (NormalMode*)lm1;
        nm1->openContextMenu();
    }
        
    return 0;
}

const char *OpenContextMenuOp::getDescription()
{
    return catalog.getLocaleCom( 52 );
}
