// $Id: ETMove.h,v 1.3 2003/02/08 13:14:51 mrq Exp $
#ifndef WE_ETMOVE_H

#include "EntityTool.h"
#include "Command.h"

class ETMove : public EntityTool
{
      Entity *m_Entity;
      Ark::Vector3 m_NewPos, m_OldPos;
  public:
      ETMove (World *world);
      virtual ~ETMove();
      
      /// Apply tool at (x,z)
      virtual void Apply3D (Ark::Vector3 newpos, const Ark::Collision &col);
      
      /// Update or reset tool
      virtual void Update();
      
   public:
      /// Create a command with a correct state.
      virtual Command* CreateCommand();
};

/// Entity command: move
class ECMove : public Command
{
      World *m_World;
      Entity *m_Entity;
      Ark::Vector3 m_NewPos;
      Ark::Vector3 m_OldPos;

   public:
      ECMove (World *world, Entity *entity, Ark::Vector3 newpos);
      virtual ~ECMove();

      /// Return the command type.
      virtual std::string Type() const;

      /// Execute this command.
      virtual void Execute();

      /// Undo the action done by this command.
      virtual void Unexecute();
};

#endif

