/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44ProtocolPreferences.h"

const int BORDER_SIZE = 5;

CJT44ProtocolPreferences::CJT44ProtocolPreferences(wxWindow* parent, int id, int minSync) :
wxPanel(parent, id),
m_sync(NULL)
{
	wxFlexGridSizer* sizer = new wxFlexGridSizer(2);

	wxStaticText* syncLabel = new wxStaticText(this, -1, wxT("Sync (1-10)"));
	sizer->Add(syncLabel, 0, wxTOP, BORDER_SIZE);

	m_sync = new wxSpinCtrl(this, -1);
	m_sync->SetValue(minSync);
	m_sync->SetRange(1, 10);
	sizer->Add(m_sync, 0, wxALL, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CJT44ProtocolPreferences::~CJT44ProtocolPreferences()
{
}

int CJT44ProtocolPreferences::getMinSync() const
{
	wxASSERT(m_sync != NULL);

	return m_sync->GetValue();
}
