from Poll import Poll
from AccessControl import ClassSecurityInfo, getSecurityManager
from Globals import InitializeClass, DTMLFile
from Acquisition import Implicit
from Globals import Persistent
from AccessControl.Role import RoleManager
from OFS.SimpleItem import Item


# Constructor form and function
# -----------------------------

addForm=DTMLFile('dtml/addPoll', globals())

def addFunction(dispatcher, id, question, responses, REQUEST=None):
    """
    Create a new poll and add it to the destination.
    """
    p=PollProduct(id, question, responses)
    dispatcher.Destination()._setObject(id, p)
    if REQUEST is not None:
        dispatcher.manage_main(dispatcher, REQUEST)


# Product class
# -------------

class PollProduct(Implicit, Persistent, RoleManager, Item):
    """
    Poll product class, implements Poll interface.

    The poll has a question and a sequence of responses. Votes
    are stored in a dictionary which maps response indexes to a
    number of votes.
    """

    __implements__=Poll

    meta_type='Poll'

    manage_options=(
        {'label' : 'Edit',
         'action' : 'editForm',
         'help' : ('Poll', 'edit.txt')
         },
        {'label' : 'View',
         'action' : 'index_html'
         },
        ) + RoleManager.manage_options + Item.manage_options

    security=ClassSecurityInfo()

    security.declareProtected('View management screens', 'editForm')
    editForm=DTMLFile('dtml/editPollForm', globals())

    security.declarePublic('index_html')
    index_html=DTMLFile('dtml/view', globals())

    security.declareProtected('View Poll results', 'results') 
    results=DTMLFile('dtml/results', globals())

    def __init__(self, id, question, responses):
        self.id=id
        self.editPoll(question, responses)

    security.declareProtected('Change Poll', 'editPoll')
    def editPoll(self, question, responses, REQUEST=None):
        """
        Changes the question and responses.
        """
        self._question = question
        self._responses=[]
        for response in responses:
            response=response.strip()
            if response:
                self._responses.append(response)
        self._votes = {}
        for i in range(len(responses)):
            self._votes[i] = 0
        if REQUEST is not None:
            return self.editForm(REQUEST,
                manage_tabs_message='Poll question and responses changed.')

    security.declareProtected('Use Poll', 'castVote')
    def castVote(self, index, REQUEST=None):
        "Votes for a choice"
        self._votes[index] = self._votes[index] + 1
        self._p_changed = 1
        if REQUEST is not None:
            if getSecurityManager().checkPermission('View Poll results', self):
                return self.results(REQUEST)
            else:
                return self.index_html(REQUEST)
            
    security.declareProtected('View Poll results', 'getTotalVotes') 
    def getTotalVotes(self):
        "Returns total number of votes cast"
        total = 0
        for v in self._votes.values():
            total = total + v
        return total

    security.declareProtected('View Poll results', 'getVotesFor') 
    def getVotesFor(self, index):
        "Returns number of votes cast for a given response"
        return self._votes[index]

    security.declarePublic('getResponses') 
    def getResponses(self):
        "Returns the sequence of responses"
        return tuple(self._responses)

    security.declarePublic('getQuestion') 
    def getQuestion(self):
        "Returns the question"
        return self._question


# Initialize product class
# ------------------------

InitializeClass(PollProduct)
