static char do_host_ck_rcsid[]="$Id: do_host_ck.c,v 1.2 1998/10/21 14:46:53 green Exp $";

/*----------------------------------------------------
 * do_host_ck.c Tom Green Thu Jun 09 14:32:00 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: do_host_ck.c,v $
 * Revision 1.2  1998/10/21 14:46:53  green
 * Red Hat Alpha port - ADDRLEN incorporated
 *                      #ifdef'ed SIGCLD
 * 		     #include <stdlib.h>
 *
 * Revision 1.1.1.1  1998/08/18 14:39:05  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.3  1997/04/11 18:48:06  green
 * changed getdomainname() to dqs_getdomainname()
 *
 * Revision 1.2  1997/04/10 15:27:04  green
 * changed the parent/child relationship so exit statuses wouldn't
 * confuse the install script.
 *
 * Revision 1.7  1996/06/27 01:55:09  nrl
 * changes to accomodate osf gcc
 *
 * Revision 1.5  1994/06/19  18:54:59  green
 * don't write "THE" conf_file/resolve_file as it overwrites when
 * "config -f"
 *
 * cleaned up host_ck.c do_host_ck.c
 *
 * Revision 1.4  1994/06/16  17:53:00  green
 * misc cleanups
 *
 * Revision 1.2  1994/06/13  15:12:36  green
 * use "../SRC/header_files"
 *
 * Revision 1.1  1994/06/13  13:44:28  green
 * moved the functions out of host_ck.c into do_host_ck.c so that
 * config and host_ck could share the same code.
 *
 * added Joe's get_res_ports() to do_host_ck.c
 *
 *
 *--------------------------------------------------*/


#include "../SRC/h.h"
#include "../SRC/def.h"
#include "../SRC/dqs.h"
#include "../SRC/struct.h"
#include "../SRC/func.h"
#include "../SRC/globals.h"
#include "../SRC/dqs_errno.h"

/*extern int dqs_getdomainname(); */

/**********************************************************************/
int start_server(port)
int port;

{
       int     sockfd,newsockfd,childpid;
       ADDRLEN clilen;
       struct  sockaddr_in cli_addr,serv_addr;
       
       if ((sockfd=socket(AF_INET,SOCK_STREAM,0))<0)
       {
	      perror("socket() failure");
	      exit(-1);
       }
       
       bzero((char *)&serv_addr,sizeof(serv_addr));
       serv_addr.sin_family=AF_INET;
       serv_addr.sin_addr.s_addr=htonl(INADDR_ANY);
     newport:
       serv_addr.sin_port=htons(port);
       
       if (bind(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr))<0)
       {
	      perror("bind() failure - retrying");
	      port++;
	      goto newport;
       }
       
       
       if (fork())
       {
	      close(sockfd);
	      return(port);
       }
       
       close(0);
       close(1);
       close(2);
       
       listen(sockfd,5);
       
       clilen=sizeof(cli_addr);
       newsockfd=accept(sockfd,(struct sockaddr *)&cli_addr,
			&clilen);
       
       close(sockfd);
       close(newsockfd);
       
       sleep(3);
       
       
}

/**********************************************************************/
int start_client(port,host_name,peer_name)
char *host_name;
char *peer_name;
{
       int                sockfd,newsockfd,clilen,childpid;
       struct sockaddr_in cli_addr,serv_addr;
       int fd;
       struct sockaddr_in cli_addr2;
       struct hostent     *hp,*he;
       struct sockaddr            addr;
       char               client[MAX_STRING_SIZE];
       char               host[MAX_STRING_SIZE];
       ADDRLEN            addrlen;
       int on = 1;
       struct servent *sp;
       int fromlen;
       struct sockaddr_in from;
       struct sockaddr_in s_in;
       
       sleep(2);
       
       
       bzero((char *)&serv_addr,sizeof(serv_addr));
       serv_addr.sin_family=AF_INET;
       
       he=gethostbyname(host_name);
       bcopy ((char *)he->h_addr, (char *)&serv_addr.sin_addr, he->h_length);
       
       serv_addr.sin_port=htons(port);
       
       if ((sockfd=socket(AF_INET,SOCK_STREAM,0))<0)
       {
	      perror("socket() failure");
	      exit(-1);
       }
       
       if (connect(sockfd,(struct sockaddr *)&serv_addr,
		   sizeof(serv_addr))<0)
       {
	      perror("connect() failed");
	      exit(-1);
       }
       
       addrlen=sizeof(cli_addr2);
       if (getpeername(sockfd,(struct sockaddr *)&cli_addr2,&addrlen)<0)
       {
	      perror("getpeername() failed");
	      exit(-1);
       }
       if (cli_addr2.sin_family != AF_INET)
       {
	      perror("socket != AF_INET");
	      exit(-1);
       }
       hp=gethostbyaddr((char *)&cli_addr2.sin_addr,
			sizeof(struct in_addr), cli_addr2.sin_family);
       if (!hp)
       {
	      sprintf(host,"%s",inet_ntoa(cli_addr2.sin_addr));
	      fprintf(stderr,"Couldn't gethostbyaddr() origin ");
	      exit(-1);
       }
       sprintf(peer_name,"%s",hp->h_name);
       close(sockfd);
}

/**********************************************************************/

void get_res_ports(rh,rp,rd)
char *rh,*rp,*rd;
{
       int  port=8888;
       char host_name[MAX_STRING_SIZE];
       char peer_name[MAX_STRING_SIZE];
       char domain_name[MAX_STRING_SIZE];
       
       
       signal(SIGCHLD,SIG_IGN);
#ifdef SIGCLD
       signal(SIGCLD,SIG_IGN);
#endif
       
       if (gethostname(host_name,MAX_STRING_SIZE))
       {
	      perror("gethostname() failure");
	      exit(-1);
       }
       
       if (dqs_getdomainname(domain_name,MAX_STRING_SIZE))
	      perror("dqs_getdomainname() failure - continuing");
       
       port=start_server(port);
       start_client(port,host_name,peer_name);
       
       printf("\n\nhostname\t>%s<\npeername\t>%s<\ndomainname\t>%s<\n\n",
	      host_name,peer_name,domain_name);
       
       fflush(stdout);
       
       if (!domain_name[0])
       {
	      fprintf(stderr,"ERROR!: domainname NOT SET!\n");
	      fprintf(stderr,"\nsetting cell_name to hostname\n");
	      strcpy(domain_name,host_name);
       }
       
       if (!strstr(host_name,domain_name)){
	      fprintf(stderr,"warning: unqualified hostname or domain  \n");
	      fprintf(stderr,"name not set \n");
       }
       if (!strstr(peer_name,domain_name)){
	      fprintf(stderr,"warning: unqualified peername or domain \n");
	      fprintf(stderr,"name not set \n");
       }
       
       fflush(stderr);
       
       strcpy(rd,domain_name);
       strcpy(rh,host_name);
       strcpy(rp,peer_name);
       fflush(stdin);
       fflush(stdout);
       fflush(stderr);
       
       signal(SIGCHLD,SIG_DFL);
#ifdef SIGCLD
       signal(SIGCLD,SIG_DFL);
#endif
       
       return;
       
}

